<?php

namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\LotacaoCCusto;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Empresa;
use App\Modules\Natureza51\Entities\ContaContabilVSEventos;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes; 
use App\Modules\Natureza51\Entities\OrcParametros;

use \App\Core\Traits\ErrorTrait;

use Illuminate\Support\Facades\DB;

class RepoOrcScriptCloneOrc extends RepoOrcamento
{

    public function createCloneOrc($orcamento, $orc_id){
        
        $orcamento_param = [
            'ano' => $orcamento['ano'],
            'descricao' => $orcamento['descricao_orc'],
            'versao' => $orcamento['versao'],
            'revisao' => $orcamento['revisao'],
            'versao_desc' => $orcamento['versao_desc'],
            'revisao_desc' => $orcamento['revisao_desc'],
            'data_ini' => $orcamento['data_inicio'],
            'data_fim' => $orcamento['data_fim'],
            'mes_ini_frc' => $orcamento['mes_ini_frc'],
            'is_new_version' => $orcamento['is_new_version']
        ];

        $tipo = $orcamento['tipo'];
        $origem = array_key_exists('origem', $orcamento) ? $orcamento['origem'] : NULL ;

        // dd("gkerkgeorkg",$tipo,$origem);

        if($orcamento['tipo'] == 1 && $orcamento['origem'] == 2){
            $tipo_table = 'F';
            $periodo = $orcamento['periodo'];
        }
        else if ($orcamento['tipo'] == 1 && $orcamento['origem'] == 1){
            $tipo_table = 'O';
            $periodo = NULL; 
        }

        else if ($orcamento['tipo'] == 2 || $orcamento['tipo'] == 3){
            $tipo_table = 'O';
            $periodo = NULL; 
        }

        // dd("tipo e origem", $orcamento['tipo'], $orcamento['origem']);
        DB::beginTransaction();

        $clone_orc_id = $this->scriptProcedureInsertOrcamento($orc_id, $orcamento_param);
        
        if(!$clone_orc_id){
            DB::rollBack();
            return false;
        }
        DB::commit();

        DB::beginTransaction();
        // $clone_orc_id = $data_procedure['clone_orc_id'];

        $data_lotacao = $this->scriptInsertLotacao($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);
        if(!$data_lotacao){
            DB::rollBack();
            return $data_lotacao;
        }

        $data_cargos = $this->scriptInsertCargo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);

        if(!$data_cargos){
            DB::rollBack();
            return $data_cargos;
        }

        $cargo_salario = $this->scriptInsertCargosAreaSalario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);

        if(!$cargo_salario){
            DB::rollBack();
            return $cargo_salario;
        }

        // $salario_funcionario = $this->scriptInsertSalarioFuncionario($orc_id, $clone_orc_id);

        // if(!$salario_funcionario){
        //     DB::rollBack();
        //     return $salario_funcionario;
        // }

        $this->clearError();

        $result = [];

         
        $result[] = $this->scriptInsertBonus($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        $result[] = $this->scriptInsertBeneficio($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);     
        $result[] = $this->scriptInsertBeneficioLotCargo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);   
        $result[] = $this->scriptInsertBeneficioLotFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 

        
        $result[] = $this->scriptInsertDespesas($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);             
        $result[] = $this->scriptInsertPremissas($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertTurmaTurno($orc_id, $clone_orc_id, 1, $tipo, $tipo_table, $periodo);
        $result[] = $this->scriptInsertCloneHoraExtra($orc_id, $clone_orc_id, 1, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertEventos($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);   
        $result[] = $this->scriptInsertAcordoColetivo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);  
        $result[] = $this->scriptInsertSalarioFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);  
 

//daqui
        // $result[] = $this->scriptInsertHoraExtraEvento($orc_id, $clone_orc_id);    



        $result[] = $this->scriptInsertHeadcountHoraExtra($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertFerias($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertPromocao($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertContratacoes($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast
        $result[] = $this->scriptInsertDemissoes($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);// não está em forecast

// ate aqui não clona se tipo clone for 1
        $result[] = $this->scriptInsertParametros($orc_id, $clone_orc_id);// não está em forecast
        $result[] = $this->scriptInsertPPR($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        $result[] = $this->scriptInsertTurmaEvento($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        $result[] = $this->scriptInsertParamNatureza($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        // $result[] = $this->scriptInsertNaturezaEventos($orc_id, $clone_orc_id); 
        $result[] = $this->scriptInsertParamNaturezaEventosAdicionais($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        $result[] = $this->scriptInsertCronograma($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        // $result[] = $this->scriptInsertMovtoStatusCCusto($orc_id, $clone_orc_id); 
        // $result[] = $this->scriptInsertOrcNaturezaEventos($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        $result[] = $this->scriptInsertNaturezaEventos($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); 
        
        $result[] = $this->scriptInsertOrcFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); // se for tipo 1 não clona essa
        // $result[] = $this->scriptInsertOrcDiarioBordo($orc_id, $clone_orc_id);  
        $result[] = $this->scriptInsertOrcLotacaoCargoEvento($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);  
        $result[] = $this->scriptInsertOrcGestorAlternativo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);  
        // dd("chegou aqui mnlifdsnkjd");


        $result[] = $this->scriptInsertHeadcount($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo); // lembrar de descomentar essa pelo amor // não está em forecast //se for tipo clone 1 não clona essa      
        /*
            TABELAS DO ORÇAMENTO QUE NÃO POPULAM AO CLONAR: 
            -tbl_orc_resultados_calc
            -tbl_orc_diario_bordo
            -tbl_orc_notificacoes
            -tbl_orc_eventos_tipo
            -tbl_orc_status_ccusto
            -tbl_calc_orcamento
            -tbl_calc_indice
            -tbl_orc_status          
        */
        foreach ($result as $res) {
            if(!$res){
                DB::rollBack();
                return $res;
            }    
        }

        if($this->hasError()){
            DB::rollBack();
            return false;
        }

        DB::commit();
        return true;
        // $retorno["status"]="success";
        // $retorno["submsg"]="Sucesso!";
        // $retorno['msg']="Registro cadastrado com sucesso!";

        // saida:
        // return $retorno;       
    }

    public function scriptInsertLotacao($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){

        // dd("dados clone lotação", $orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);;
        $value = 'Falha ao inserir registros do Orçamento! Erro: 030320201605';
        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_lotacao :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo_st, :usuario_id";

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            // dd("olfpojfgopq","EXEC [dbo].[clone_orcamento_lotacao]
            // @id_orc = $orc_id,
            // @id_new_orc = $clone_orc_id,
            // @tipo_clone = $tipo,
            // @tipo_table = '$tipo_table',
            // @periodo_st = $periodo");

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_lotacao]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_clone = $tipo,
            @tipo_table = '$tipo_table',
            @periodo_st = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));

            // dd(DB::select("select * from tbl_orc_lotacao where orcamento_id = $clone_orc_id"));

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo_st', $periodo, \PDO::PARAM_STR );
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao inserir Lotação. Erro: 10022021030 | clone_orcamento_lotacao';
            //     // goto saida;
            //     $this->setError($value);
            //     $this->setSubError('Falha ao inserir Lotação. Erro: 10022021030 | clone_orcamento_lotacao');
            //     return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Lotação atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $this->deleteOrcamento($clone_orc_id);
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao inserir Lotação. Erro: 10022021020 - ' . 'clone_orcamento_lotacao'; 
            $this->setError('Falha ao inserir Lotação. Erro: 10022021020 - clone_orcamento_lotacao'.$e);
            $this->setSubError($e->getMessage());     
            return false;             
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    }

    public function scriptInsertCargo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 030320201442';

        //DB::beginTransaction();

        $periodo = is_null($periodo) ? 'NULL' : $periodo;
        try {    
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON ;
            EXEC	[dbo].[clone_orcamento_cargo]
                @id_orc = $orc_id,
                @id_new_orc = $clone_orc_id,
                @tipo_clone = $tipo,
                @tipo_table = '$tipo_table',
                @periodo = '$periodo',
                @usuario_id = {$this->fillModificadoPor()}
            ")); 
           
            // $sql="EXEC clone_orcamento_cargo :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 11022021812 | clone_orcamento_cargo';
            //     // goto saida;
            //     $this->setError($value);
            //     $this->setSubError('Falha ao atualizar registro. Erro: 11022021812 | clone_orcamento_cargo');
            //     return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]="Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 11022021809 - ' . 'clone_orcamento_cargo'; 
			$this->setError('Falha ao fazer inserir registro. Erro: 11022021809 - clone_orcamento_cargo');
			$this->setSubError($e->getMessage());     
			return false;            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    }

    public function scriptInsertCargosAreaSalario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 030320201530';

        //DB::beginTransaction();
        $periodo = is_null($periodo) ? "NULL" : "'$periodo'";

        try {                   
           
         $sql="EXEC clone_orcamento_cargos_area_sal :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            // $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_cargos_area_sal]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo,
            @usuario_id = {$this->fillModificadoPor()}"));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar clone_orcamento_cargos_area_sal. Erro: 100220200954';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar clone_orcamento_cargos_area_sal. Erro: 100220200954');
			// 	return false;
            // } 

            // $retorno["status"]="success"; 
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao inserir registro. Erro: 100220200948 - ' . 'clone_orcamento_cargos_area_sal';  
			$this->setError('Falha ao inserir registro. Erro: 100220200948 - clone_orcamento_cargos_area_sal');
			$this->setSubError($e->getMessage());     
			return false;            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;        
    }  

    public function scriptInsertAcordoColetivo($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Acordo Coletivo! Erro: 110320201618';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_dissidio :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_dissidio]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id, 
            @tipo_table = '$tipo_table',
            @periodo = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillModificadoPor()} "));

                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 110320201617 | clone_orcamento_dissidio';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 110320201617 | clone_orcamento_dissidio');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 110320201616 - ' . 'clone_orc_dissidio';            
			$this->setError('Falha ao fazer inserir registro. Erro: 110320201616 - ' . 'clone_orc_dissidio');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    

    }

    public function scriptInsertBeneficio($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 030320201527';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_beneficio :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_beneficio]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = '$periodo',
            @usuario_id = {$this->fillModificadoPor()}"));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220201000 | clone_orcamento_beneficio';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220201000 | clone_orcamento_beneficio');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";            
            // $this->setError($e);
            // $retorno['msg'] = 'Falha ao fazer inserir registro. Erro: 100220200955 - ' . 'clone_orcamento_beneficio';   
            // $retorno['submsg'] = $e;       
            // dd("TESTE", $e->getMessage())  ;
			$this->setError('Falha ao fazer inserir registro. Erro: 100220200955 - clone_orcamento_beneficio');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    
    }

    public function scriptInsertBeneficioLotCargo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela Benefícios! Erro: 030320201526';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_benef_lot_carg :orc_id, :clone_orc_id, :tipo_clone, :tipo_periodo, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? null : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_benef_lot_carg]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo_st = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillModificadoPor()} "));



                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220201015 | clone_orcamento_benef_lot_carg';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220201015 | clone_orcamento_benef_lot_carg');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {

            // dd("opopopopop", $e->getMessage());
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220201005 - ' . 'clone_orcamento_benef_lot_carg';            
			$this->setError('Falha ao fazer inserir registro. Erro: 100220201005 - clone_orcamento_benef_lot_carg'.$e->getMessage());
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    }

    public function scriptInsertBeneficioLotFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela Benefícios Por Funcionário! Erro: 120320201618';

        //DB::beginTransaction();
        try {                   
           
            $sql="EXEC clone_orcamento_benef_lot_func :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? NULL : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_benef_lot_func]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo_st = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 120320201619 | clone_orcamento_beneficio_fun';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 120320201619 | clone_orcamento_beneficio_func');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $this->setError($e);
            // $retorno['msg'] = 'Falha ao fazer inserir registro. Erro: 120320201620 - ' . 'clone_orcamento_benef_lot_func';
            // $retorno['submsg'] = $e;  
			$this->setError('Falha ao fazer inserir registro. Erro: 120320201620 - ' . 'clone_orcamento_benef_lot_func');
			$this->setSubError($e->getMessage());     
			return false;            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    

    }

    public function scriptInsertBonus($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Bonus! Erro: 110320201724.';

        //DB::beginTransaction();

        $periodo = is_null($periodo) ? 'NULL' : $periodo;
        try {    
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON ;
            EXEC	[dbo].[clone_orcamento_bonus]
                @id_orc = $orc_id,
                @id_new_orc = $clone_orc_id,
                @tipo_table = '$tipo_table',
                @periodo = '$periodo',   
                @tipo_clone = $tipo,
                @usuario_id = {$this->fillModificadoPor()}

            ")); 
           

        // try {                   
           
        //     $sql="EXEC clone_orcamento_bonus :orc_id, :clone_orc_id, :tipo_table, :tipo_clone, :periodo";

        //     $stmt=DB::getPdo()->prepare($sql);
        //     $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
        //     $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
        //     $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
        //     $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
        //     $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );



                                        
        //     if(!$stmt->execute()){
        //         // $retorno["status"]="error";
        //         // $retorno['msg'] = $this->setError($value);
        //         // $retorno['submsg']='Falha ao atualizar registro. Erro: 110320201726 | clone_orcamento_bonus';
        //         // goto saida;
		// 		$this->setError($value);
		// 		$this->setSubError('Falha ao atualizar registro. Erro: 110320201726 | clone_orcamento_bonus');
		// 		return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 110320201727 - ' . 'clone_orc_bonus';            
			$this->setError('Falha ao fazer inserir registro. Erro: 110320201727 - ' . 'clone_orc_bonus');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    }

    public function scriptInsertCloneHoraExtra($orc_id, $clone_orc_id, $user_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Hora Extra! Erro: 030320201625';

        //DB::beginTransaction();
        $user_id = $this->fillModificadoPor();
        try {                   
           
            $sql="EXEC clone_hora_extra :orc_id, :clone_orc_id, :user, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':user', $user_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_hora_extra]
            @id_orc = $orc_id,
            @new_orc_id = $clone_orc_id,
            @user = $user_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo"));


            
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 28022021130 | clone_hora_extra';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 28022021130 | clone_hora_extra');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 28022021119 - ' . 'clone_hora_extra';            
			$this->setError('Falha ao fazer inserir registro. Erro: 28022021119 - ' . 'clone_hora_extra');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno; 
    }

    public function scriptInsertContratacoes($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Contratações! Erro: 030320201532';

        // dd("sfsnfknsdkfs", $orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_contratacoes :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;


            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_contratacoes]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));

                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200944 | clone_orcamento_contratacoes';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220200944 | clone_orcamento_contratacoes');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220200942 - ' . 'clone_orcamento_contratacoes';            
			$this->setError('Falha ao fazer inserir registro. Erro: 100220200942 - clone_orcamento_contratacoes');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }
   
    public function scriptInsertCronograma($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Cronograma! Erro: 200720201558.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_cronograma :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? "NULL" : "'$periodo'";

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_cronograma]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo,
            @usuario_id = {$this->fillCriadoPor()} "));


            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201558 | clone_orcamento_cronograma';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 200720201558 | clone_orcamento_cronograma');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201558 - ' . 'clone_orcamento_cronograma';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200720201558 - ' . 'clone_orcamento_cronograma');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    

    }

    public function scriptInsertDemissoes($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Contratações! Erro: 030320201535';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_demissoes :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_demissoes]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200940 | clone_orcamento_demissoes';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220200940 | clone_orcamento_demissoes');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020938 - ' . 'clone_orcamento_demissoes';   
			$this->setError('Falha ao fazer inserir registro. Erro: 10022020938 - ' . 'clone_orcamento_demissoes');
			$this->setSubError($e->getMessage());     
			return false;           
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;  
    }

    public function scriptInsertDespesas($orc_id, $clone_orc_id,  $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Despesas! Erro: 030320201540';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_despesas :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? NULL : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_despesas]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200936 | clone_orcamento_despesas';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220200936 | clone_orcamento_despesas');
			// 	return false;
            // } 
            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020932 - ' . 'clone_orcamento_despesas';  
			$this->setError('Falha ao fazer inserir registro. Erro: 10022020932 - ' . 'clone_orcamento_despesas');
			$this->setSubError($e->getMessage());     
			return false;            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit(); 

        /**COMENTADO POIS APARENTEMENTE JÁ POPULA A CALC_ORCAMENTO NA PROCEDURE clone_orcamento_despesas */
        // if($retorno['status'] =="success"){
        //     $this->scriptInsertCalcOrcDespesas($orc_id, $clone_orc_id);
        // }

        return true;//$retorno;     
    }
    
    public function scriptInsertEventos($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Controle de Eventos! Erro: 030320201545';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_eventos :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            
            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_eventos]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200931 | clone_orcamento_eventos';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220200931 | clone_orcamento_eventos');
			// 	return false;
            // } 

            $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020928 - ' . 'clone_orcamento_eventos';            
			$this->setError('Falha ao fazer inserir registro. Erro: 10022020928 - ' . 'clone_orcamento_eventos');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        
        if($retorno['status'] == 'success'){
            return $this->scriptInsertCalcOrcEventos($orc_id, $clone_orc_id);
        }
		return true;//$retorno;     
    }

    public function scriptInsertFerias($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Férias! Erro: 030320201517';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_ferias :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            
            $periodo = is_null($periodo) ? "NULL" : "'$periodo'";

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_ferias]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = $periodo,
            @usuario_id = {$this->fillModificadoPor()} "));

            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_ferias';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_ferias');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_ferias';            
			$this->setError('Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_ferias');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;   
    }

    public function scriptInsertHeadcount($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount! Erro: 030320201550';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_headcount :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";


            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_headcount]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillCriadoPor()} "));

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
            
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020927 | clone_orcamento_headcount';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 10022020927 | clone_orcamento_headcount');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
            
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020925 - ' . 'clone_orcamento_headcount';            
			$this->setError('Falha ao fazer inserir registro. Erro: 10022020925 - ' . 'clone_orcamento_headcount');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }
   
    public function scriptInsertHeadcountHoraExtra($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Hora Extra! Erro: 030320201555';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_hora_extra :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_hora_extra]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo,
            @usuario_id = {$this->fillModificadoPor()} "));


            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020921 | clone_orcamento_hora_extra';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 10022020921 | clone_orcamento_hora_extra');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 100220200919 - ' . 'clone_orcamento_hora_extra';            
			$this->setError('Falha ao fazer inserir registro. Erro: 100220200919 - ' . 'clone_orcamento_hora_extra');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }

    public function scriptInsertOrcFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros do Orçamento Funcionario! Erro: 081020201810';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_funcionario :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;
              
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_funcionario]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));

                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 081020201811 | clone_orcamento_funcionario';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 081020201811 | clone_orcamento_funcionario');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 081020201812 - ' . 'clone_orcamento_funcionario';            
            // dd($e->getMessage());
			$this->setError('Falha ao fazer inserir registro. Erro: 081020201812 - ' . 'clone_orcamento_funcionario');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }

    public function scriptInsertOrcGestorAlternativo($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros do Orçamento Gestor alternativo! Erro: 131020201112';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_gestor_alternativo :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            
            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_gestor_alternativo]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo,
            @usuario_id = {$this->fillCriadoPor()} "));

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 131020201113 | clone_orcamento_gestor_alternativo';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 131020201113 | clone_orcamento_gestor_alternativo');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 131020201114 - ' . 'clone_orcamento_gestor_alternativo';            
			$this->setError('Falha ao inserir registro. Erro: 131020201114 - ' . 'clone_orcamento_gestor_alternativo'.$e);
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }

    public function scriptInsertOrcLotacaoCargoEvento($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros do Orçamento Lotacao Cargo Evento! Erro: 081020201827';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_lotacao_cargo_evento :id_orc, :id_new_orc, :tipo_clone, :tipo_table, :periodo";

            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_lotacao_cargo_evento]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo_st = $periodo,
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillCriadoPor()} "));

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':id_orc', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':id_new_orc', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 081020201828 | clone_orcamento_lotacao_cargo_evento';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 081020201828 | clone_orcamento_lotacao_cargo_evento');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 081020201829 - ' . 'clone_orcamento_lotacao_cargo_evento';            
			$this->setError('Falha ao fazer inserir registro. Erro: 081020201829 - ' . 'clone_orcamento_lotacao_cargo_evento');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }

    public function scriptInsertNaturezaEventos($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Natureza/Eventos! Erro: 200720201516.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_natureza_eventos :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";
            
            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_natureza_eventos]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo = $periodo,
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillCriadoPor()} "));

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                                        
            // if(!$stmt->execute()){
            //     $retorno["status"]="error";
            //     $retorno['msg'] = $this->setError($value);
            //     $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201517 | clone_orcamento_natureza_eventos';
            //     goto saida;
            // } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201518 - ' . 'clone_orcamento_natureza_eventos';            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;     

    }

    public function scriptInsertParamNaturezaEventosAdicionais($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Eventos Adicionais da Natureza! Erro: 200720201531.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_param_natureza_eventos_adicionais :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? "NULL" : "'$periodo'";

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_param_natureza_eventos_adicionais]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo_st = $periodo,
            @usuario_id = {$this->fillCriadoPor()} "));


                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201532 | clone_orcamento_param_natureza_eventos_adicionais';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 200720201532 | clone_orcamento_param_natureza_eventos_adicionais');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201533 - ' . 'clone_orcamento_param_natureza_eventos_adicionais';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200720201533 - ' . 'clone_orcamento_param_natureza_eventos_adicionais');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    

    }

    public function scriptInsertPremissas($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Premissias! Erro: 030320201610';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_premissas :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_premissas]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020912 | clone_orcamento_premissas';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 10022020912 | clone_orcamento_premissas');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020910 - ' . 'clone_orcamento_premissas';            
			$this->setError('Falha ao fazer inserir registro. Erro: 10022020910 - clone_orcamento_premissas');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;    
    }

    public function scriptInsertPromocao($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Headcount Promoção! Erro: 08022021217';

        // dd("njshgunsg", $orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo);

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_promocao :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";
            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );
                         
            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_promocao]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = $periodo,
            @usuario_id = {$this->fillModificadoPor()} "));

            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_promocao';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 08022021218 | clone_orcamento_promocao');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_promocao';            
			$this->setError('Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_promocao');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno; 
    }

    public function scriptInsertSalarioFuncionario($orc_id, $clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Aumentos Salariais! Erro: 08022021215';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_salario_funcionario :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? NULL : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_salario_funcionario]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo_st = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 100220200856 | clone_orcamento_salario_funcionario';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 100220200856 | clone_orcamento_salario_funcionario');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 08022021216 - ' . 'clone_orcamento_salario_funcionario';            
			$this->setError('Falha ao fazer inserir registro. Erro: 08022021216 - clone_orcamento_salario_funcionario');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return true;//$retorno;   
    }

    public function scriptInsertTurmaTurno($orc_id, $clone_orc_id, $user, $tipo, $tipo_table, $periodo){
        $value  = 'Falha ao inserir registros na tela Tuma/Turno! Erro: 030320201442';

        //DB::beginTransaction();
        $user = $this->fillModificadoPor();
        try {                   
           
            $sql="EXEC clone_orc_turma :orc_id, :new_orc_id, :user, :tipo_clone, :tipo_table, :periodo";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':new_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user', $user, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orc_turma]
            @id_orc = $orc_id,
            @new_orc_id = $clone_orc_id,
            @user = {$this->fillModificadoPor()},
            @tipo_table = '$tipo_table',
            @periodo = '$periodo',
            @tipo_clone = $tipo"));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 180320201508 | clone_orc_turma';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 180320201508 | clone_orc_turma');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]="Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 180320201508 - ' . 'clone_orc_turma';            
			$this->setError('Falha ao fazer inserir registro. Erro: 180320201508 - ' . 'clone_orc_turma');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;  
    }
    
    public function scriptInsertParametros($orc_id, $clone_orc_id){
        $parametrosOrc = OrcParametros::where('orcamento_id', $orc_id)->get();
        $hasErro = false;
        $retorno = null;
        // DB::transaction(function()use($parametrosOrc, $clone_orc_id, &$hasErro, &$retorno) {
            foreach ($parametrosOrc as $param) {
                $result = OrcParametros::insert([
                    'parametro_id'=>$param->parametro_id,
                    'orcamento_id'=>$clone_orc_id,
                    'valor_parametro'=>$param->valor_parametro,
                    'created_by'=>$this->fillCriadoPor(),//$param->created_by,
                    'empresa_id'=>$param->empresa_id,
                    'created_at'=>$this->fillCriadoEm()
                ]);
                if(!$result){
                    $hasErro = true;
                    // $retorno["status"]="error";
                    // $retorno['msg'] = OrcParametros::getErrosFlatted();
                    // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 020420201015';
                    // abort(500,'Falha ao inserir registro. Erro: 020420201016.');   
                    $this->setError('Falha ao fazer inserir registro. Erro: 020420201015');
                    $this->setSubError(OrcParametros::getErrosFlatted());
                    return false;
                } 
            }
        // });

        if($hasErro){
            return false;
        }
        // $retorno["status"]="success";
        // $retorno["msg"]="Registro atualizado com sucesso!";
		return true;//$retorno;   

    }

    public function scriptInsertParamNatureza($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Parametros/Natureza! Erro: 200720201500.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_param_natureza :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_param_natureza]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @tipo_clone = $tipo,
            @periodo = '$periodo',
            @usuario_id = {$this->fillModificadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201501 | clone_orcamento_param_natureza';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 200720201501 | clone_orcamento_param_natureza');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201502 - ' . 'clone_orcamento_param_natureza';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200720201502 - ' . 'clone_orcamento_param_natureza');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    
    }
  
    public function scriptInsertPPR($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela PL! Erro: 200720201423.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_ppr :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : "'$periodo'";

           

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_ppr]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo_st = $periodo,
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillCriadoPor()}"));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201424 | clone_orcamento_ppr';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 200720201424 | clone_orcamento_ppr');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201425 - ' . 'clone_orcamento_ppr';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200720201425 - ' . 'clone_orcamento_ppr');
			$this->setSubError($e->getMessage());     
			return false; 
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;    

    }

    public function scriptInsertTurmaEvento($orc_id,$clone_orc_id, $tipo, $tipo_table, $periodo){
        $value = 'Falha ao inserir registros na tela Turma/Eventos! Erro: 200720201434.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_turma_evento :orc_id, :clone_orc_id, :tipo_clone, :tipo_table, :periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_clone', $tipo, \PDO::PARAM_INT );
            // $stmt->bindParam(':tipo_table', $tipo_table, \PDO::PARAM_STR );
            // $stmt->bindParam(':periodo', $periodo, \PDO::PARAM_STR );

            $periodo = is_null($periodo) ? 'NULL' : $periodo;

            $res = DB::statement(DB::raw("
            SET NOCOUNT ON;
            EXEC [dbo].[clone_orcamento_turma_evento]
            @id_orc = $orc_id,
            @id_new_orc = $clone_orc_id,
            @tipo_table = '$tipo_table',
            @periodo = '$periodo',
            @tipo_clone = $tipo,
            @usuario_id = {$this->fillCriadoPor()} "));
                                        
            // if(!$stmt->execute()){
            //     // $retorno["status"]="error";
            //     // $retorno['msg'] = $this->setError($value);
            //     // $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201435 | clone_orcamento_turma_evento';
            //     // goto saida;
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao atualizar registro. Erro: 200720201435 | clone_orcamento_turma_evento');
			// 	return false;
            // } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201436 - ' . 'clone_orcamento_turma_evento';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200720201436 - ' . 'clone_orcamento_turma_evento');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;   

    }   

    public function scriptInsertMovtoStatusCCusto($orc_id,$clone_orc_id){
        $value = 'Falha ao inserir registros nas movimentações dos centros de custos! Erro: 200720201608.';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_movto_status_ccusto :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 200720201609 | clone_orcamento_movto_status_ccusto';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200720201610 - ' . 'clone_orcamento_movto_status_ccusto';            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;     

    }    

    public function scriptInsertHoraExtraEvento($orc_id, $clone_orc_id){
        $value = 'Falha ao inserir registros na tela Hora Extra! Erro: 030320201600';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_hora_extra_evento :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 10022020917 | clone_orcamento_hora_extra_evento';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 10022020915 - ' . 'clone_orcamento_hora_extra_evento';            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }    
 
    public function scriptProcedureInsertOrcamento($id_orc, $orcamento_param = ["ano", "descricao", "versao", "versao_desc", "revisao", "revisao_desc", "data_inicio", "data_fim", "mes_ini_frc", "is_new_version"]){        
        /**
         * Criado uma procedure de insert no banco natureza.
         */

        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('ano'),'=',$orcamento_param['ano']],
            [$this->getModelEntity()->getColunaAlias('versao_desc'),'=',$orcamento_param['versao_desc']],
            [$this->getModelEntity()->getColunaAlias('revisao_desc'),'=',$orcamento_param['revisao_desc']],
            [$this->getModelEntity()->getColunaAlias('status_orc'),'!=',12]
        ])->get()->toArray();

        if(count($select) > 0){
            // $retorno['msg'] = 'Os valores inseridos em Ano, Versão e Revisão já foram cadastrados. Erro: 240420201246';
            // $retorno['submsg'] = 'Erro';
            // $retorno['status'] = 'error';
            // goto saida;
            $this->setError('Os valores inseridos em Ano, Versão e Revisão já foram cadastrados. Erro: 240420201246');
            return false;
        }

        if($orcamento_param['is_new_version']==true){
            $select_versao=$this->getModelEntity()->select(DB::raw('count(*) + 1 as versao_count'))
            ->where($this->getModelEntity()->getColunaAlias('ano'),'=',$orcamento_param['ano'])
            ->groupBy($this->getModelEntity()->getColunaAlias('versao'))
            ->get()->toArray();
            
            $orcamento_param['versao']=$select_versao[0]['versao_count'];
            $orcamento_param['revisao']="1";

        }
        unset($orcamento_param['is_new_version']);
        
        $value = 'Falha ao inserir registros na tela Orçamento! Erro: 030320201620';
        //DB::beginTransaction();

        try {                   
            $usuario_id = $this->fillModificadoPor();
            $sql="EXEC insert_orcamento :id_orc, :ano, :descricao, :versao, :versao_desc, :revisao, :revisao_desc, :mes_ini_frc, :output, :usuario_id";
            
            $stmt=DB::getPdo()->prepare($sql);
            
            $stmt->bindParam(':id_orc', $id_orc, \PDO::PARAM_INT );
            $stmt->bindParam(':ano', $orcamento_param['ano'], \PDO::PARAM_INT );
            $stmt->bindParam(':descricao', $orcamento_param['descricao'], \PDO::PARAM_STR );
            $stmt->bindParam(':versao', $orcamento_param['versao'], \PDO::PARAM_STR );
            $stmt->bindParam(':versao_desc', $orcamento_param['versao_desc'], \PDO::PARAM_STR );
            $stmt->bindParam(':revisao', $orcamento_param['revisao'], \PDO::PARAM_STR );
            $stmt->bindParam(':revisao_desc', $orcamento_param['revisao_desc'], \PDO::PARAM_STR );
            //$stmt->bindParam(':data_ini', $orcamento_param['data_ini'], \PDO::PARAM_STR );
            // $stmt->bindParam(':data_fim', $orcamento_param['data_fim'], \PDO::PARAM_STR );
            $stmt->bindParam(':mes_ini_frc', $orcamento_param['mes_ini_frc'], \PDO::PARAM_STR );
            $stmt->bindParam(':output', $output_procedure,  \PDO::PARAM_INT,  \PDO::SQLSRV_PARAM_OUT_DEFAULT_SIZE);
            $stmt->bindParam(':usuario_id', $usuario_id,  \PDO::PARAM_INT);
            //dd($orcamento_param,$stmt);
            if(!$stmt->execute()){
                // $retorno["status"]="error";
                // $retorno['msg'] = $this->setError($value);
                // $retorno['submsg']='Falha ao Clonar o Orçamento! Erro: 030320201130 | insert_orcamento' .$output_procedure;
                // goto saida;
                $this->setError($value);
                $this->setSubError('Falha ao Clonar o Orçamento! Erro: 030320201130 | insert_orcamento' .$output_procedure);
                return false;
            } 

            if($output_procedure == null){
                //DB::rollBack();
                // $retorno["status"]="error";
                // $retorno['msg'] = "Falha ao Clonar o Orçamento! Erro 141020200733";
                // $retorno['submsg']='Falha ao atualizar registro Orçamento. Erro: 310120201126' .$output_procedure;
                // goto saida;
                $this->setError('Falha ao Clonar o Orçamento! Erro 141020200733');
                return false;
            }
            
            // $retorno["status"]="success";
            // $retorno["msg"]=" Orçamento atualizado com sucesso!";
            $retorno["clone_orc_id"]=$output_procedure;
            
        } catch (\Exception $e) {
            // dd($e->errorInfo[2]);
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = 'Falha ao Clonar o Orçamento. Erro: 310120201122';
            // $retorno['submsg']='Falha ao fazer inserir Orçamento. Erro: 310120201123 - ' . $output_procedure;   
            $this->setError('Falha ao Clonar o Orçamento. Erro: 310120201122');
            $this->setSubError($e->getMessage());     
            return false;    
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        
        return $retorno["clone_orc_id"];                         
    }
    
    public function scriptInsertCalcOrcEventos($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Controle de Eventos! Erro: 200320201350';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_calc_orcamento_eventos :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                // $retorno["status"]="error";
                // $retorno['msg'] = $this->setError($value);
                // $retorno['submsg']='Falha ao atualizar registro. Erro: 200320201350 | clone_calc_orcamento_eventos';
                // goto saida;
				$this->setError($value);
				$this->setSubError('Falha ao atualizar registro. Erro: 200320201350 | clone_calc_orcamento_eventos');
				return false;
            } 

            // $retorno["status"]="success";
            // $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            // $retorno["status"]="error";
            // $retorno['msg'] = $this->setError($value);
            // $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200320201350 - ' . 'clone_calc_orcamento_eventos';            
			$this->setError('Falha ao fazer inserir registro. Erro: 200320201350 - ' . 'clone_calc_orcamento_eventos');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
		return true;//$retorno;   

    }
    
    public function scriptInsertCalcOrcDespesas($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros na tela Despesas Adicionais! Erro: 200320201431';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_calc_orcamento_despesas :orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 200320201431 | clone_calc_orcamento_despesas';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 200320201431 - ' . 'clone_calc_orcamento_despesas';            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    

    }

    public function scriptInsert($table_entitie, $select, $colunas, $orc_id){        
        // sequencia das colunas devem seguir a sequencia da select.
        $table = $table_entitie->getTable();
        
        $insert = DB::raw("
                INSERT INTO $table (                   
                    $colunas
                    , created_at
                    , updated_at
                    ) 
            " . $select );             
        
        // dd("insert", $insert);
        //DB::beginTransaction();

        try {

            $result = DB::connection()->insert(
                $insert , [$orc_id]
            );            

            if(!$result){
                $retorno["status"]="error";
                $retorno['msg'] = $table_entitie->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer inserir registro. Erro: 30012021510';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";  
            $retorno["id_inserido"] = $result;
        } catch (\Exception $e) {
            //DB::rollBack();
            // dd("asdfasdfasdfasdfasdf". $e);
            abort(500,'Falha ao inserir registro. Erro: 30012021515.'.$e);   
        }
        saida:
         
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
          
        return $retorno;   
    }
    
    public function scriptSelectInsert($param_select_insert){
        // sequencia das colunas devem seguir a sequencia do insert.
        $colunas = '';
        $from = '';
        $where = '';
        $group_by = '';
        $order_by = '';

        if(isset($param_select_insert['colunas']) && !is_null($param_select_insert['colunas'])){
            $colunas = $param_select_insert['colunas'];            
        }
        if(isset($param_select_insert['from']) && !is_null($param_select_insert['from'])){
            $from = $param_select_insert['from'];            
        }
        if(isset($param_select_insert['where']) && !is_null($param_select_insert['where'])){
            $where = $param_select_insert['where'];            
        }
        if(isset($param_select_insert['group_by']) && !is_null($param_select_insert['group_by'])){
            $group_by = $param_select_insert['group_by'];            
        }
        if(isset($param_select_insert['order_by']) && !is_null($param_select_insert['order_by'])){
            $order_by = $param_select_insert['order_by'];            
        }
        
        $select = "select 
                        {$colunas}
                        , getDate() created_at
                        , NULL updated_at  
                    FROM                       
                    {$from}
                    {$where}
                    {$group_by}
                    {$order_by}
            ";
        return $select;
    }

    public function scriptMergeInsertUpdate($table_entitie, $select, $array_merge){
        $table = $table_entitie->getTable();
        
        $array_on_colunas_chave_ex_primaria = '';
        $array_campos_update = '';
        $array_colunas_insert = '';
        $array_value_insert = '';
        
        for($i = 0; $i < count($array_merge['array_on_colunas_chave_ex_primaria']); $i++){
            ($i==0) ? $array_on_colunas_chave_ex_primaria .= " target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} " :
                      $array_on_colunas_chave_ex_primaria .= " AND target.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]}=
                                                 source.{$array_merge['array_on_colunas_chave_ex_primaria'][$i]} ";
        }
        
        for($i = 0; $i < count($array_merge['array_campos_update']); $i++){
            $up = '';
            ($array_merge['array_campos_update'][$i]=='updated_at') ? $up = "getDate()" : $up = "source.{$array_merge['array_campos_update'][$i]}";
            ($i==0) ? $array_campos_update .= " target.{$array_merge['array_campos_update'][$i]}=
                                                source.{$array_merge['array_campos_update'][$i]} " :
                      $array_campos_update .= " , target.{$array_merge['array_campos_update'][$i]}=
                                                    {$up} ";
        }
        
        for($i = 0; $i < count($array_merge['array_colunas_insert']); $i++){
            ($i==0) ? $array_colunas_insert .= " {$array_merge['array_colunas_insert'][$i]} " :
                      $array_colunas_insert .= ", {$array_merge['array_colunas_insert'][$i]} ";

            ($i==0) ? $array_value_insert .= " source.{$array_merge['array_colunas_insert'][$i]} " :
                      $array_value_insert .= ", source.{$array_merge['array_colunas_insert'][$i]} ";
        }
        
        $merge = "
        MERGE {$table} as target
                USING
                (
                    {$select}
                ) AS source
                ON
                    {$array_on_colunas_chave_ex_primaria}
                WHEN MATCHED 
                    THEN UPDATE SET
                        {$array_campos_update}
                WHEN NOT MATCHED BY target
                    THEN
                        INSERT (
                            {$array_colunas_insert}
                            )values(
                            {$array_value_insert}
                            )
            ;
        ";
        
        //DB::beginTransaction();

        try {
              
            $pdo = DB::connection()->getPdo();
           
            $query = $pdo->prepare($merge);
            // dd('merge', $query);
            if ($query->execute()) { 
                $count = $query->rowCount();
            }               
            
            if(!$query){
                $retorno["status"]="error";
                $retorno['msg'] = implode(",", $query->errorInfo());
                $retorno['submsg']='Falha ao atualizar registro. Erro: 310120201126';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]="{$count} Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = 'Falha ao atualizar registro. Erro: 310120201122';
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 310120201123 - ' .implode(",", $query->errorInfo());            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd('retorno', $retorno);
        return $retorno; 
        
    }

    public function getTableAlias($alias, $entitie){
        $alias_table = $entitie->getTable().'_'.$alias;
        $tb_alias = $entitie->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_table}";

        $result = [
            'alias' => $alias_table,
            'table' => $tb_alias
        ];
        return $result;
    }   

    public function colEntitie($entitie, $campos_remover){
        $result = implode(',', array_diff($entitie->getNomeColunas(), $campos_remover));

        return $result;
    }

    public function colEntitieSelectDiff($entitie, $campos_remover){
        $result = array_diff($entitie->getNomeColunas(), $campos_remover);

        return $result;
    }

    public function deleteOrcamento($orc_id){        
        $Orcamento = new Orcamento();

        //DB::beginTransaction();
       
        try{
            
            if(!$Orcamento->deleteParent($data['id'])){  
                $this->setError('Falha ao deletar o Orçamento. Erro: 030320201105 ' .$this.getErrosFlatted());
                //DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (Exception $ex) {
                //DB::rollBack();
                abort(500,'Falha ao deletar o Orçamento. Erro: 080120201624.');
        }
        
        return array('msg'=>"Orçamento deletado!",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function scriptInsertOrcDiarioBordo($orc_id, $clone_orc_id){
        $value  = 'Falha ao inserir registros do Diario Bordo! Erro: 081020201807';

        //DB::beginTransaction();

        try {                   
           
            $sql="EXEC clone_orcamento_diario_bordo:orc_id, :clone_orc_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $clone_orc_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 081020201808 | clone_orcamento_diario_bordo';
                goto saida;
            } 

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";
    
        } catch (\Exception $e) {
            //DB::rollBack();
            $retorno["status"]="error";
            $retorno['msg'] = $this->setError($value);
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 081020201809 - ' . 'clone_orcamento_diario_bordo';            
        }
        saida:
        //($retorno['status'] == 'error')? DB::rollBack() : DB::commit();  
        // dd("insert clone", $retorno);
        return $retorno;    
    }

}
