<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoTurno;
use App\Modules\Natureza51\Repositories\RepoTurma;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Repositories\RepoOrcScriptCalculos;
use Illuminate\Support\Facades\DB;

class RepoOrcTurma extends RepoOrcamento {

    protected $model_name_space='App\Modules\Natureza51\Entities\OrcTurma';     

    public function listOrcTurma($orc_id, $periodo = null, $tipo_table = 'O'){  

        $query = $this->getModelEntity()::with([
            'getTurno'=>function($query){
            }
        ])
        ->where([
            ['orc_id', $orc_id],
            ['tipo_table', $tipo_table]
        ]);
      
        $return = [];
        if($tipo_table == 'F'){
            $query->where('periodo',$periodo);
        }
        else{
            $query->whereNull('periodo');
        }

        $return = $query->get()->toArray();

        for ($i=0; $i < count($return) ; $i++) { 

            $return[$i]['des_turno_trab']=$return[$i]['get_turno']['des_turno_trab'];
            $return[$i]['cdn_turno_trab']=$return[$i]['get_turno']['cdn_turno_trab'];
            
            // $return[$i]['des_turno_trab']=$return[$i]['get_turno']['des_turno_trab'];
            $return[$i]['description']=$return[$i]['cdn_turma_trab']. ' - ' .$return[$i]['des_turma_trab']. ' - '.$return[$i]['get_turno']['cdn_turno_trab'] . ' - ' . $return[$i]['get_turno']['des_turno_trab'] ;
            // $return[$i]['des_turma_trab']=$return[$i]['des_turma_trab'];
            unset($return[$i]['get_turno']);
        }      
    
        return $return;
    }    

    public function listOrcGroupTurma($orc_id, $periodo = null, $tipo_table = 'O'){        
        $turma = new Turma();
        $query = $this->getModelEntity()->join(
            $turma->getTable(),
            $turma->getColunaAlias('id'),'=', $this->getModelEntity()->getColunaAlias('turma_id')
            )
            ->select(
                $this->getModelEntity()->getColunaAlias('des_turma_trab'),
                DB::raw('COUNT(*) qtd_turnos'),
                'tipo_table', 'periodo'
            )
            ->where('orc_id', $orc_id)
            ->where('tipo_table', $tipo_table);
        
        $result = null;
        if($tipo_table == 'F'){
          $result = $query->where('periodo', $periodo)
          ->groupBy($this->getModelEntity()->getColunaAlias('des_turma_trab'), 'tipo_table', 'periodo')
          ->orderBy('qtd_turnos','desc')
          ->get()->toArray();
        }
        else{
          $result = $query->whereNull('periodo')
          ->groupBy($this->getModelEntity()->getColunaAlias('des_turma_trab'), 'tipo_table', 'periodo')
          ->orderBy('qtd_turnos','desc')
          ->get()->toArray();
        }
            
        
        return $result;
        
      }

      public function populaOrcTurma($orc_id, $periodo = null, $tipo_table = 'O'){
        
        $repo_orc_script_calculos = new RepoOrcScriptCalculos();  
 
        $result = $repo_orc_script_calculos->insertOrcTurma($orc_id, $periodo, $tipo_table);  

        if($result["status"]!="success"){                       
            $retorno['msg']='Falha ao inserir o registro. Erro:030420201931';
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:030420201931';
            goto saida;
        }
          
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Atualizado com sucesso!";
        
        saida:
        return $retorno;        
    }

      
    
}
