<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcTurmaEvento;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\OrcEvento;
use App\Modules\Natureza51\Entities\Evento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;

use Illuminate\Support\Facades\DB;

class RepoOrcTurmaEvento extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcTurmaEvento';
    protected $form_rules=[];
    protected $rules_msg=[]; 

    public function listarOrcTurmaEvento($orc_id, $periodo, $tipo_table){
        
        $filtrar_periodo = $tipo_table == 'O' ? ' IS NULL ' : " = '".$periodo."' ";

        $query = "SELECT 
        ot.id as turma_id,
        oe.id as evento_id,
        e.des_event as desc_evento,
        CONCAT(t.des_turma_trab, ' - ',  tn.des_turno_trab) as desc_turma,

        CONCAT( t.cdn_turma_trab, ' - ', t.des_turma_trab ,' - ', tn.cdn_turno_trab, ' - ',  tn.des_turno_trab  ) as des_turma,
        CONCAT( e.cdn_event, ' - ',  e.des_event) as des_evento,

        ote.qtd_hrs as horas,
        ote.id as id,

        isnull( format (c.[jan_orcado], 'N', 'pt-br'), 0) jan,
        isnull( format (c.[fev_orcado], 'N', 'pt-br'), 0) fev,
        isnull( format (c.[mar_orcado], 'N', 'pt-br'), 0) mar,
        isnull( format (c.[abr_orcado], 'N', 'pt-br'), 0) abr,
        isnull( format (c.[mai_orcado], 'N', 'pt-br'), 0) mai,
        isnull( format (c.[jun_orcado], 'N', 'pt-br'), 0) jun,
        isnull( format (c.[jul_orcado], 'N', 'pt-br'), 0) jul,
        isnull( format (c.[ago_orcado], 'N', 'pt-br'), 0) ago,
        isnull( format (c.[set_orcado], 'N', 'pt-br'), 0) 'set',
        isnull( format (c.[out_orcado], 'N', 'pt-br'), 0) out,
        isnull( format (c.[nov_orcado], 'N', 'pt-br'), 0) nov,
        isnull( format (c.[dez_orcado], 'N', 'pt-br'), 0) dez,

        CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por,
        CASE WHEN ote.created_at IS NOT NULL THEN format(ote.created_at, 'dd/MM/yyyy') ELSE '-' END as criado_em,
        
        CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por,
        CASE WHEN c.updated_at IS NOT NULL THEN format(c.updated_at, 'dd/MM/yyyy') ELSE '-' END as atualizado_em
        
        from tbl_orc_turma_evento ote
        inner join tbl_orc_turma ot on ote.turma_id = ot.id and ot.tipo_table = ote.tipo_table and ot.periodo $filtrar_periodo
        inner join tbl_orc_eventos oe on ote.evento_id = oe.id and oe.tipo_table = ote.tipo_table and oe.periodo $filtrar_periodo
        inner join tbl_eventos e on oe.evento_id = e.id
        inner join tbl_turma t on ot.turma_id = t.id 
        inner join tbl_turno tn on tn.id = ot.turno_id
        inner join [dbo].[tbl_calc_orcamento] c on ote.id = c.origem_id and 'tbl_orc_turma_evento' = c.tbl_origem   
        
        left join institb_usuario as usuario1 on usuario1.id = ote.created_by
        left join institb_usuario as usuario2 on usuario2.id = c.updated_by
        where ote.orc_id = $orc_id and ote.tipo_table = '$tipo_table' and ote.periodo $filtrar_periodo";

        // dd($query);

        $data = DB::select($query);
       
        // $data = DB::select("
        // select 
        // ot.id as turma_id,
        // oe.id as evento_id,
        // e.des_event as desc_evento,
        // t.des_turma_trab as desc_turma
        // from tbl_orc_turma_evento ote
        // inner join tbl_orc_turma ot on ote.turma_id = ot.id
        // inner join tbl_orc_evento oe on ote.evento_id = oe.id
        // inner join tbl_eventos e on oe.evento_id = e.id
        // inner join tbl_turma t on ot.turma_id = t.id 
        // where ote.orc_id = $orc_id");
        foreach ($data as $item) {
            $item->horas = number_format($item->horas, 4, ',','.');
        }
       
        return $data;    
    } 

    public function updateOrcTurmaEvento($orc_id,$data){
        DB::beginTransaction();

        try{             
            $data_update = [
                'qtd_hrs'=>monetarioVirgula($data['qtd_hrs']) //str_replace(',', '.', str_replace('.', '', $data['qtd_hrs']))               
            ];       
            if(!$this->update($data_update,['id'=>$data['id']])){ 
                $this->setError('Falha ao fazer update do registro. Erro: 150620201552 - '.$this->getErrosFlatted());
                DB::rollBack();
                return false;                        
            }
            DB::commit();
        }
        catch(\Exception $ex) {
            DB::rollBack();
            abort(500,'Falha ao atualizar. Erro: 150620201553.');
        }
        return array('msg'=>"Registro atualizado com Sucesso",'status'=>"success");
    }

    public function deleteOrcTurmaEvento($orc_id,$data, $periodo = null, $tipo_table = 'O'){
        $instance = $this;
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $query = OrcTurmaEvento::where([
            ['id', $data['id']],
            ['orc_id', $orc_id],
            ['tipo_table', $tipo_table]
        ]);

        if($tipo_table == 'F'){
            $query->where('periodo', $periodo);
        }

        $result = $query->first();
        
        if(is_null($result)){
            $this->setError('Este registro não existe no orçamento. Erro: 150620201554 ');            
            return false;
        }

        DB::beginTransaction();
       
        try{
            if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$data['id'],'tbl_origem'=>$this->getModelEntity()->getTable()])->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro Calc Orcamento. Erro: 240820201432';
                return false;
            } 

            if(!$instance->delete($data['id'])){  
                $this->setError('Falha ao deletar o registro. Erro: 150620201555 ' .$this->getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            DB::commit();
        } catch (\Exception $ex) {
            DB::rollBack();
            abort(500,'Falha ao atualizar . Erro: 150620201556.');
        }
        
        return array('msg'=>"Registro deletado com sucesso",'status'=>"success");
    }
    
} 