<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoEventos;
use App\Modules\Natureza51\Repositories\RepoOrcEventos;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\NivelHierarquico;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class RepoOrcamento extends RepositoryNat51
{
    protected $orc_atual=null; 
     
   // protected $model_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $orc_name_space='App\Modules\Natureza51\Entities\Orcamento';
    protected $form_rules=[];
    protected $rules_msg=[]; 
    private $orc_instance_repo;
    private $orc_entity;
    protected $repo_event;
    protected $repo_orc_event;
    protected $entity_headcount;
    protected $entity_lotacao;

    private $cal_orc_repo;
    private $calc_orc_name_space='App\Modules\Natureza51\Repositories\RepoCalcOrcamento';
    private $orc_fk_name="orcamento_id";
    const  ORC_FK_NAME_DEFAULT="orcamento_id";

    // OBS: Rever status do orçamento:
    // Status do orçamento
    const STATUS_PENDENTE=1;
    const STATUS_EM_ANDAMENTO=2;
    const STATUS_ENVIADO=3;
    const STATUS_REABERTO=4;    // se clicar no reabrir, status tem que ir pra reaberto ou se reabrir qualquer lotação também volta o status (quando reabrir, voltar status de aprovacao pra pendente)
    const STATUS_EM_CONFERENCIA=5; ////  seria quando conferir pelos menos uma lotação (no heacount)
    const STATUS_LIBERADO=6;   //// após clicar no botão liberar todas lotações ou então liberar a ultima
    const STATUS_FINALIZADO=7; //após a ultima lotação ser aprovada (em valores) ou então no botão aprovar todas
    const STATUS_APROVADO=8; //quando aprovar o orçamento 
    const STATUS_EM_EXECUCAO = 9; //quando liberar o primeiro forecast
    const STATUS_TERMINADO = 10; // antigo STATUS_ENVIADO_SISTEMA (alterar na tela) ocorre quando é finalizado o ultimo forecast
    //CONST STATUS_REJEITADO = 11; //não utilizar mais pois ssera alterado no status de aprovacao
    const STATUS_EXCLUIDO = 12;

    // Status de aprovação do orçamento
    const STATUS_APROVACAO_PENDENTE=1;
    const STATUS_APROVACAO_APROVADO=2;
    const STATUS_APROVACAO_REJEITADO=3;

    const STATUS_LOT_PENDENTE_DIGITACAO_FCST=9;
    const STATUS_LOT_REABERTO_FCST=10;
    const STATUS_LOT_ENVIADO_FCST=11;
    const STATUS_LOT_CONFERIDO_FCST=12; 
    const STATUS_LOT_CALCULADO_FCST=13;
    const STATUS_LOT_CALCULADO_LIBERADO_FCST=14;
    const STATUS_LOT_APROVADO_FCST=15; 
    const STATUS_LOT_APROVADO_DIRETOR_AREA_FCST=16;
    
    use \App\Core\Traits\StatusTrait;
    use \App\Core\Traits\NotificacaoTrait;

    
    function __construct() {
        //dd("breka ae");
        if(!$this->getModelNameSpace()){
            $this->setModelNameSpace($this->getOrcNameSpace());
        }
        if($this->isChildren()){
            $this->repoOrcNewInstance();
        }       
        
        $this->repo_event = new RepoEventos();

        // $this->repo_orc_event = new RepoOrcEventos();
        $this->entity_lotacao = new OrcLotacao();
        $this->entity_headcount = new OrcamLotCargoHeadcount(); 
        parent::__construct();
    }
    
    public function setOrcamento(\App\Modules\Natureza51\Entities\Orcamento $value=null){
        $this->orc_atual=$value;
        $this->setOrcInstanceRepo();
        return $this;
    }
    /**
     * @TODO ALUISIO FERREIRA DE SOUSA 30/11/2019
     * Será chamado apenas pelo setOrcamento
     * Para verificar se tem ou não uma instancia do repositorio do Orcamento basta chamar o metodo has() 
     * @return $this
     */
    private function setOrcInstanceRepo(){
       if(!$this->has()){
            $this->orc_instance_repo=null;
            return $this;
       }
        $this->orc_instance_repo=$this->getOrcInstanceNew();
        $this->orc_instance_repo->getModelEntity()->fill($this->getAtual()->getAttributes());
        return $this;
    }

    function getOrcInstanceNew(){
         return new RepoOrcamento();
    }
    
    function getOrcInstanceRepo(){ return $this->orc_instance_repo; }
    /**
     * @TODO ALUISIO FERREIRA DE SOUSA 30/11/2019
     * Indica se a instancia atual é se uma subclasse de orcamento ou é a propria(OrcamentoRepositiry)
     * @return type
     */
    function isChildren(){ return $this->getModelNameSpace()!= $this->getOrcNameSpace(); }
    function isParent(){ return !$this->isChildren(); }
    public function getAtual(){ return $this->orc_atual; }
    public function has(){
        $orc=$this->orc_atual;
        if(!$orc){
            
            return false;
        }
        if(!isset($orc->id)){
            return false;
        }
        if(intval($orc->id)<=0){ 
            return false;
        }    
        return true;
    }
   
    public function isEditable(){
        if(!$this->has()){
            return false;
        }
        $orc=$this->getAtual();
        return true;
    } 
    public function canEdit(){
        if(!$this->has()){
            return false;
        }
        return true;
    }
    public function canDelete(){
        if(!$this->has()){
            return false;
        }
        return true;
    }
    public function isOwn(){
        
        if(!$this->has()){
            return false;
        }
        return true;
    }
    private function repoOrcNewInstance(){
        $class_name='\App\Modules\Natureza51\Repositories\RepoOrcamento';
        $this->orc_instance_repo = new $class_name();
        return $this->entitieOrcNewInstance();
    }
    private function entitieOrcNewInstance(){
        $this->orc_entity=!$this->getOrcInstanceRepo()? null : $this->getOrcInstanceRepo()->getModelEntity(); //new {$this->getModelNameSpace()}() ;
        return $this;
    }
    public function getOrcNameSpace(){ return $this->orc_name_space; } 
    public function getModelEntityOrc() { return $this->orc_instance_repo; }
    public function putOrcamentoIdOnData($dados, $value, $orcamento_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($orcamento_id_name) ? 'orcamento_id' : $orcamento_id_name, $value);
        return $retorno;
        
    }
    public function extractOrcamentoIdFromData($dados, $orcamento_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $orcamento_id_name=empty($orcamento_id_name)? 'orcamento_id' : $orcamento_id_name;
        
        return isset($dados[$orcamento_id_name]) ? $dados[$orcamento_id_name] : 0;   
    }

    /**
     * @author Samuel Domingos de Lia
     * @param $dados Array with data
     * @param $lotacao_id_name Field name for search
     */
    public function extractLotacaoIdFromData($dados, $lotacao_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $lotacao_id_name=empty($lotacao_id_name)? 'lotacao_id' : $lotacao_id_name;
        
        return isset($dados[$lotacao_id_name]) ? $dados[$lotacao_id_name] : 0;   
    }

    /**
     * @author Samuel Domingos de Lia
     * @param $dados Array with data
     * @param $value Value of field name
     * @param $lotacao_id_name Field name for put
     */
    public function putLotacaoIdOnData($dados, $value, $lotacao_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($lotacao_id_name) ? 'lotacao_id' : $lotacao_id_name, $value);
        return $retorno;
        
    }


    public function putCargoIdOnData($dados, $value, $cargo_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($cargo_id_name) ? 'cargo_id' : $cargo_id_name, $value);
        return $retorno;
        
    }
    public function extractCargoIdFromData($dados, $cargo_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $cargo_id_name=empty($cargo_id_name)? 'cargo_id' : $cargo_id_name;
        
        return isset($dados[$cargo_id_name]) ? $dados[$cargo_id_name] : 0;   
    }

    public function putTurmaIdOnData($dados, $value, $turma_id_name=''){
        if(is_array($dados)===false){
            return $dados;
        }
        
        $retorno = Arr::add($dados, empty($turma_id_name) ? 'orc_turma_id' : $turma_id_name, $value);
        return $retorno;
        
    }
    public function extractTurmaIdFromData($dados, $turma_id_name=''){
        if(is_array($dados)===false){
            return 0;
        }
        
        $turma_id_name=empty($turma_id_name)? 'orc_turma_id' : $turma_id_name;
        
        return isset($dados[$turma_id_name]) ? $dados[$turma_id_name] : 0;   
    }

 
    /** 
     * 
     * @param array $data
     * @param type $call_back_success
     * @param type $call_ball_error
     */
    public function createOrc(array $data, $call_back_success=null, $call_ball_error=null) {
        //dd($data,'$create');
        $repo_script_calc = new RepoOrcScriptCalculos();

        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('ano'),'=',$data['ano']],
            [$this->getModelEntity()->getColunaAlias('versao_desc'),'=',$data['versao_desc']],
            [$this->getModelEntity()->getColunaAlias('revisao_desc'),'=',$data['revisao_desc']],
            [$this->getModelEntity()->getColunaAlias('status_orc'),'!=',12]
        ])->get()->toArray();

        if(count($select) > 0){
            $this->setError('Os valores inseridos em Ano, Versão e Revisão já foram cadastrados.', 'Erro: 240420201151');
            return false;
        }
        
        $select = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('ano'),'=',$data['ano']],
            [$this->getModelEntity()->getColunaAlias('versao_desc'),'=',$data['versao_desc']],
            [$this->getModelEntity()->getColunaAlias('revisao_desc'),'=',$data['revisao_desc']],
            [$this->getModelEntity()->getColunaAlias('status_orc'),'!=',12]
        ])->get()->toArray();

        if(count($select) > 0){
            $this->setError('Os valores inseridos em Ano, Versão e Revisão já foram cadastrados.', 'Erro: 240420201151');
            return false;
        }
        if($this->isChildren() && $this->has()===false ){
            $this->setError(['Selecione um orçamento para finalizar a operação.', 'Erro: 301120191601']);
            return false;
        }

        if(!array_key_exists('cod_orcamento',$data)){
            $data['cod_orcamento'] = '';
        }
        

        set_time_limit(0);

        //DB::beginTransaction();
        try {
            $data['status_aprovacao'] = 1;
            $data['status_orc'] = 1;
            if(($salvou= parent::create($data)) ===false ){                
                return empty($call_ball_error) ? $salvou : $call_ball_error($this->getError(), $data, $salvou);
            }
            // dd('jdsnakjdsajdksa', $salvou);
            
            DB::beginTransaction();
            $result =$repo_script_calc->createCalcCargoArea($salvou->id);
            if($result['status']=='error'){
                $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 100320201027.');
                $this->setError($result['msg']);
                return false;
                
            }
            //verificar com daniel / matheus
            // $result = $this->scriptInsertOrcHeadCount($salvou->id);

            // if($result["status"]=="error"){
            //     $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 31082020125.');
            //     return false;
            // }            

            // dd($result);
            DB::commit();
            
            // dd("testeeee", $result_orc_turma);
        } catch (\Exception $e) {  
            DB::rollBack();
            
            abort(500,'Falha ao inserir o orçamento. Erro: 240220201020 - '.$e->getMessage());
        }

        DB::commit();


        return empty($call_back_success) ? $salvou : $call_back_success($salvou, $data);
    }
       public function getOrcFkNameDefault(){ return self::ORC_FK_NAME_DEFAULT;}
       public function getOrcFkName(){ return empty($this->orc_fk_name) ? $this->getOrcFkNameDefault() : $this->orc_fk_name; }
           protected function setOrcFkName($value){
        $this->orc_fk_name= strtolower(trim($value));
        return $this;
    }
 
        /**
     * @author Samuel Domingos de Lima 17/05/2020
     * @param $data Array with values
     * @param $call_back_success Pass a success call back function 
     * @param $call_ball_error Pass a error call back function 
     */
    public function checkHeadcount($data, $call_back_success=null,$call_back_error=null){
        
        $tipo_table = null;
        if( array_key_exists('tipo_table', $data) ){
            $tipo_table = $data['tipo_table'];
        }
        else{
            $tipo_table = 'O';
        }
        $periodo = array_key_exists('periodo', $data) ? $data['periodo'] : null;
        
        if($tipo_table == 'F'){
            $dados = DB::select("SELECT status from tbl_orc_lotacao where id = ? and tipo_table = 'F' and periodo = '{$periodo}'", [$this->extractLotacaoIdFromData($data)]);
            if(count($dados) == 0){
                $dados = DB::select("SELECT status_atual as status from tbl_orc_movto_status_ccusto where orc_lotacao_id = ? and tipo_table = 'F' and periodo = '{$periodo}'", [$this->extractLotacaoIdFromData($data)]);
            }
            $lot = $dados[0];
        }
        else{
            $lot = $this->getEntityLotacao()->where('id',$this->extractLotacaoIdFromData($data))->first();
        }

        if(!$lot){
            $this->setError('Selecione a lotação para continuar a operação.<br/> Erro: 140120201103.');
            return false;
        }

        if( ($lot->status >= $this->getStatusEnviado() && $lot->status <=$this->getStatusLiberado()) || ($lot->status >= self::STATUS_LOT_ENVIADO_FCST && $lot->status <= self::STATUS_LOT_CALCULADO_LIBERADO_FCST) ){
            // if($lot->status==$this->getStatusEnviado() || $lot->status==$this->getStatusEmConferencia() || $lot->status==$this->getStatusLiberado()){
            $this->setError('Operação indisponível. Tente novamente mais tarde.<br/> Erro: 140120201130.');
            return false;
        }
        $res_headcount = $this->getEntityHeadcount()->where([
            'orc_cargo_id'=> $this->extractCargoIdFromData($data),
            'lotacao_id' => $this->extractLotacaoIdFromData($data),
            'orc_turma_id'=>$this->extractTurmaIdFromData($data),
            'tipo_table'=>$tipo_table
            ]);
        if($tipo_table != 'O'){
            $res_headcount = $res_headcount->where('periodo',$periodo);
        }   
        $res_headcount->get()->toArray();



        if(empty($res_headcount)){
                
            $this->setError('Dados não cadastrados em Headcount.<br/> Erro: 130120201155.');
            return false;
        }
        if($this->getModelEntity()->getTable() == 'tbl_orc_promocao'){
            unset($data['cargo_id']);
            unset($data['orc_turma_id']);
            // unset($data['turma_atual_id']);
        }
        
        $salvou =parent::create($data);
        
        if($salvou === false){
            return empty($call_ball_error) ? $salvou : $call_back_error($this->getError(), $data, $salvou);
        }
        if($lot->status == $this->getStatusPendente() || $lot->status == self::STATUS_LOT_PENDENTE_DIGITACAO_FCST){
            if($tipo_table != 'F'){
                $lot->status = $this->getStatusEmAndamento();
                $lot->save();
            }
        }
        return empty($call_back_success) ? $salvou : $call_back_success($salvou, $data);

    }

    public function checkUpdateOrc($row_data){
        dd($row_data);
    }

     public function checkUpdateFore($row_data){
        // dd($this->extractOrcamentoIdFromData($row_data,'orc_id'));
        $orc = new RepoOrcamento();
        $orc_atual = $orc->find($this->extractOrcamentoIdFromData($row_data,'orc_id'));
        if($orc_atual->status_orc != $this->getStatusFinalizado()){
            return false;
        } 

        // dd($orc_atual->status_orc);

        return true;
    } 
         public function listAll($orc_id){

        $result= $this->isParent() ? $this->listar() : $this->getModelEntity()
                ->where($this->getOrcFkName(),'=', $orc_id)->get();
        /***
         * @TODO Aluisio Ferreira de Sousa 12/12/2019
         * Verifica a necessidade de colocar a opção de carregar com o with
         * 
         * ->with([
            'getCargo'=>function($query){


            }
        ])
         */
        
        if(!($orc = $result->first())){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
        
        $orc_f=$orc->getOrcamento();
        
        if(!$orc_f){
             $this->setError(['Orçamento não encontrado.', 'Erro: 121220191452']);
            return false;
        }
        $atual=$orc_f->first();
        
        if(!$atual){
             $this->setError(['Orçamento não encontrado.', 'Erro: 121220191453']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has()===false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 121220191454']);
            return false;
        }
        if($this->isOwn()===false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 121220191455']);
            return false;
        }
        
        
        return $result->count()==0 ? []: $result;
       
    }
    public function getEventsOfHour(){           
        if(!$this->has()){
            //dd("orcEvento", $this->getAtual());
            return [];
        }

        $orcamento = $this->getOrcInstanceRepo()
        ->getModelEntity()
        ::with([
            'getOrcHoraExtra'=>function($query){
                return $query->with([
                    'getEventos'
                ]);
            } 
        ])
        ->find($this->getAtual()->id);
             
        return !$orcamento ? [] : $orcamento->getOrcHoraExtra;
    } 

    public function getRepoEvent(){return $this->repo_event;}

    // public function getRepoOrcEvent(){return $this->repo_orc_event;}
    
    protected function setCalOrcRepo($cal_orc_repo_instance=null){
        $this->cal_orc_repo=!$cal_orc_repo_instance ? (new RepoCalcOrcamento()) : $cal_orc_repo_instance;
        return $this;
    }
    protected function getCalcOrcRepo(){ return $this->cal_orc_repo; }
    
    public function getCalcOrcRepoData($origem_id_array){
        $tabel_name=$this->getModelEntity()->getTable();
        $a= $this->getCalcOrcRepo()->getModelEntity()
                ->where('tbl_origem','=',$tabel_name)
                ->whereIn('origem_id', $origem_id_array)->get();
        //dd('adds4454ewew', $a, $tabel_name, $origem_id_array);
        return $a;
    }
    
        /**
     * @TODO ALUISIO FERREIRA DE SOUSA 16/12/2019
     * Mesclas os resultados de uma tabela com a calcOrcamentos
     * @param COLLECTION $dados
     * @return ARRAY|MIXED  é retornado um array com os atributos da tabela principal mesclado com as propriedades da tabela
     * calc orcado
     */
    public function mergWithCalcOrc(\Illuminate\Support\Collection $dados, $key_name='id'){
        
        $calc_orc=$this->getCalcOrcRepoData($dados->pluck($key_name));
        
        if($calc_orc->count()==0){
            return $dados->toArray();
        }
        $retorno=[];
        $dados->each(function($item, $key) use(&$retorno, &$calc_orc, $key_name){
           $calc_orc_fields= ($exist=$calc_orc->where('origem_id','=', $item->{$key_name})->first())===false ? []: $exist->getAttributes();
           $retorno[]=array_merge($item->getAttributes(),$calc_orc_fields); 
        });
        return $retorno;
    }
    
    
    /**
     * @param array $clausule Pass an array of keys and values ​​for verification in the database
     * @return boolean indicate if has data on DB 
     * @author Samuel Domingos de Lima 06/01/2020
     */

    public function hasDataOnDB($clausule){  
        return (!empty($this->getModelEntity()->where($clausule)->get()->toArray()))? true:false;
    }

     /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function pendingStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120200938.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusPendente();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function inProgressStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();

        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120200939.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmAndamento();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function reopenedStatus($id,$model_name_space,$field_name='status_orc'){
        $field_name_aprovacao = 'status_aprovacao';
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201040'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusReaberto();
        $data->$field_name_aprovacao = $this->getStatusAprovacaoPendente();
        $data->save();
        $repo_orc_calc_script = new RepoOrcScriptCalculos();
        $atualizar_totais = $repo_orc_calc_script->reabrirOrcamento($id);
        if(!$atualizar_totais){
            return array('status'=>'error', 'submsg'=>'Erro', 'msg'=>'Falha ao atualizar registro. Erro: 240720201550');
        }
        return array('status'=>'success', 'submsg'=>'Sucesso', 'msg'=>'Orçamento reaberto com sucesso!');
        
    }
    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function inConferenceStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace(!is_null($model_name_space) ? $model_name_space : $this->getModelNameSpace());
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();        
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201108'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmConferencia();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    /**
     * @author Samuel Domingos de Lima 08/01/2020
     * @param int $id Pass an área identifier.
     * @param string $model_name_space Pass a string with your model name space. 
     * @param string $field_name Optional Param. Default field name is status.
     * @return array An array with status and mensage about function
     */
    public function releasedStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace(!is_null($model_name_space) ? $model_name_space : $this->getModelNameSpace());
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 080120201109.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusLiberado();
        $data->save();
        return array('status'=>'success','msg'=>'Orçamento liberado com sucesso!');
    }

    public function completedStatus($id,$model_name_space,$field_name='status_orc'){
        // dd('njdfsknfkdjsfnjdsf');
        $this->setModelNameSpace(!is_null($model_name_space) ? $model_name_space : $this->getModelNameSpace());
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 290120200900.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusFinalizado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function inExecutionStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace(!is_null($model_name_space) ? $model_name_space : $this->getModelNameSpace());
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 310120201227.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEmExecucao();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }
    public function sendSystemStatus($id,$model_name_space,$field_name='status'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 040220201050.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusEnviadoSistema();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function finischedStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace(!is_null($model_name_space) ? $model_name_space : $this->getModelNameSpace());
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 260220211356.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusTerminado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function approvedStatus($id,$model_name_space,$field_name='status', $field_name_aprovacao = 'status_aprovacao'){
        $this->setModelNameSpace($model_name_space); 
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusAprovado();
        $data->$field_name_aprovacao = $this->getStatusAprovacaoAprovado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    
    }

    public function rejectStatus($id,$model_name_space,$field_name='status', $field_name_aprovacao = 'status_aprovacao'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        // $data->$field_name = $this->getStatusRejeitado();
        $data->$field_name_aprovacao = $this->getStatusAprovacaoRejeitado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    public function excluidoStatus($id,$model_name_space,$field_name='status_orc'){
        $this->setModelNameSpace($model_name_space);
        $model_name_space = $this->getModelNameSpace();
        $model = new $model_name_space();
        $data = $model->find($id);
        if(empty($data)) return array('status'=>'error','msg'=>'Falha ao atualizar registro. Erro: 0602202500946.'); /**Lotação não encontrada */
        $data->$field_name = $this->getStatusRejeitado();
        $data->save();
        return array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
    }

    private function getEntityHeadcount(){return $this->entity_headcount;}
    private function getEntityLotacao(){ return $this->entity_lotacao;}

    public function getStatusPendente(){
        return self::STATUS_PENDENTE;
    }
    public function getStatusEmAndamento(){
        return self::STATUS_EM_ANDAMENTO;
    }
    public function getStatusEnviado(){
        return self::STATUS_ENVIADO;
    }
    public function getStatusReaberto(){
        return self::STATUS_REABERTO;
    }
    public function getStatusEmConferencia(){
        return self::STATUS_EM_CONFERENCIA;
    }
    public function getStatusLiberado(){
        return self::STATUS_LIBERADO;
    }
    public function getStatusFinalizado(){
        return self::STATUS_FINALIZADO;
    }
    public function getStatusAprovado(){
        return self::STATUS_APROVADO;
    } 
    public function getStatusEmExecucao(){
        return self::STATUS_EM_EXECUCAO;
    }
    public function getStatusTerminado(){
        return self::STATUS_TERMINADO;
    } 
    public function getStatusRejeitado(){
        return self::STATUS_REJEITADO;
    }    
    public function getStatusExcluido(){
        return self::STATUS_EXCLUIDO;
    }
    public function getStatusAprovacaoPendente(){
        return self::STATUS_APROVACAO_PENDENTE;
    } 
    public function getStatusAprovacaoAprovado(){
        return self::STATUS_APROVACAO_APROVADO;
    } 
    public function getStatusAprovacaoRejeitado(){
        return self::STATUS_APROVACAO_REJEITADO;
    } 
         

 
    
    
    /**
     * @OVERIDE create of App\Core\Repositories\Eloquent\Repository->create
     * ALUISIO FERREIRA DE SOUSA 28/02/2020
     * Inseri um novo orcamento Não será utilizado pelos metodos filhos
     * 
     */
    public function create($dados){
         
        return parent::create($dados);
         
         
         
        /**
         * Verifica se a instance é de um orcamento 
         * caso seja de um repositorio filho retorna um erro.
         */
        if(!$this->isParent()){
            $this->setError('Não é possível criar um novo orçamento. O repositorio de orçamento não foi inicializado corretamento . Erro: 28022020.');
            return false;
        }
        dd('xxxaasada', 
           $dados,
           dateToBrFormat($dados['data_inicio'], 'Y-m-d')
        );
        // return parent::create($form_data);
    }
    /**
     * ALUISIO FERREIRA DE SOUSA 28/02/2020
     * Validações para o cadastro do orcamento(tbl_orcamento);
     * @param $dados MIXED|ARRAY Obrigatorio Array associativo com os campos e dados para salvar o orcamento.
     * @param $tipo_op STRING Opcional indica para qual tido de operação será a validação. O padrão é add. Valores possiveis: add= Adicionar, edt=editar, del=Deletar;
     * @return  boolean|String Caso contenha erro oo retorno será uma string se tudo estiver OK o retorno será TRUE
     */
    private function orcValidate($dados, $tipo_op='add'){
        $fillable = [         
        'empresa_id', 'cod_orcamento',  'status_aprovacao',
        'responsavel_id', 'status_orc', 
            'versao', 
            'revisao', 
          'responsavel_tec_id',
        
    ];
        if(!isset($dados['ano'])){
            return 'Preencha o campo ano';
        }
        $dados['ano']=intval($dados['ano']);
        
         $ano_atual=date('Y');
        /**
         * @todo Verifica se um orçamento tem que ser sempre Ano+1
         * vide as tarefa #1f5041 (https://app.clickup.com/t/1f5041)
         */
        if($dados['ano']< $ano_atual){
            return 'Preencha o campo ano, com um valor que corresponda um ano válido. Ex: 2019.';
        }
        
        if(!isset($dados['descricao_orc'])){
            return 'Preencha o campo descrição.';
        }
        
        $dados['descricao_orc']=trim($dados['descricao_orc']);
        
        if(empty($dados['descricao_orc'])){
            return 'Preencha o campo descrição.';
        }
        
        
        if(!isset($dados['versao_desc'])){
            return 'Preencha o campo observação da versão.';
        }
        
        $dados['versao_desc']=trim($dados['versao_desc']);
        
        if(empty($dados['versao_desc'])){
            return 'Preencha o campo observação da versão.';
        }        
        
         if(!isset($dados['revisao_desc'])){
            return 'Preencha o campo observação da revisão.';
        }
        
        $dados['revisao_desc']=trim($dados['revisao_desc']);
        
        if(empty($dados['revisao_desc'])){
            return 'Preencha o campo observação da revisão.';
        }
        
        if(!isset($dados['data_inicio'])){
            return 'Preencha o campo data de inicio do orçamento.';
        }
        if(!isset($dados['data_fim'])){
            return 'Preencha o campo data de fim do orçamento.';
        }
        $ini_str=trim($dados['data_inicio']);
        $fim_str=trim($dados['data_fim']);
        
        if(empty($ini_str)){
            return 'Preencha o campo data de inicio do orçamento.';
        }
        if(empty($fim_str)){
            return 'Preencha o campo data de fim do orçamento.';
        }
        $format_date_requested='Y-m-d';
        $dt_init= dateToBrFormat($ini_str, null, true);
        $fim_str= dateToBrFormat($fim_str, null, true);
        
        if($dt_init===false){
            return 'No campo data de inicio informe uma data valida. Ex: 29/02/2020';
        }
                
        if($fim_str===false){
            return 'No campo data de fim informe uma data valida. Ex: 29/02/2020';
        }
        
         $ano_inicio=intval($dt_init->format('Y'));
         
        if($dados['ano'] > $ano_inicio ){
            return 'O ano de inicio Não pode ser anterior ao ano do orçamento.';
        }
        
        if($dados['ano']> intval($dt_init->format('Y'))){
            
        }
        
        //'mes_ini_frc'
        
        return true;
    } 

    public function getQuadroAtual($orc_id,$lotacao_id,$orc_cargo_id){
        $headcount = new OrcamLotCargoHeadcount();

        $a = $headcount->select('qtd_func_lot')
        ->where([
            ['orc_id',$orc_id],
            ['lotacao_id',$lotacao_id],
            ['orc_cargo_id',$orc_cargo_id],
        ])->get()->toArray();

        return $a;
    }

    public function updateParent($data_request, $id){
        return parent::update($data_request, $id);
    }


    public function preencherArquivoLog($mensagem){
        $data = Carbon::now()->format('d/m/Y H:i:s')."\n";
        $conteudo = $mensagem . $data;
        file_put_contents('C:\Users\insti\Documents\Projetos\Desenvolvimento\MRN\natureza51\mrn-natureza-51\Entrou na rotina.txt', $conteudo, FILE_APPEND);

    }

    public function getRespEstrutura($orc_id, $orc_lotacao){
        $tbl_orc_lotacao = new OrcLotacao();
        $estrutura = new OrcLotacaoController();
        
        $dados = $estrutura->makeEstrutura($orc_id);
        $lotacoes = (array_column($dados, 'lotacao_id'));
        dd("LOtacaoes", $lotacoes);
        
        $select = $tbl_orc_lotacao->select()->where([
            ['orcamento_id',$orc_id],
            ['id',$orc_lotacao]
        
        ])
        ->whereIn('lotacao_id',$lotacoes)
        ->get()->toArray();
        
        if(count($select) == 0){
            return false;
        }
        else{
            return true;
        }
    }

    public function scriptInsertOrcHeadCount($orc_id){
        $value  = 'Falha ao inserir registros na tela Headcount! Erro: 22022021330';
        $user = $this->getUserFromCurrentGuard();
        $empresa_id = $user->id_empresa;
        $user_id = $user->id;

        DB::beginTransaction();

        try {
            $sql="EXEC popula_orc_headcount :orc_id, :p_empresa_id, :p_user_id";

            $stmt=DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_empresa_id', $empresa_id, \PDO::PARAM_INT );
            $stmt->bindParam(':p_user_id', $user_id, \PDO::PARAM_INT );

            if(!$stmt->execute()){
                $retorno["status"]="error";
                $retorno['msg'] = $this->setError($value);
                $retorno['submsg']='Falha ao atualizar registro. Erro: 22022021330 | popula_orc_headcount';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]=" Registros atualizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();

            $retorno["status"]="error";
            $retorno['msg'] = $e;
            $retorno['submsg']='Falha ao fazer inserir registro. Erro: 22022021318 - ' . 'popula_orc_headcount';
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();
        // dd("insert clone", $retorno);
        return $retorno;
    }
    
    public function calculateRealizado($orc_id, $periodo){
        $value = 'Falha ao calcular os valores do realizado! Erro: 201020201834';
        $user = $this->getUserFromCurrentGuard();

        $empresa = $user->id_empresa;
        $user_id = $user->id;

        try {                           

            $res = DB::statement(DB::raw("
                SET NOCOUNT ON ;
                EXEC calculateRealizado
                    @p_empresa_id = $empresa,
                    @p_orcamento_id = $orc_id,
                    @p_user_id = $user_id,
                    @p_periodo = '$periodo';        
                ")); 
            // $sql="EXEC calculateRealizado :p_empresa_id, :p_orcamento_id, :p_user_id, :p_periodo";

            // $stmt=DB::getPdo()->prepare($sql);
            // $stmt->bindParam(':p_empresa_id', $empresa, \PDO::PARAM_INT );
            // $stmt->bindParam(':p_orcamento_id', $orc_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':p_user_id', $user_id, \PDO::PARAM_INT );
            // $stmt->bindParam(':p_periodo', $periodo, \PDO::PARAM_STR  );
                                        
            // if(!$stmt->execute()){
			// 	$this->setError($value);
			// 	$this->setSubError('Falha ao calcular registro. Erro: 201020201837 | calculateRealizado');
			// 	return false;
            // } 
    
        } catch (\Exception $e) {
			$this->setError('Falha ao calcular os valores do realizado. Erro: 201020201838 - calculateRealizado');
			$this->setSubError($e->getMessage());     
			return false;  
        }
        return true;
    }

    public function canCRUDForecast($lotacao_id, $orc_id, $periodo, $tipo_table){
        $validacao = DB::select("SELECT * from tbl_orc_lotacao where id = {$lotacao_id} and tipo_table = '{$tipo_table}' and periodo = '{$periodo}' ");
        if(count($validacao) > 0){
            if( $validacao[0]->status < 11 && $validacao[0]->status >= 9 ){
                return true;
            }
            else{
                return false;
            }
        }
        else{
            $select = DB::select("SELECT movto.status_atual, olot.status
                from tbl_orc_lotacao as olot
                inner join tbl_orc_movto_status_ccusto as movto on movto.orc_lotacao_id = ?
                where orcamento_id = ? and olot.id = ? and movto.periodo = '{$periodo}' and movto.tipo_table = ?", [$lotacao_id, $orc_id, $lotacao_id, $tipo_table]);
            
            if(count($select) > 0 && ($select[0]->status_atual < 11 && $select[0]->status_atual >= 9) && ($select[0]->status < 11 && $select[0]->status >= 9) ){
                return true;
            }
            else{
                return false;
            }
        }
    }

    public function validaValoresNegativos($orc_id, $lotacao_id, $periodo = null, $tipo_table = 'O'){
        $where = $tipo_table == 'F' ? " AND hd.periodo = '{$periodo}' and hd.tipo_table = '{$tipo_table}' " : " AND hd.tipo_table = '{$tipo_table}' ";
        $where_sub_query = $tipo_table == 'F' ? " AND periodo = '{$periodo}' and tipo_table = '{$tipo_table}' " : "AND periodo is null AND tipo_table = '{$tipo_table}' ";

        $select = DB::select("SELECT * from tbl_orc_lot_carg_headcount as hd
        inner join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
        
        where hd.orc_id = {$orc_id} and hd.lotacao_id = $lotacao_id {$where} and (calc.jan_orcado < 0 or calc.fev_orcado < 0 or calc.mar_orcado < 0 or calc.abr_orcado < 0 or calc.mai_orcado < 0 or calc.jun_orcado < 0 or
        calc.jul_orcado < 0 or calc.ago_orcado < 0 or calc.set_orcado < 0 or calc.out_orcado < 0 or calc.nov_orcado < 0 or calc.dez_orcado < 0)
        and not exists (select id from tbl_orc_promocao where orc_id = {$orc_id} {$where_sub_query} and lotacao_id = hd.lotacao_id and (cargo_atual_id = hd.orc_cargo_id or cargo_promovido_id = hd.orc_cargo_id) and (turma_atual_id = hd.orc_turma_id or turma_promovida_id = hd.orc_turma_id) and is_secreto = 1)
        and not exists (select id from tbl_orc_headcount_demissoes where orcamento_id = {$orc_id} {$where_sub_query} and lotacao_id = hd.lotacao_id and orc_cargo_id = hd.orc_cargo_id and orc_turma_id = hd.orc_turma_id and l_sec = 1)
        ");      

        return $select;
    }

    public function deleteDiarioBordo($id, $tbl_origem){
        try{
            $delete = DB::delete("DELETE from tbl_orc_diario_bordo where registro_id = {$id} and tbl_origem = '{$tbl_origem}'");
            
            if($delete === false){
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            dd($e->getMessage());
            return false;
        }
        
    }

    public function deleteDiarioBordoByCargoTurma($orc_id, $lotacao_id, $cargo_id, $turma_id, $periodo = null, $tipo_table = 'O'){
        // $lotacao_id, $periodo = null, $tipo_table = 'O'
        $funcao = "DELETE";//SELECT *
        try{
            $where[0] = $tipo_table == 'F' ? " and periodo = '{$periodo}' " : "";
            $where[1] = $tipo_table == 'F' ? " and hd.periodo = '{$periodo}' " : "";
            $where[2] = $tipo_table == 'F' ? " and dem.periodo = '{$periodo}' " : "";
            $where[3] = $tipo_table == 'F' ? " and cont.periodo = '{$periodo}' " : "";
            $where[4] = $tipo_table == 'F' ? " and prom.periodo = '{$periodo}' " : "";
            $where[5] = $tipo_table == 'F' ? " and aus.periodo = '{$periodo}' " : "";
            $where[6] = $tipo_table == 'F' ? " and he.periodo = '{$periodo}' " : "";
            $where[7] = $tipo_table == 'F' ? " and fe.periodo = '{$periodo}' " : "";
    
            $delete1 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_lot_carg_headcount' and registro_id in(
                select calc.id from tbl_orc_lot_carg_headcount as hd
                inner join tbl_calc_orcamento as calc on calc.origem_id = hd.id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
                where hd.orc_id = {$orc_id} and hd.lotacao_id = {$lotacao_id} and hd.orc_cargo_id = {$cargo_id} and hd.orc_turma_id = {$turma_id} and hd.tipo_table = '{$tipo_table}' {$where[1]}    
            )");
            
            $delete2 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_headcount_demissoes' and registro_id in(
                select id from tbl_orc_headcount_demissoes as dem where orcamento_id = {$orc_id} and lotacao_id = {$lotacao_id} and orc_cargo_id = {$cargo_id} and orc_turma_id = {$turma_id} and tipo_table = '{$tipo_table}' {$where[2]}
            )");
    
            $delete3 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_headcount_contratacoes' and registro_id in(
                select id from tbl_orc_headcount_contratacoes as cont where cont.orcamento_id = {$orc_id} and cont.lotacao_id = {$lotacao_id} and cont.orc_cargo_id = {$cargo_id} and cont.orc_turma_id = {$turma_id} and cont.tipo_table = '{$tipo_table}' {$where[3]}
            )");
    
            $delete4 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_promocao' and registro_id in(
                select id from tbl_orc_promocao as prom where prom.orc_id = {$orc_id} and (prom.lotacao_id = {$lotacao_id} and prom.cargo_atual_id = {$cargo_id} and prom.turma_atual_id = {$turma_id})
                    or (prom.lotacao_promovida_id = {$lotacao_id} and prom.cargo_promovido_id = {$cargo_id} and prom.turma_promovida_id = {$turma_id}) and prom.tipo_table = '{$tipo_table}' {$where[4]}
            )");
    
            $delete5 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_salario_funcionario' and registro_id in(
                select id from tbl_orc_salario_funcionario as aus where aus.orc_id = {$orc_id} and aus.lotacao_id = {$lotacao_id} and aus.orc_cargo_id = {$cargo_id} and aus.orc_turma_id = {$turma_id} and aus.tipo_table = '{$tipo_table}' {$where[5]}
            )");
    
            $delete6 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_headcount_hra_extra' and registro_id in(
                select id from tbl_headcount_hra_extra as he where he.orc_id = {$orc_id} and he.lotacao_id = {$lotacao_id} and he.orc_cargo_id = {$cargo_id} and he.orc_turma_id = {$turma_id} and he.tipo_table = '{$tipo_table}' {$where[6]}
            )");
    
            $delete7 = DB::delete("{$funcao} from tbl_orc_diario_bordo where tbl_origem = 'tbl_orc_ferias' and registro_id in(
                select id from tbl_orc_ferias as fe where fe.orcamento_id = {$orc_id} and fe.lotacao_id = {$lotacao_id} and fe.cargo_id = {$cargo_id} and fe.orc_turma_id = {$turma_id} and fe.tipo_table = '{$tipo_table}' {$where[7]}
            )");

            if($delete1 === false || $delete2 === false || $delete3 === false || $delete4 === false || $delete5 === false || $delete6 === false || $delete7 === false){
                return false;
            }
            return true;
        }
        catch(\Exception $e){
            dd($e);
            return false;
        }
        
    }
}
