<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;

class RepoOrcNotificacoes extends RepoOrcamento{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcNotificacoes';
    protected $form_rules=[
        'user_id'       =>'required',
        'mensagem'      =>'required',
        'l_ok'          =>'required',
        'tipo'          =>'required',
        
    ]; 
    protected $rules_msg=[
        'user_id.required'     =>'Usuário não informado.',
        'mensagem.required'    =>'Mensagem não informada',
        'l_ok.required'        =>'Situação não informada',
        'tipo.required'        =>'Tipo não informado',    
    ];  

    public function listar($orc_id){
        return $this->getModelEntity()
           ->where('orc_id', '=', $orc_id)
           ->where('user_id', '=', $this->getUserFromCurrentGuard()->id)
            ->get()->toArray();
    }

    public function marcarOK($data){
        $result = $this->getModelEntity()->find($data['id']);
        // $result = $this->getModelEntity()->find($data->id);

        if(!$result){
            $this->setError("Notificação não encontrada. Erro 080220211055.");
        }

        $result->l_ok = 1;

        $this->makeModel();
        return $result->save();
    }

     
}