<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\PerfilPermUser;
use App\Modules\Natureza51\Entities\PerfilRegras;
use App\Modules\Natureza51\Entities\Usuario;
use DB;



class RepoPerfilPermUser extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\PerfilPermUser';


    protected $form_rules=[ 
        'perfil_perm_id'       => 'required',
        'usuario_id'            => 'required',
        
    ];

    protected $rules_msg=[ 
        'perfil_perm_id.required'  => 'O campo Perfil é obrigatório!',
        'usuario_id.required'      => 'O campo Usuário é obrigatório!',
  
    ];



    public function getPerfisSelecionados($usuario_id){
        $tbl_perfil_user = $this->getModelEntity()->getTable();
  
        
        $perfis = new PerfilRegras;
        $tbl_perfil_permissoes = $perfis->getTable();
        $perfis = DB::table($tbl_perfil_user)->leftJoin($tbl_perfil_permissoes. ' as Perfil', 'Perfil.id', '=', $tbl_perfil_user.'.perfil_perm_id')
        ->select('Perfil.id as id', 'Perfil.descricao')
        ->where($tbl_perfil_user.'.usuario_id', $usuario_id)
        ->get();

      
        return  $perfis;
    }

    public function deleteByUser($usuario_id){
        $deletados = $this->getModelEntity()->where('usuario_id', $usuario_id)->delete();

    }
}