<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\PerfilPermUser;
use App\Modules\Natureza51\Entities\PerfilTelaTag;
use App\Modules\Natureza51\Entities\PermissoesTag;
use App\Modules\Natureza51\Entities\Tela;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoPermissoes extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Permissoes';

    protected $form_rules=[];

    protected $rules_msg=[];

    public function getPermissao($email){
        $tbl_usuario = new Usuario();
        $tbl_perfil_perm_user = new PerfilPermUser();
        $tbl_perfil_tela_tag = new PerfilTelaTag();
        $tbl_institb_perm_tags = new PermissoesTag();
        $tbl_tela = new Tela();

        $select = $tbl_usuario
        ->join($tbl_perfil_perm_user->getTable(), $tbl_usuario->getColunaAlias('id'), $tbl_perfil_perm_user->getColunaAlias('usuario_id'))

        ->join($tbl_perfil_tela_tag->getTable(), $tbl_perfil_perm_user->getColunaAlias('perfil_perm_id'), $tbl_perfil_tela_tag->getColunaAlias('id_perfil'))

        ->join($tbl_institb_perm_tags->getTable(), $tbl_perfil_tela_tag->getColunaAlias('id_tag'), $tbl_institb_perm_tags->getColunaAlias('id'))

        ->join($tbl_tela->getTable(), $tbl_perfil_tela_tag->getColunaAlias('id_tela'), $tbl_tela->getColunaAlias('id'))

        ->select(
            $tbl_perfil_perm_user->getColunaAlias('perfil_perm_id'),
            DB::raw("{$tbl_usuario->getColunaAlias('id')} as usuario_id"),
            $tbl_usuario->getColunaAlias('nome'),
            $tbl_usuario->getColunaAlias('email'),
            $tbl_perfil_tela_tag->getColunaAlias('id_tag'),
            $tbl_perfil_tela_tag->getColunaAlias('id_tela'),
            $tbl_institb_perm_tags->getColunaAlias('descricao'),
            $tbl_tela->getColunaAlias('cod')
        )
        ->where([
            [$tbl_usuario->getColunaAlias('email'),'=',$email]
        ])
        ->get()->toArray();
        
        return $select;
    }
}
