<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\PlanoLotacUnid;

class RepoPlanoLotacUnid extends RepositoryNat51{
    protected $model_name_space='App\Modules\Natureza51\Entities\PlanoLotacUnid'; 
    protected $form_rules=[
        'plano_lotac_tipo_id'=>'required|unique:tbl_plano_lotac_unid,plano_lotac_tipo_id',
        'lotacao_id'=>'required|unique:tbl_plano_lotac_unid,lotacao_id',
        'limite'=>'required'
    ];
    protected $rules_msg=[
        'plano_lotac_tipo_id.required'=>'O campo Cód Plano Lotac. Unid é obrigatório',
        'plano_lotac_tipo_id.unique'=>'Plano Lotação já cadastrado',
        'lotacao_id.required'=>'O campo Cód. Lotação é obrigatório',
        'lotacao_id.unique'=>'Lotação já cadastrada',
        'limite.required'=>'O campo Limite é obrigatório'
    ];

    public function listar(){
        $a=$this->allWith([
            'getPlanoLotacTp'=>function($query){},
            'getLotacao'=>function($query){}
        ])->toArray();
 
        for($i=0;$i<count($a);$i++){
            $a[$i]['des_tipo']=$a[$i]['get_plano_lotac_tp']['des_tipo'];
            $a[$i]['des_unid_lotac']=$a[$i]['get_lotacao']['des_unid_lotac'];
            $a[$i]['unid_lotac']=$a[$i]['get_lotacao']['unid_lotac'];
            unset($a[$i]['get_plano_lotac_tp']);
            unset($a[$i]['get_lotacao']);
        }
        return $a;
    }
}