<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoPlanoLotacao extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\PlanoLotacao';
    protected $form_rules=[
        'des_plano_lotac'=>'required',
        'cdn_plano_lotac'=>'required|unique:tbl_plano_lotac,cdn_plano_lotac'
    ];
    protected $rules_msg=[
        'des_plano_lotac.required'=>'O campo Desc. Plano Lotação é obrigatório',
        'cdn_plano_lotac.required'=>'O campo Cod. Plano Lotação é obrigatório',
        'cdn_plano_lotac.unique'=>'Cod. Plano Lotação já exitente'
    ];

    public function update(array $dados,$id,$attribute="id"){
        
        $this->form_rules['cdn_plano_lotac'].=','.$id;
        
        return parent::update($dados,$id);
    }
    public function listarAtivo(){
        $select = $this->getModelEntity()->select()->where($this->getModelEntity()->getcolunaAlias('ativo'),'=',1)->get()->toArray();
        return $select;
    }
}
