<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\PlanoLotacao;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Repositories\RepositoryNat51;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class RepoPlanoLotacaoTipo extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\PlanoLotacaoTipo';

   protected $form_rules=[
      'plano_lotac_id'=>'required',
      'cod_tipo'=>'required',
      'limite'=>'integer'
   ];
   protected $rules_msg=[
    'plano_lotac_id.required'=>'O campo Cód. Plano Lotação é obrigatório',

    'cod_tipo.required'=>'O campo Cód. Tipo é obrigatório', 
    'limite.integer'=>'O campo Limite deve ser um número inteiro',
   ];

   public function listar(){
      $a=$this->allWith([
         'getPlanoLotacao'=>function($query){
         }
      ])->toArray();

         for($i=0; $i<count($a); $i++){
            $a[$i]['Ativo']=$a[$i]['ativo']==1?'Sim':'Não';
            $a[$i]['desc_plano_lotac']=$a[$i]['get_plano_lotacao']['cdn_plano_lotac']. ' - ' .$a[$i]['get_plano_lotacao']['des_plano_lotac'];
            unset($a[$i]['get_plano_lotacao']);
         }
         // dd("plano lotac", $a);
         return $a;
   }

   // $pl_lot = new PlanoLotacao();
   // $tbl_usuario = new Usuario();
   // // $a = $this->allWith([
   // //       'getPlanoLotacao'=>function($query){
   // //    }
   // // ])->toArray();

   // $a = $this->getModelEntity()
   //    ->leftJoin($pl_lot->getTable(), $this->getModelEntity()->getColunaAlias('plano_lotac_id'), $pl_lot->getColunaAlias('id'))
   //    ->leftJoin(
   //       DB::raw("{$tbl_usuario->getTable()} as usuario1"),
   //       DB::raw("usuario1.id"),
   //       DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
   //    )
   //    ->leftJoin(
   //       DB::raw("{$tbl_usuario->getTable()} as usuario2"),
   //       $this->getModelEntity()->getColunaAlias('updated_by'),
   //       DB::raw("usuario2.id")
   //    )
   // ->select(
   //    $this->getModelEntity()->getColunaAlias('id'),
   //    $this->getModelEntity()->getColunaAlias('empresa_id'),
   //    $this->getModelEntity()->getColunaAlias('plano_lotac_id'),
   //    $this->getModelEntity()->getColunaAlias('cod_tipo'),
   //    $this->getModelEntity()->getColunaAlias('des_tipo'),
   //    $this->getModelEntity()->getColunaAlias('limite'),
   //    $this->getModelEntity()->getColunaAlias('ativo'),
   //    DB::raw("IIF({$this->getModelEntity()->getColunaAlias('ativo')} = 1 , 'Sim', 'Não') as Ativo"),
   //    $this->getModelEntity()->getColunaAlias('origem'),

   //    DB::raw("CONCAT({$pl_lot->getColunaAlias('cdn_plano_lotac')} , ' - ', {$pl_lot->getColunaAlias('des_plano_lotac')}) as des_plano_lotac"),
      
   //    DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
   //    DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

   //    DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
   //    DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),

   //    DB::raw("CASE
   //       WHEN {$this->getModelEntity()->getColunaAlias('origem')} = 1 THEN 'Sistema'
   //       ELSE 'ERP'
   //    END as origem_des"),
      
   //    $this->getModelEntity()->getColunaAlias('user_id')
   // )->get()->toArray();

   // // for($i = 0; $i < count($a); $i++){
   // //    $a[$i]['Ativo'] = $a[$i]['ativo'] == 1 ? 'Sim' : 'Não';
   // //    $a[$i]['des_plano_lotac'] = $a[$i]['get_plano_lotacao']['cdn_plano_lotac'].' - '.$a[$i]['get_plano_lotacao']['des_plano_lotac'];
   // //    // $a[$i]['created_at'] = formataData($a[$i]['created_at']);
   // //    // $a[$i]['created_at'] = formataData($a[$i]['created_at']);

   // //    unset($a[$i]['get_plano_lotacao']);
   // // }
   
   // /*
   //    "user_id" => null
   // */
   // return $a;

   public function create(array $data) {
      $data_compare = [
         'plano_lotac_id' => $data['plano_lotac_id'], 
         'empresa_id' => $this->getUserFromCurrentGuard()->id_empresa, 
         'cod_tipo' =>$data['cod_tipo']
      ];

      $existe = $this->getModelEntity()->where($data_compare)->count();

      if($existe){
         $this->setError('O código informado já está sendo utilizado utilizado nesse plano de lotação!');
         return false;
      }
      return parent::create($data);
   }

}
