<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoHeadcount;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Orcamento;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcCargo;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;

class RepoRealizado extends RepositoryNat51
{
    use \App\Core\Traits\ParamTrait; 
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';  

  
    public function listar($orc_id,$mes,$orc_lotacao_id, $divergente = null){        
      // $data = $this->listajson();
      // dd($tipo_table);     
      // return new Response($data , 200);  

      $ano = Orcamento::find($orc_id)->ano;

      // $this->createRealizadoFromForecast($orc_id, $ano, $mes, $orc_lotacao_id);
      // $this->updateRealizadoFromForecast($orc_id, $mes, $orc_lotacao_id);
      // $this->updatedFromFolha($orc_id, $mes, $orc_lotacao_id);

      $tipo_table = 'R'; 
      $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();        
      $tb_calc_orcamento = new CalcOrcamento();
      $tb_cargo = new Cargo();
      $tb_centro_custo = new CentroCusto();
      $tb_turma = new OrcTurma();
      $tb_turno = new Turno();
      $tb_lotacao = new OrcLotacao();
      $tb_orc_cargo = new OrcCargo(); 
      
      // $forecast_dez_anterior = $this->getForecastAnterior($repo->getOrcamento->id, $orc_lotacao->lotacao_id);

      // DB::enableQueryLog();
      $data_query = $tb_lotacao->join($tb_orcamLot_cargo_headcount->getTable(),
      $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
        ->join($tb_calc_orcamento->getTable(), $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
        ->join($tb_orc_cargo->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
        ->join($tb_cargo->getTable(),
            $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
        ->join($tb_centro_custo->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
        ->join($tb_turma->getTable(),
            $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
        ->join($tb_turno->getTable(),
                $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
          ->select(
              DB::raw($tb_calc_orcamento->getColunaAlias('id')),
              DB::raw($tb_orcamLot_cargo_headcount->getColunaAlias('id').' as id_princ'), 
              $tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'), 
              $tb_orcamLot_cargo_headcount->getColunaAlias('qtd_func_lot'), 
              $tb_orcamLot_cargo_headcount->getColunaAlias('atual_total'), 
              $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('orcado_anterior'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('origem_sistema'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('divergente'),
              $tb_orc_cargo->getColunaAlias('cargo_id'), 
              $tb_cargo->getColunaAlias('cod_cargo_basic'), 
              $tb_cargo->getColunaAlias('des_cargo_basic'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), 
              $tb_centro_custo->getColunaAlias('cod_ccusto'), 
              $tb_turma->getColunaAlias('cdn_turma_trab'), 
              $tb_turma->getColunaAlias('des_turma_trab'), 
              $tb_turno->getColunaAlias('cdn_turno_trab'),
              $tb_turno->getColunaAlias('des_turno_trab'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'),

              // DB::raw($forecast_dez_anterior.' as forecast_anterior'), 
              $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_anterior'),
              $tb_orcamLot_cargo_headcount->getColunaAlias('forecast_total'),

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jan"),
              $tb_calc_orcamento->getColunaAlias('jan_orcado'),

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')}, 
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_fev"),
              $tb_calc_orcamento->getColunaAlias('fev_orcado'), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mar, 
              {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_abr, 
              {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mai, 
              {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jun, 
              {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jul, 
              {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_ago, 
              {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_set, 
              {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_out, 
              {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),

              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_nov, 
              {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
              
              DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
              {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
              {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_dez, 
              {$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
          )
          ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')},
          {$tb_turma->getColunaAlias('cdn_turma_trab')}")   
          // ->where([
          //     [$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'),$orc_id],
          //     [$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),$orc_lotacao_id],
          //    [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'),$tipo_table],
            //  [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'), 'O'],
          
            ->where([
              [$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'),$orc_id],
              [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'),$tipo_table],
              ])->whereRaw($tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')." in (select ol_o.id from tbl_orc_lotacao ol_o
              join tbl_orc_lotacao ol_f on ol_o.lotacao_id = ol_f.lotacao_id AND ol_o.cc_custo_id = ol_f.cc_custo_id
              WHERE ol_o.tipo_table = 'O' and (ol_o.id = $orc_lotacao_id OR ol_f.id = $orc_lotacao_id ) and ol_o.orcamento_id = $orc_id)");

             
              // dd("testeee",$data_query);
        

 

        if(!is_null($divergente) && $divergente != 2){
          if($divergente == 1){
            $data_query = $data_query->where($tb_orcamLot_cargo_headcount->getColunaAlias('divergente'), $divergente);
          }
          else{
            $data_query = $data_query->whereRaw("ISNULL({$tb_orcamLot_cargo_headcount->getColunaAlias('divergente')}, 0) = {$divergente}");
          }
        }

        $data = $data_query->get()->toArray();
        // dd("query", DB::getQueryLog());

     
        //  dd("pivooooo",$this->pivo($data));
        // dd("query 1 real", DB::getQueryLog());
      return $data;
    }

    //VERIFICA O ULTIMO FORECAST E CRIA OS MESMOS REGISTROS COM O TIPO 'R'
    public function createRealizadoFromForecast($orc_id, $orc_lotacao_id, $periodo = null){
      $olch = new OrcamLotCargoHeadcount();
      $ultimo_periodo = is_null($periodo) ? Carbon::parse( $olch->where('lotacao_id', $orc_lotacao_id)->max('periodo'))->format('ymd') : $periodo;
      
      // dd("ultimo periodo", $ultimo_periodo);
      $whereLotacao = is_null($orc_lotacao_id) ? '' : "and lotacao_id= $orc_lotacao_id";
      $query_insert = "
        SELECT * 
            FROM tbl_orc_lot_carg_headcount AS olch_f
            
            INNER JOIN	tbl_calc_orcamento co on co.origem_id = olch_f.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
        
            WHERE orc_id = $orc_id 
            $whereLotacao
            and tipo_table = 'F' 
            and periodo = '$ultimo_periodo'
            and not exists(SELECT * FROM tbl_orc_lot_carg_headcount AS olch_r 
                      WHERE  olch_r.orc_id = olch_f.orc_id 
                      and olch_r.lotacao_id= olch_f.lotacao_id
                      and tipo_table = 'R'
                      and olch_r.orc_cargo_id = olch_f.orc_cargo_id
                      and olch_r.orc_turma_id = olch_f.orc_turma_id)
        
        "
      ;
      // dd("select", $query_insert);
      $data_insert = DB::select($query_insert);
      // dd("data insert", $data_insert);
      foreach ($data_insert as $forecast) {
        $repoHeadcount = new RepoHeadcount();
        $forecast->tipo_table = 'R';
        
        $data = (array)$forecast;
        $data['meses_orcado'] = [
          'jan_orcado'=>$data[ 'jan_orcado' ],
          'fev_orcado'=>$data[ 'fev_orcado' ],
          'mar_orcado'=>$data[ 'mar_orcado' ],
          'abr_orcado'=>$data[ 'abr_orcado' ],
          'mai_orcado'=>$data[ 'mai_orcado' ],
          'jun_orcado'=>$data[ 'jun_orcado' ],
          'jul_orcado'=>$data[ 'jul_orcado' ],
          'ago_orcado'=>$data[ 'ago_orcado' ],
          'set_orcado'=>$data[ 'set_orcado' ],
          'out_orcado'=>$data[ 'out_orcado' ],
          'nov_orcado'=>$data[ 'nov_orcado' ],
          'dez_orcado'=>$data[ 'dez_orcado' ]


        ];
        $data['fromMeses']=true;
        
        $repoHeadcount->createHeadcount($data);
        // dd("repoHeadcount", $repoHeadcount->createHeadcount($data));
      }
    }
    
    //VERIFICA OS REGISTROS QUE JÁ EXISTEM NO REALIZADO E ATUALIZA COM OS VALORES DO ULTIMO FORECAST
    public function updateRealizadoFromForecast($orc_id, $mes, $orc_lotacao_id){
      $olch = new OrcamLotCargoHeadcount();
      $repoHeadcount = new RepoHeadcount();
      $ultimo_periodo = Carbon::parse( $olch->where('lotacao_id', $orc_lotacao_id)->max('periodo'))->format('ymd');
      // dd("ultimo periodo", $ultimo_periodo);
        
      $query_update = 
        "
        SELECT 
            oc.id,
            co.jan_orcado,
            co.fev_orcado,
            co.mar_orcado,
            co.abr_orcado,
            co.mai_orcado,
            co.jun_orcado,
            co.jul_orcado,
            co.ago_orcado,
            co.set_orcado,
            co.out_orcado,
            co.nov_orcado,
            co.dez_orcado 

            FROM tbl_orc_lot_carg_headcount AS olch_f
            
            INNER JOIN	tbl_calc_orcamento co on co.origem_id = olch_f.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
            INNER JOIN  tbl_orc_lot_carg_headcount as olch_r  on olch_r.orc_id = olch_f.orc_id 
                                                              and olch_r.lotacao_id= olch_f.lotacao_id
                                                              and olch_r.tipo_table = 'R'
                                                              and olch_r.orc_cargo_id = olch_f.orc_cargo_id
                                                              and olch_r.orc_turma_id = olch_f.orc_turma_id
            INNER JOIN tbl_calc_orcamento oc on oc.origem_id = olch_r.id and oc.tbl_origem = 'tbl_orc_lot_carg_headcount'
        
            WHERE olch_f.orc_id = $orc_id 
            and olch_f.lotacao_id= $orc_lotacao_id
            and olch_f.tipo_table = 'F' 
            and olch_f.periodo = '$ultimo_periodo'
            and (oc.jan_orcado <> co.jan_orcado OR 
            oc.fev_orcado <> co.fev_orcado OR 
            oc.mar_orcado <> co.mar_orcado OR 
            oc.abr_orcado <> co.abr_orcado OR
            oc.mai_orcado <> co.mai_orcado OR 
            oc.jun_orcado <> co.jun_orcado OR 
            oc.jul_orcado <> co.jul_orcado OR 
            oc.ago_orcado <> co.ago_orcado OR 
            oc.set_orcado <> co.set_orcado OR 
            oc.out_orcado <> co.out_orcado OR 
            oc.nov_orcado <> co.nov_orcado OR 
            oc.dez_orcado <> co.dez_orcado)";

      $data_update = DB::select($query_update);
        // dd("data_update", $data_update);
      foreach ($data_update as $forecast) {
        // $forecast->tipo_table = 'R';
        
        $data = [];
              $data['id'] = $forecast->id;
              $data['jan']= $forecast->jan_orcado;
              $data['fev']= $forecast->fev_orcado;
              $data['mar']= $forecast->mar_orcado;
              $data['abr']= $forecast->abr_orcado;
              $data['mai']= $forecast->mai_orcado;
              $data['jun']= $forecast->jun_orcado;
              $data['jul']= $forecast->jul_orcado;
              $data['ago']= $forecast->ago_orcado;
              $data['set']= $forecast->set_orcado;
              $data['out']= $forecast->out_orcado;
              $data['nov']= $forecast->nov_orcado;
              $data['dez']= $forecast->dez_orcado;

          // $data['fromMeses']=true;
      
        $repoHeadcount->updateHeadcount($data);
        // dd("repoHeadcount",  $repoHeadcount->updateHeadcount($data));
      }
    }

    //VERIFICA OS CARGOS QUE TEM NA FOLHA MAS NÃO TEM NA ORC_LOT_CARG_HEADCOUNT E REALIZA O CADASTRO NA ORC_CARGO
    public function updateCargo($orc_id, $mes, $orc_lotacao_id, $firstDayofMonth, $lastDayofMonth){
      $repoOrcCargo = new RepoOrcCargo();

      $query = "
      select $orc_id as orcamento_id,
            id as cargo_id,
            salario as sal_base,
            salario_max as sal_max,
            salario_medio as sal_med,
            salario_min as sal_med,
            data_salario as data_calc,
            0 as quadro_atual

            from tbl_cargo where id in(
        select distinct cargo_id from tbl_funcionario f
          inner join tbl_orc_lotacao ol on ol.lotacao_id = f.lotacao_id and orcamento_id = $orc_id and ol.cc_custo_id = f.ccusto_id
          inner join tbl_cargo c on c.id = f.cargo_id 
          where cargo_id not in (select cargo_id from tbl_orc_cargo oc where oc.orcamento_id = $orc_id)               
          AND f.[dat_admis_func] <= '$lastDayofMonth'
          AND (f.[dat_demis_func] >=  '$firstDayofMonth' OR f.[dat_demis_func] is null)";

      if(!is_null($orc_lotacao_id)){
        $query = $query. "and ol.id = $orc_lotacao_id";
      }

      $query = $query. ")";

      $new_cargos = DB::select($query);      
      
      // dd("new cargos", $new_cargos);
      foreach ($new_cargos as $cargo) {
        $data = (array)$cargo;
          // insert into tbl_orc_cargo (orcamento_id, cargo_id, sal_base, sal_max, sal_med, sal_min, data_calc, quadro_atual)
        if(!$repoOrcCargo->create($data)){
          $this->setError($repoOrcCargo->getErrosFlatted());
          $this->setSubError("Falha ao inserir registros na tabela tbl_orc_cargo. Erro 211020201133"); 
          return false;
        }
      }      
      return true;
    }

    //VERIFICA AS TURMAS QUE TEM NA FOLHA MAS NÃO TEM NA ORC_LOT_CARG_HEADCOUNT E REALIZA O CADASTRO NA ORC_TURMA
    public function updateTurma($orc_id, $mes, $orc_lotacao_id, $firstDayofMonth, $lastDayofMonth){
      $repoOrcTurma = new RepoOrcTurma();

      $query = "
        select $orc_id as orc_id,
            id as turma_id,
            turno_id as turno_id,
            evento_adc_id as evento_adc_id,
            evento_ext_id as evento_ext_id,
            cdn_turma_trab as cdn_turma_trab,
            des_turma_trab as des_turma_trab,
            adic_noturno as adic_noturno,
            extra_noturno as extra_noturno,
            ativo as ativo,
            origem as origem
        from tbl_turma where id in(
          select distinct turma_id from tbl_funcionario f
            inner join tbl_orc_lotacao ol on ol.lotacao_id = f.lotacao_id and orcamento_id = $orc_id and ol.cc_custo_id = f.ccusto_id
            inner join tbl_turma t on t.id = f.turma_id 
          where turma_id not in (select turma_id from tbl_orc_turma ot where ot.orc_id = $orc_id) 
          AND f.[dat_admis_func] <= '$lastDayofMonth'
		      AND (f.[dat_demis_func] >=  '$firstDayofMonth' OR f.[dat_demis_func] is null)
      ";
      
      if(!is_null($orc_lotacao_id)){
        $query = $query. "and ol.id = $orc_lotacao_id";
      }
      $query = $query. ")";

      $new_turmas = DB::select($query);

      // dd("new turmas", $new_turmas);

      foreach ($new_turmas as $turma) {
        $data = (array)$turma;
        // insert into tbl_orc_turma (orc_id, turma_id, turno_id, evento_adc_id, evento_ext_id, cdn_turma_trab, des_turma_trab, adic_noturno, extra_noturno, ativo, origem)
        if(!$repoOrcTurma->create($data)){
          $this->setError($repoOrcTurma->getErrosFlatted());
          $this->setSubError("Falha ao inserir registros na tabela tbl_orc_turma. Erro 211020201138"); 
          return false;
        }
      }
      return true;
    }

    //VERIFICA AS LOTACOES QUE TEM NA FOLHA MAS NÃO TEM NA ORC_LOTACAO E REALIZA O CADASTRO NA ORC_LOTACAO
    public function updateLotacao($orc_id, $mes, $firstDayofMonth, $lastDayofMonth){
      $repoOrcLotacao = new RepoOrcLotacao();
      // dd('aqui cai updateLotacao');
      //cai aqui?
      
      $query = "SELECT distinct 
        $orc_id as orcamento_id,
        f.lotacao_id, 
        1 responder_orc,
        f.ccusto_id cc_custo_id,
        1 status, 
        0 hc_iniciado,
        1 ativo,
        'O' tipo_table,
        {$this->fillCriadoPor()} as 'created_by',
        getdate() as 'created_at'

        from tbl_funcionario f
        join tbl_lotacao lot on lot.id = f.lotacao_id
        where not exists (select id from tbl_orc_lotacao ol where ol.orcamento_id = $orc_id AND ol.lotacao_id = f.lotacao_id AND ol.cc_custo_id = f.ccusto_id and ol.tipo_table = 'O') 
        AND f.[dat_admis_func] <= '$lastDayofMonth'
        AND (f.[dat_demis_func] >=  '$firstDayofMonth' OR f.[dat_demis_func] is null)
      ";
      
      $new_lotacoes = DB::select($query);

      // dd("new_lotacoes", $new_lotacoes);

      foreach ($new_lotacoes as $lotacao) {
        $data = (array)$lotacao;
        
        if(!$repoOrcLotacao->create($data)){
          $this->setError($repoOrcLotacao->getErrosFlatted());
          $this->setSubError("Falha ao inserir registros na tabela tbl_orc_lotacao. Erro 211020201615"); 
          return false;
        }
      }
      return true;
    }

    //BUSCA OS REGISTROS DO REALIZADO (TBL_ORC_LOT_CARG_HEADCOUNT DO TIPO_TABLE = 'R') E ATUALIZA COM OS VALORES DA FOLHA
    public function updateRealizadoFromFolha($orc_id, $ano, $mes, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary, $orc_lotacao_id){
      $last_day_of_month = $lastDayofMonth;
      $first_day_of_month = $firstDayofMonth;
      // dd('dcakjdnbcjkzxsdj',$last_day_of_month);
      $query_update_realizado_from_folha = "
        select 
          co.id,

          IIF($mes >= 1, (select count(*) from tbl_funcionario as func 
                          WHERE func.cargo_id = funcionario.cargo_id 
                          AND   func.turma_id = funcionario.turma_id 
                          AND   func.lotacao_id = funcionario.lotacao_id 
                          AND   func.[dat_admis_func] <= '$ano-30-01'
                          AND   (func.[dat_demis_func] >=  '$ano-01-01' OR func.[dat_demis_func] is null)
          ), 0)  as qtde_realizado_jan,
        
          IIF($mes >= 2,  (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.lotacao_id = funcionario.lotacao_id 
            AND func.[dat_admis_func] <= '$lastDayOfFebruary'
            AND (func.[dat_demis_func] >=  '$ano-01-02' OR func.[dat_demis_func] is null)
          ), 0)  as qtde_realizado_fev,

          IIF($mes >= 3, (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.lotacao_id = funcionario.lotacao_id 
            AND func.[dat_admis_func] <= '$ano-30-03'
            AND (func.[dat_demis_func] >=  '$ano-01-03' OR func.[dat_demis_func] is null)
          ), 0) as qtde_realizado_mar,

          IIF($mes >= 4, (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.lotacao_id = funcionario.lotacao_id 
            AND func.[dat_admis_func] <= '$ano-30-04'
            AND (func.[dat_demis_func] >=  '$ano-01-04' OR func.[dat_demis_func] is null)
          ), 0) as qtde_realizado_abr,

        IIF($mes >= 5, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-05'
          AND (func.[dat_demis_func] >=  '$ano-01-05' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mai,

        IIF($mes >= 6, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-06'
          AND (func.[dat_demis_func] >=  '$ano-01-06' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jun,

        IIF($mes >= 7, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-07'
          AND (func.[dat_demis_func] >=  '$ano-01-07' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jul,

        IIF($mes >= 8, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-08'
          AND (func.[dat_demis_func] >=  '$ano-01-08' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_ago,

        IIF($mes >= 9, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-09'
          AND (func.[dat_demis_func] >=  '$ano-01-09' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_set,

        IIF($mes >= 10, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-10'
          AND (func.[dat_demis_func] >=  '$ano-01-10' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_out,

        IIF($mes >= 11,(select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.[dat_admis_func] <= '$ano-30-11'
          AND (func.[dat_demis_func] >=  '$ano-01-11' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_nov,


        IIF($mes >= 12, (select count(*) from tbl_funcionario as func 
              WHERE func.cargo_id = funcionario.cargo_id 
              AND func.turma_id = funcionario.turma_id 
              AND func.lotacao_id = funcionario.lotacao_id 
              AND func.[dat_admis_func] <= '$ano-30-12'
              AND (func.[dat_demis_func] >=  '$ano-01-12' OR func.[dat_demis_func] is null)
      
        ), 0 ) as qtde_realizado_dez


        from [tbl_funcionario] as funcionario

        left join tbl_orc_cargo oc on oc.cargo_id = funcionario.cargo_id AND oc.orcamento_id = $orc_id
        left join tbl_orc_turma ot on ot.turma_id = funcionario.turma_id AND ot.orc_id = $orc_id
        left join tbl_orc_lotacao ol on ol.lotacao_id = funcionario.lotacao_id AND ol.orcamento_id = $orc_id
        right join tbl_orc_lot_carg_headcount olch on olch.lotacao_id = ol.id and  olch.orc_cargo_id = oc.id 
        and olch.orc_turma_id = ot.id and olch.tipo_table = 'R' and olch.divergente <> 1
        inner join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = olch.id
        where
          
          funcionario.[dat_admis_func] <= '$last_day_of_month'
          AND (funcionario.[dat_demis_func] >=  '$first_day_of_month' OR funcionario.[dat_demis_func] is null)
      ";
            
      if(!is_null($orc_lotacao_id)){
        $query_update_realizado_from_folha = $query_update_realizado_from_folha. "and ol.id = $orc_lotacao_id";
      }

          //PENSAR NO CASO DE FEVEREIRO QUE É 29 DIAS NO MAXIMO

        $data_update = DB::select($query_update_realizado_from_folha);
        // dd("data_update", $data_update);
        foreach ($data_update as $forecast) {
          // $forecast->tipo_table = 'R';
          
          $data = [];
          $data['id'] = $forecast->id;
          $data['jan']= $forecast->qtde_realizado_jan;
          $data['fev']= $forecast->qtde_realizado_fev;
          $data['mar']= $forecast->qtde_realizado_mar;
          $data['abr']= $forecast->qtde_realizado_abr;
          $data['mai']= $forecast->qtde_realizado_mai;
          $data['jun']= $forecast->qtde_realizado_jun;
          $data['jul']= $forecast->qtde_realizado_jul;
          $data['ago']= $forecast->qtde_realizado_ago;
          $data['set']= $forecast->qtde_realizado_set;
          $data['out']= $forecast->qtde_realizado_out;
          $data['nov']= $forecast->qtde_realizado_nov;
          $data['dez']= $forecast->qtde_realizado_dez;

          // $data['fromMeses']=true;
      
        $update_headcount = $repoHeadcount->updateHeadcount($data);
        if($update_headcount['status'] == "error"){
          $this->setError($update_headcount['msg']);
          $this->setSubError("Falha ao atualizar registros na tabela tbl_orc_lot_carg_headcount. Erro 211020201156"); 
          return false;
        }
      }
      return true;
    }
    
    //BUSCA OS REGISTROS DA FOLHA QUE NÃO EXISTEM NO ORÇAMENTO (TBL_ORC_LOT_CARG_HEADCOUNT DO TIPO_TABLE = 'R') E CRIA COM OS VALORES DA FOLHA
    public function createRealizadoFromFolha ($orc_id, $ano,  $mes, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary, $orc_lotacao_id){
      //BUSCA OS DADOS QUE TEM NA FOLHA MAS NÃO TEM NO REALIZADO
      $repoHeadcount = new RepoHeadcount();
      $ano = date('Y');
      $query_insert_folha = "    
        select 
        ol.id as lotacao_id,
        oc.id as orc_cargo_id,
        ot.id as orc_turma_id,
        $orc_id as orc_id,
        ol.cc_custo_id as ccusto_id,
        null as qtd_func_lot,
        null as atual_total,
        0 as forecast_anterior,
        0 as forecast_total,
        CAST(CONCAT($ano, '-', $mes, '-01') as date) as periodo,
        0 as orcado_anterior,
        0 as forecast_original,
        1 as origem_sistema,
        1 as divergente,


        IIF($mes >= 1, (select count(*) from tbl_funcionario as func 
                        WHERE func.cargo_id = funcionario.cargo_id 
                        AND   func.turma_id = funcionario.turma_id 
                        AND   func.lotacao_id = funcionario.lotacao_id 
                        AND   func.ccusto_id = funcionario.ccusto_id
                        AND   func.[dat_admis_func] <= '".$ano."3001'
                        AND   (func.[dat_demis_func] >=  '".$ano."0101' OR func.[dat_demis_func] is null)
        ), 0)  as qtde_realizado_jan,
        
        IIF($mes >= 2,  (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$lastDayOfFebruary' 
          AND (func.[dat_demis_func] >=  '".$ano."0102' OR func.[dat_demis_func] is null)
        ), 0)  as qtde_realizado_fev,

        

        IIF($mes >= 3, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3003'
          AND (func.[dat_demis_func] >=  '".$ano."0103' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mar,

        IIF($mes >= 4, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3004'
          AND (func.[dat_demis_func] >=  '".$ano."0104' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_abr,

        IIF($mes >= 5, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3005'
          AND (func.[dat_demis_func] >=  '".$ano."0105' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mai,

        IIF($mes >= 6, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3006'
          AND (func.[dat_demis_func] >=  '".$ano."0106' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jun,

        IIF($mes >= 7, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3007'
          AND (func.[dat_demis_func] >=  '".$ano."0107' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jul,

        IIF($mes >= 8, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3008'
          AND (func.[dat_demis_func] >=  '".$ano."0108' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_ago,

        IIF($mes >= 9, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3009'
          AND (func.[dat_demis_func] >=  '".$ano."0109' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_set,

        IIF($mes >= 10, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3010'
          AND (func.[dat_demis_func] >=  '".$ano."0110' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_out,

        IIF($mes >= 11,(select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.lotacao_id = funcionario.lotacao_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."3011'
          AND (func.[dat_demis_func] >=  '".$ano."0111' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_nov,


        IIF($mes >= 12, (select count(*) from tbl_funcionario as func 
              WHERE func.cargo_id = funcionario.cargo_id 
              AND func.turma_id = funcionario.turma_id 
              AND func.lotacao_id = funcionario.lotacao_id 
              AND func.ccusto_id = funcionario.ccusto_id
              AND func.[dat_admis_func] <= '".$ano."3012'
              AND (func.[dat_demis_func] >=  '".$ano."0112' OR func.[dat_demis_func] is null)
        ), 0 ) as qtde_realizado_dez


        from [tbl_funcionario] as funcionario

        left join tbl_orc_cargo oc on oc.cargo_id = funcionario.cargo_id AND oc.orcamento_id = $orc_id
        left join tbl_orc_turma ot on ot.turma_id = funcionario.turma_id AND ot.orc_id = $orc_id
        left join tbl_orc_lotacao ol on ol.lotacao_id = funcionario.lotacao_id AND ol.cc_custo_id = funcionario.ccusto_id AND ol.orcamento_id = $orc_id

        where 
          
          funcionario.[dat_admis_func] <= '$lastDayofMonth'
          AND (funcionario.[dat_demis_func] >=  '$firstDayofMonth' OR funcionario.[dat_demis_func] is null)
          AND  not exists (SELECT * FROM tbl_orc_lot_carg_headcount as hc WHERE hc.tipo_table = 'R' 
                                                                          and hc.lotacao_id = ol.id 
                                                                          and hc.orc_cargo_id = oc.id
                                                                          and hc.orc_turma_id = ot.id)
      ";

              
      if(!is_null($orc_lotacao_id)){
        $query_insert_folha = $query_insert_folha. "AND ol.id =  $orc_lotacao_id";
      }

      $query_insert_folha = $query_insert_folha."      
        group by ol.id,
        oc.id,
        ot.id,
        funcionario.lotacao_id,
        funcionario.ccusto_id,
        ol.cc_custo_id,
        funcionario.cargo_id,
        funcionario.turma_id
      ";

      $data_insert = DB::select($query_insert_folha);
      // dd("data insert", $data_insert);
      foreach ($data_insert as $forecast) {
        $forecast->tipo_table = 'R';
        
        $data = (array)$forecast;
        $data['meses_orcado'] = [
          'jan_orcado'=>$data['qtde_realizado_jan'],
          'fev_orcado'=>$data['qtde_realizado_fev'],
          'mar_orcado'=>$data['qtde_realizado_mar'],
          'abr_orcado'=>$data['qtde_realizado_abr'],
          'mai_orcado'=>$data['qtde_realizado_mai'],
          'jun_orcado'=>$data['qtde_realizado_jun'],
          'jul_orcado'=>$data['qtde_realizado_jul'],
          'ago_orcado'=>$data['qtde_realizado_ago'],
          'set_orcado'=>$data['qtde_realizado_set'],
          'out_orcado'=>$data['qtde_realizado_out'],
          'nov_orcado'=>$data['qtde_realizado_nov'],
          'dez_orcado'=>$data['qtde_realizado_dez']


        ];
        $data['fromMeses']=true;
        $create_headcount = $repoHeadcount->createHeadcount($data);
        
        // dd('aqui 5', $create_headcount['status'] == "error");
        if($create_headcount['status'] == "error"){
          $this->setError($create_headcount['msg']);
          $this->setSubError("Falha ao inserir registros na tabela tbl_orc_lot_carg_headcount. Erro 211020201157 - ".$create_headcount['submsg']); 
          return false;
        }
        // $repoHeadcount->makeModel();
        // dd("repoHeadcount", $repoHeadcount->createHeadcount($data));
      }
      return true;
    }

    //CHAMA OS METODOS DE ATUALIZAÇÃO
    public function updatedFromFolha($orc_id, $mes, $orc_lotacao_id=NULL){
      $mes_accept_values = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12];
      // EX.: EXISTE NA FOLHA MAS NÃO EXISTE UM REGISTRO DO TIPO 'R' PARA ELE, É FEITA A BUSCA E A INSERÇÃO E É MARCADO COMO DIVERGENTE
      // EX.: EXISTE NA FOLHA E TEM UM REGISTRO DO TIPO 'R' MAS COM VALORES DIFERENTES, É FEITA A BUSCA E A ATUALIZAÇÃO DOS DADOS NO REGISTRO
      // TIPO 'R' COM BASE NA FOLHA SEM MARCAR COMO DIVERGENTE
      // EX.: NÃO EXISTE NA FOLHA MAS EXISTE UM REGISTRO DO TIPO 'R', É ATUALIZADO INSERINDO 0 PARA ESTE REGISTRO, SEM MARCAR COMO DIVERGENTE

      $repoHeadcount = new RepoHeadcount();
      $ano = Orcamento::find($orc_id)->ano;
      $lastDayOfFebruary = Carbon::parse($ano. '-'. '2-01')->endOfMonth()->format('Ymd');
      $firstDayofMonth = Carbon::parse($mes)->startOfMonth()->format('Ymd');
      $lastDayofMonth = Carbon::parse($mes)->endOfMonth()->format('Ymd');

      if(!in_array($mes, $mes_accept_values)){
        $mes = explode('-', $mes)[1];
      }

      //PEGA AS LOTACOES QUE TEM NA FOLHA E NÃO TEM NA ORC LOTACAO E INSERE NA ORC LOTACAO
      if(!$this->updateLotacao($orc_id, $mes, $firstDayofMonth, $lastDayofMonth)){
        return false;
      }

      //PEGA OS CARGOS QUE TEM NA FOLHA E NÃO TEM NA ORC CARGO E INSERE NA ORC CARGO
      if(!$this->updateCargo($orc_id, $mes, $orc_lotacao_id, $firstDayofMonth, $lastDayofMonth)){
        return false;
      }
      //PEGA AS TURMAS QUE TEM NA FOLHA E NÃO TEM NA ORC TURMA E INSERE NA ORC TURMA 
      if(!$this->updateTurma($orc_id, $mes, $orc_lotacao_id, $firstDayofMonth, $lastDayofMonth)){
        return false;
      }
      //ATUALIZA OS REGISTROS DO TIPO 'R' COM OS VALORES DA FOLHA
      if(!$this->updateRealizadoFromFolha($orc_id, $ano,  $mes, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary, $orc_lotacao_id)){
        return false;
      }
      // CRIA REGISTROS DO TIPO 'R' QUE EXISTEM NA FOLHA MAS NÃO EXISTEM NO ORÇAMENTO
      if(!$this->createRealizadoFromFolha($orc_id, $ano,  $mes, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary, $orc_lotacao_id)){
        return false;
      }

      return true;
    }

    //FUNÇAO QUE UNE TODOS OS METODOS DE ATUALIZAÇÃO QUE DEVERÃO SER CHAMADOS NO BOTÃO 'LIBERAR FORECAST' NA ABA DADOS DO ORÇAMENTO - PARAMETRZAÇÕES
    public function updateRealizadoWithForecast($orc_id, $periodo){
      // dd('cai caqui 1');
      $ano = Orcamento::find($orc_id)->ano;
      $mes = Carbon::parse($periodo)->format('m');
      $lastDayOfFebruary = Carbon::parse($ano. '-'. '2-01')->endOfMonth()->format('Ymd');
      $firstDayofMonth = Carbon::parse($periodo)->startOfMonth()->format('Ymd');
      $lastDayofMonth = Carbon::parse($periodo)->endOfMonth()->format('Ymd');
      $user= $this->getUserFromCurrentGuard();
      $user_id = $user->id;
      $this->updateCargoOrcMes($orc_id);
      $this->updateTurmaOrcMes($orc_id, $lastDayofMonth);
      $this->updateLotacao($orc_id, $mes, $firstDayofMonth, $lastDayofMonth);
      // $this->createRealizadoFromForecast($orc_id, null,$periodo);
      // $this->createRealizadoFromFolhaOrcMes($orc_id,$mes, $ano, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary);

      //PEGA OS CARGOS QUE TEM NA FOLHA E NÃO TEM NA ORC CARGO E INSERE NA ORC CARGO SEM FILTRAR POR LOTACAO
      //PEGA AS TURMAS QUE TEM NA FOLHA E NÃO TEM NA ORC TURMA E INSERE NA ORC TURMA SEM FILTRAR POR LOTACAO      
      //VERIFICA AS LOTACOES QUE TEM NA FOLHA MAS NÃO TEM NA ORC_LOTACAO E REALIZA O CADASTRO NA ORC_LOTACAO
  

 
      //VERIFICA O ULTIMO FORECAST E CRIA OS MESMOS REGISTROS COM O TIPO 'R'

      // $res = DB::statement(DB::raw("
      // SET NOCOUNT ON ;
      // EXEC	[dbo].[insert_headcount_realizado_from_forecast]
      //     @orc_id = $orc_id,
      //     @user = $user_id,
      //     @periodo = '$periodo';        
                
      // ")); 
     
      // CRIA REGISTROS DO TIPO 'R' QUE EXISTEM NA FOLHA MAS NÃO EXISTEM NO ORÇAMENTO SEM FILTRAR POR LOTACAO, FIXANDO MES COMO 01

      $res = DB::statement(DB::raw("
      SET NOCOUNT ON ;
      EXEC	[dbo].[insert_headcount_realizado_from_folha]
          @id_orc = $orc_id,
          @user = $user_id,
          @mes = '$mes';        
      ")); 

      //ATUALIZA OS REGISTROS DO TIPO 'R' COM OS VALORES DA FOLHA SEM FILTRAR POR LOTACAO, FIXANDO MES COMO 01
      $res = DB::statement(DB::raw("
      SET NOCOUNT ON ;
      EXEC	[dbo].[update_headcount_realizado_from_folha]
         @id_orc = $orc_id,
         @mes = '$mes'
      ")); 
    } 
          
    public function updateCargoOrcMes($orc_id){
      //PEGA OS CARGOS DE FUNCIONARIOS NÃO DEMITIDOS, QUE AINDA NÃO EXISTAM ORC CARGO DO TIPO O E INSERE
      $repoOrcCargo = new RepoOrcCargo();
      $new_cargos = DB::select("SELECT $orc_id as orcamento_id,
              id as cargo_id,
              salario as sal_base,
              salario_max as sal_max,
              salario_medio as sal_med,
              salario_min as sal_med,
              data_salario as data_calc,
              0 as quadro_atual,
              'O' tipo_table,
              {$this->fillCriadoPor()} as 'created_by',
              getdate() as 'created_at'

              from tbl_cargo where id in(
          select distinct cargo_id from tbl_funcionario f
            inner join tbl_cargo c on c.id = f.cargo_id 
            where cargo_id not in (select cargo_id from tbl_orc_cargo oc where oc.orcamento_id = $orc_id and tipo_table = 'O') 
              and f.dat_demis_func is null
        )"
      );
      
      // dd("new cargos", $new_cargos);
        foreach ($new_cargos as $cargo) {
          $data = (array)$cargo;
            // insert into tbl_orc_cargo (orcamento_id, cargo_id, sal_base, sal_max, sal_med, sal_min, data_calc, quadro_atual)


          $repoOrcCargo->create($data);
        }
    }

    public function updateTurmaOrcMes($orc_id, $lastDayofMonth){
      //PEGA OS CARGOS DE FUNCIONARIOS NÃO DEMITIDOS, QUE AINDA NÃO EXISTAM ORC TURma DO TIPO O E INSERE

      $repoOrcTurma = new RepoOrcTurma();
      $new_turmas = DB::select("SELECT $orc_id as orc_id,
            id as turma_id,
            turno_id as turno_id,
            evento_adc_id as evento_adc_id,
            evento_ext_id as evento_ext_id,
            cdn_turma_trab as cdn_turma_trab,
            des_turma_trab as des_turma_trab,
            adic_noturno as adic_noturno,
            extra_noturno as extra_noturno,
            ativo as ativo,
            origem as origem,
            'O' tipo_table,
            {$this->fillCriadoPor()} as 'created_by',
            getdate() as 'created_at'
            
        from tbl_turma where id in(
          select distinct turma_id from tbl_funcionario f
            inner join tbl_turma t on t.id = f.turma_id 
          where turma_id not in (select turma_id from tbl_orc_turma ot where ot.orc_id = $orc_id and tipo_table = 'O') 
          and (f.dat_demis_func is null OR f.dat_demis_func >= '$lastDayofMonth')
		     AND f.dat_admis_func <= '$lastDayofMonth'         
    
        )");
      // dd("new turmas", $new_turmas);

        foreach ($new_turmas as $turma) {
          $data = (array)$turma;
          // insert into tbl_orc_turma (orc_id, turma_id, turno_id, evento_adc_id, evento_ext_id, cdn_turma_trab, des_turma_trab, adic_noturno, extra_noturno, ativo, origem)

          $repoOrcTurma->create($data);
        }
    }

    public function updateRealizadoFromFolhaOrcMes($orc_id,$mes, $ano, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary){
     
      $query_update_realizado_from_folha = "
        select 
          co.id,

          IIF($mes >= 1, (select count(*) from tbl_funcionario as func 
                          WHERE func.cargo_id = funcionario.cargo_id 
                          AND   func.turma_id = funcionario.turma_id 
                          AND func.ccusto_id = funcionario.ccusto_id
                          AND   func.[dat_admis_func] <= '$ano-01-31'
                          AND   (func.[dat_demis_func] >  '$ano-01-31' OR func.[dat_demis_func] is null)
          ), 0)  as qtde_realizado_jan,
        
          IIF($mes >= 2,  (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.ccusto_id = funcionario.ccusto_id
            AND func.[dat_admis_func] <= '$lastDayOfFebruary'
            AND (func.[dat_demis_func] >  '$lastDayOfFebruary' OR func.[dat_demis_func] is null)
          ), 0)  as qtde_realizado_fev,

          IIF($mes >= 3, (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.ccusto_id = funcionario.ccusto_id
            AND func.[dat_admis_func] <= '$ano-03-30'
            AND (func.[dat_demis_func] >  '$ano-03-31' OR func.[dat_demis_func] is null)
          ), 0) as qtde_realizado_mar,

          IIF($mes >= 4, (select count(*) from tbl_funcionario as func 
            WHERE func.cargo_id = funcionario.cargo_id 
            AND func.turma_id = funcionario.turma_id 
            AND func.ccusto_id = funcionario.ccusto_id
            AND func.[dat_admis_func] <= '$ano-04-30'
            AND (func.[dat_demis_func] >  '$ano-04-30' OR func.[dat_demis_func] is null)
          ), 0) as qtde_realizado_abr,

        IIF($mes >= 5, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-05-31'
          AND (func.[dat_demis_func] >  '$ano-05-31' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mai,

        IIF($mes >= 6, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-06-30'
          AND (func.[dat_demis_func] >  '$ano-06-30' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jun,

        IIF($mes >= 7, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-07-31'
          AND (func.[dat_demis_func] >  '$ano-07-31' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jul,

        IIF($mes >= 8, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-08-31'
          AND (func.[dat_demis_func] >  '$ano-08-31' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_ago,

        IIF($mes >= 9, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-09-30'
          AND (func.[dat_demis_func] >  '$ano-09-30' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_set,

        IIF($mes >= 10, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-10-31'
          AND (func.[dat_demis_func] >  '$ano-10-31' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_out,

        IIF($mes >= 11,(select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$ano-11-30'
          AND (func.[dat_demis_func] >  '$ano-11-30' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_nov,


        IIF($mes >= 12, (select count(*) from tbl_funcionario as func 
              WHERE func.cargo_id = funcionario.cargo_id 
              AND func.turma_id = funcionario.turma_id 
              AND func.ccusto_id = funcionario.ccusto_id
              AND func.[dat_admis_func] <= '$ano-12-31'
              AND (func.[dat_demis_func] >  '$ano-12-31' OR func.[dat_demis_func] is null)
      
        ), 0 ) as qtde_realizado_dez


        from [tbl_funcionario] as funcionario

        left join tbl_orc_cargo oc on oc.cargo_id = funcionario.cargo_id AND oc.orcamento_id = $orc_id
        left join tbl_orc_turma ot on ot.turma_id = funcionario.turma_id AND ot.orc_id = $orc_id
        right join tbl_orc_lot_carg_headcount olch on olch.orc_cargo_id = oc.id  
        and olch.orc_turma_id = ot.id and olch.tipo_table = 'R'
        -- and olch.divergente <> 1
        inner join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = olch.id
        where funcionario.[dat_admis_func] <= '$lastDayofMonth'
          AND (funcionario.[dat_demis_func] >  '$lastDayofMonth' OR funcionario.[dat_demis_func] is null)";

        $data_update = DB::select($query_update_realizado_from_folha);
        // dd("data_update", $data_update);
        foreach ($data_update as $forecast) {
          // $forecast->tipo_table = 'R';
          
          $data = [];
          $data['id'] = $forecast->id;
          $data['jan']= $forecast->qtde_realizado_jan;
          $data['fev']= $forecast->qtde_realizado_fev;
          $data['mar']= $forecast->qtde_realizado_mar;
          $data['abr']= $forecast->qtde_realizado_abr;
          $data['mai']= $forecast->qtde_realizado_mai;
          $data['jun']= $forecast->qtde_realizado_jun;
          $data['jul']= $forecast->qtde_realizado_jul;
          $data['ago']= $forecast->qtde_realizado_ago;
          $data['set']= $forecast->qtde_realizado_set;
          $data['out']= $forecast->qtde_realizado_out;
          $data['nov']= $forecast->qtde_realizado_nov;
          $data['dez']= $forecast->qtde_realizado_dez;

          // $data['fromMeses']=true;
      
         $repoHeadcount->updateHeadcount($data);
        // dd("repoHeadcount",  $repoHeadcount->updateHeadcount($data));
      }
    }

    public function createRealizadoFromFolhaOrcMes($orc_id,$mes, $ano, $firstDayofMonth, $lastDayofMonth, $lastDayOfFebruary){
      // dd("é aqui");
      //BUSCA OS DADOS QUE TEM NA FOLHA MAS NÃO TEM NO REALIZADO
      $repoHeadcount = new RepoHeadcount();
      $query_insert_folha = "    
        select 
        ol.id as lotacao_id,
        ol.cc_custo_id as ccusto_id,
        oc.id as orc_cargo_id,
        ot.id as orc_turma_id,
        $orc_id as orc_id,
        null as qtd_func_lot,
        null as atual_total,
        0 as forecast_anterior,
        0 as forecast_total,
        CAST(CONCAT($ano, '-', $mes, '-01') as date) as periodo,
        0 as orcado_anterior,
        0 as forecast_original,
        1 as origem_sistema,
        1 as divergente,


        IIF($mes >= 1, (select count(*) from tbl_funcionario as func 
                        WHERE func.cargo_id = funcionario.cargo_id 
                        AND   func.turma_id = funcionario.turma_id
                        AND func.ccusto_id = funcionario.ccusto_id 
                        AND   func.[dat_admis_func] <= '".$ano."0131'
                        AND   (func.[dat_demis_func] >  '".$ano."0131' OR func.[dat_demis_func] is null)
        ), 0)  as qtde_realizado_jan,
        
        IIF($mes >= 2,  (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '$lastDayOfFebruary'
          AND (func.[dat_demis_func] >  '$lastDayOfFebruary' OR func.[dat_demis_func] is null)
        ), 0)  as qtde_realizado_fev,

        IIF($mes >= 3, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0331'
          AND (func.[dat_demis_func] >  '".$ano."0331' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mar,

        IIF($mes >= 4, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0430'
          AND (func.[dat_demis_func] >  '".$ano."0430' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_abr,

        IIF($mes >= 5, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0531'
          AND (func.[dat_demis_func] >  '".$ano."0531' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_mai,

        IIF($mes >= 6, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0630'
          AND (func.[dat_demis_func] >  '".$ano."0630' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jun,

        IIF($mes >= 7, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0731'
          AND (func.[dat_demis_func] >  '".$ano."0731' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_jul,

        IIF($mes >= 8, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0831'
          AND (func.[dat_demis_func] >  '".$ano."0831' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_ago,

        IIF($mes >= 9, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."0930'
          AND (func.[dat_demis_func] > '".$ano."0930' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_set,

        IIF($mes >= 10, (select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."1031'
          AND (func.[dat_demis_func] >  '".$ano."1031' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_out,

        IIF($mes >= 11,(select count(*) from tbl_funcionario as func 
          WHERE func.cargo_id = funcionario.cargo_id 
          AND func.turma_id = funcionario.turma_id 
          AND func.ccusto_id = funcionario.ccusto_id
          AND func.[dat_admis_func] <= '".$ano."1130'
          AND (func.[dat_demis_func] >  '".$ano."1130' OR func.[dat_demis_func] is null)
        ), 0) as qtde_realizado_nov,


        IIF($mes >= 12, (select count(*) from tbl_funcionario as func 
              WHERE func.cargo_id = funcionario.cargo_id 
              AND func.turma_id = funcionario.turma_id 
              AND func.ccusto_id = funcionario.ccusto_id
              AND func.[dat_admis_func] <= '".$ano."1231'
              AND (func.[dat_demis_func] >  '".$ano."1231' OR func.[dat_demis_func] is null)
        ), 0 ) as qtde_realizado_dez


        from [tbl_funcionario] as funcionario

        left join tbl_orc_cargo oc on oc.cargo_id = funcionario.cargo_id AND oc.orcamento_id = $orc_id
        left join tbl_orc_turma ot on ot.turma_id = funcionario.turma_id AND ot.orc_id = $orc_id
        left join tbl_orc_lotacao ol on ol.lotacao_id = funcionario.lotacao_id AND ol.orcamento_id = $orc_id


        where funcionario.[dat_admis_func] <= '$lastDayofMonth'
          AND (funcionario.[dat_demis_func] >  '$lastDayofMonth' OR funcionario.[dat_demis_func] is null)
          AND  not exists (SELECT * FROM tbl_orc_lot_carg_headcount as hc WHERE hc.tipo_table = 'R' 
                                                                          and hc.orc_cargo_id = oc.id
                                                                          and hc.orc_turma_id = ot.id
                                                                          
                                                                          )";

                        //  dd("é aqui", $query_insert_folha);


      $data_insert = DB::select($query_insert_folha);
      // dd("data insert", $data_insert);
      foreach ($data_insert as $forecast) {
        $forecast->tipo_table = 'R';
        
        $data = (array)$forecast;
        $data['meses_orcado'] = [
          'jan_orcado'=>$data['qtde_realizado_jan'],
          'fev_orcado'=>$data['qtde_realizado_fev'],
          'mar_orcado'=>$data['qtde_realizado_mar'],
          'abr_orcado'=>$data['qtde_realizado_abr'],
          'mai_orcado'=>$data['qtde_realizado_mai'],
          'jun_orcado'=>$data['qtde_realizado_jun'],
          'jul_orcado'=>$data['qtde_realizado_jul'],
          'ago_orcado'=>$data['qtde_realizado_ago'],
          'set_orcado'=>$data['qtde_realizado_set'],
          'out_orcado'=>$data['qtde_realizado_out'],
          'nov_orcado'=>$data['qtde_realizado_nov'],
          'dez_orcado'=>$data['qtde_realizado_dez']


        ];
        $data['fromMeses']=true;
        
        $repoHeadcount->createHeadcount($data);
        // dd("repoHeadcount", $repoHeadcount->createHeadcount($data));

      }
    }
    
    public function execSpsFolha($orc_id,$periodo){
      $user= $this->getUserFromCurrentGuard();
      $user_id = $user->id;
      $mes = Carbon::parse($periodo)->format('m');

      try{
        $res = DB::statement(DB::raw("
        SET NOCOUNT ON ;
        EXEC	[dbo].[insert_headcount_realizado_from_folha]
            @id_orc = $orc_id,
            @user = $user_id,
            @mes = '$mes';        
        "));
  
        //ATUALIZA OS REGISTROS DO TIPO 'R' COM OS VALORES DA FOLHA SEM FILTRAR POR LOTACAO, FIXANDO MES COMO 01
        $res = DB::statement(DB::raw("
        SET NOCOUNT ON ;
        EXEC	[dbo].[update_headcount_realizado_from_folha]
           @id_orc = $orc_id,
           @mes = '$mes'
        "));   
      }
      catch(\Illuminate\Database\QueryException $ex){ 
        $this->setError($ex->getMessage());
        return false;
      }
            
   
      return true;
    }

    
} 
