<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;


use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;
class RepoRealizadoContratacoes extends RepositoryNat51
{ 

     use \App\Core\Traits\ParamTrait;
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcHeadcountContratacoes'; 


    public function listarAll($orc_id,$orc_lotacao_id,  $mes, $filtro){        
        // $data = $this->listajson();
        // dd($tipo_table);     
        // return new Response($data , 200);  
        // $this->setCodTela('REALCONT');      
        // $this->podeAcessar('listar',true,$this->getCodTela());
        $tb_orc_headcount_contrat = new OrcHeadcountContratacoes();        
        $tb_cargo = new Cargo();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tbl_funcionario = new Funcionario();
  
        DB::enableQueryLog();

        if(!is_null($filtro) && $filtro == 1){
            $where_periodo = " AND month([tbl_funcionario].dat_admis_func = $mes )";
         } else {
            $where_periodo = "";
         }

                   $data = DB::select("select CASE MONTH(tbl_funcionario.dat_admis_func) 
                WHEN 1 THEN 'Janeiro'
                WHEN 2 THEN 'Fevereiro'
                WHEN 3 THEN 'Março'
                WHEN 4 THEN 'Abril'
                WHEN 5 THEN 'Maio'
                WHEN 6 THEN 'Junho'
                WHEN 7 THEN 'Julho'
                WHEN 8 THEN 'Agosto'
                WHEN 9 THEN 'Setembro'
                WHEN 10 THEN 'Outubro'
                WHEN 11 THEN 'Novembro'
                WHEN 12 THEN 'Dezembro'
                END as mes
                , [tbl_orc_headcount_contratacoes].[orc_cargo_id]
                , [tbl_orc_headcount_contratacoes].[orc_turma_id]
                , [tbl_funcionario].[cdn_funcionario]
                , [tbl_funcionario].[nome_funcionario]
                , [tbl_funcionario].[dat_admis_func]
                , [tbl_funcionario].[cargo_id]
                , [tbl_cargo].[cod_cargo_basic]
                , [tbl_cargo].[des_cargo_basic]
                , [tbl_orc_turma].[cdn_turma_trab]
                , [tbl_orc_turma].[des_turma_trab]
                , [tbl_turno].[cdn_turno_trab]
                , [tbl_turno].[des_turno_trab]  
                

                from [tbl_orc_headcount_contratacoes] 
                inner join [tbl_orc_lotacao] on [tbl_orc_headcount_contratacoes].[lotacao_id] = [tbl_orc_lotacao].[id] 
                inner join [tbl_orc_cargo] on [tbl_orc_headcount_contratacoes].[orc_cargo_id] = [tbl_orc_cargo].[id] 
                inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
                inner join [tbl_orc_turma] on [tbl_orc_headcount_contratacoes].[orc_turma_id] = [tbl_orc_turma].[id] 
                inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 
                inner join [tbl_funcionario] on [tbl_funcionario].[id] = [tbl_orc_headcount_contratacoes].[func_id] 
                
                where [tbl_orc_headcount_contratacoes].[orcamento_id] = $orc_id 
                --and [tbl_orc_headcount_contratacoes].[lotacao_id] = $orc_lotacao_id 
                and tbl_orc_headcount_contratacoes.lotacao_id in (select id from tbl_orc_lotacao ol_orc where tipo_table = 'O' 
                and exists (select * from tbl_orc_lotacao ol_fcst where id = $orc_lotacao_id 
                and ol_fcst.lotacao_id = ol_orc.lotacao_id and ol_fcst.cc_custo_id = ol_orc.cc_custo_id))
                $where_periodo

                ");

                // dd($data);

                // dd("query", DB::getQueryLog()); 
          
           
            
            if(!is_null($filtro) && $filtro == 1){
                $data =  $data = $data->whereRaw("MONTH({$tb_orc_headcount_contrat->getColunaAlias('periodo')}) =  {$mes}");
                }

            $data = json_decode(json_encode($data), true);
    
            
            // dd("query", $data); 
            // dd("query", DB::getQueryLog()); 

            // dd("testeee contrat",$data);
            // dd("pivooooo",$this->pivo($data));
        return $data;
      }

}