<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcHoraExtra;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;

class RepoRealizadoHoraExtra extends RepositoryNat51
{ 

     use \App\Core\Traits\ParamTrait;
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcHoraExtra'; 

    public function listarAll($orc_id,$orc_lotacao_id, $periodo, $filtro){    
        
        
        // $this->setCodTela('REALHRE');      
        // $this->podeAcessar('listar',true,$this->getCodTela());
        
        $query = "
        
            select 
                oc.id 'orc_cargo_id',
                ot.id 'orc_turma_id',
                hre.evento_id, 
                c.cod_cargo_basic, 
                c.des_cargo_basic, 
                CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as 'cargo',
                tm.cdn_turma_trab, 
                tm.des_turma_trab, 
                CONCAT(tm.cdn_turma_trab, ' - ', tm.des_turma_trab) as 'turma',
                tn.cdn_turno_trab, 
                tn.des_turno_trab, 
                CONCAT(tn.cdn_turno_trab, ' - ', tn.des_turno_trab) as 'turno',
                CONCAT(tm.cdn_turma_trab, ' - ', tm.des_turma_trab, '-', tn.cdn_turno_trab, ' - ', tn.des_turno_trab) as 'turma_turno',
                e.cdn_event, 
                e.des_event, 
                CONCAT(e.cdn_event, ' - ', e.des_event) as 'evento',
                

                CASE MONTH(hre.periodo) 
                    WHEN 1 THEN 'Janeiro'
                    WHEN 2 THEN 'Fevereiro'
                    WHEN 3 THEN 'Março'
                    WHEN 4 THEN 'Abril'
                    WHEN 5 THEN 'Maio'
                    WHEN 6 THEN 'Junho'
                    WHEN 7 THEN 'Julho'
                    WHEN 8 THEN 'Agosto'
                    WHEN 9 THEN 'Setembro'
                    WHEN 10 THEN 'Outubro'
                    WHEN 11 THEN 'Novembro'
                    WHEN 12 THEN 'Dezembro'
                END as mes,

                ISNULL(co.jan_orcado, 0) 'jan',
                ISNULL(co.fev_orcado, 0) 'fev',
                ISNULL(co.mar_orcado, 0) 'mar',
                ISNULL(co.abr_orcado, 0) 'abr',
                ISNULL(co.mai_orcado, 0) 'mai',
                ISNULL(co.jun_orcado, 0) 'jun',
                ISNULL(co.jul_orcado, 0) 'jul',
                ISNULL(co.ago_orcado, 0) 'ago',
                ISNULL(co.set_orcado, 0) 'set',
                ISNULL(co.out_orcado, 0) 'out',
                ISNULL(co.nov_orcado, 0) 'nov',
                ISNULL(co.dez_orcado, 0) 'dez',


                SUM(ISNULL(co.jan_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_jan',
                SUM(ISNULL(co.fev_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_fev',
                SUM(ISNULL(co.mar_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_mar',
                SUM(ISNULL(co.abr_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_abr',
                SUM(ISNULL(co.mai_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_mai',
                SUM(ISNULL(co.jun_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_jun',
                SUM(ISNULL(co.jul_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_jul',
                SUM(ISNULL(co.ago_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_ago',
                SUM(ISNULL(co.set_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_set',
                SUM(ISNULL(co.out_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_out',
                SUM(ISNULL(co.nov_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_nov',
                SUM(ISNULL(co.dez_orcado, 0)) OVER(PARTITION BY hre.orc_cargo_id, hre.orc_turma_id, hre.periodo ) as 'total_dez'

                from tbl_headcount_hra_extra hre
                join tbl_orc_cargo oc on oc.id = hre.orc_cargo_id
                join tbl_orc_turma ot on ot.id = hre.orc_turma_id
                join tbl_orc_hora_extra ohre on ohre.id = hre.evento_id
                join tbl_eventos e on e.id = ohre.evento_id
                join tbl_cargo c on c.id = oc.cargo_id
                join tbl_turma tm on tm.id = ot.turma_id
                join tbl_turno tn on tn.id = ot.turno_id
                join tbl_calc_orcamento co on co.origem_id = hre.id and co.tbl_origem = 'tbl_headcount_hra_extra'

                where hre.tipo_table = 'R' 
                AND hre.orc_id = $orc_id
             --   AND hre.lotacao_id = $orc_lotacao_id 
             
             and hre.lotacao_id in (select id from tbl_orc_lotacao ol_orc where tipo_table = 'O' 
             and exists (select * from tbl_orc_lotacao ol_fcst where id = $orc_lotacao_id
             and ol_fcst.lotacao_id = ol_orc.lotacao_id and ol_fcst.cc_custo_id = ol_orc.cc_custo_id))	
             and hre.tipo_table = 'R'
             ";
                // AND hre.periodo = $periodo";

                if(!is_null($filtro) && $filtro == 1){
                    $query = $query." AND MONTH(hre.periodo) = {$periodo}";
                }
                
                
                $data = DB::select($query);
                $dados = [];
                $data = json_decode(json_encode($data), true);
                // for($i = 0; $i < count($data); $i++){
                
                //     $dados[$i] = (array)$data[$i];
                //     $dados[$i]['total_count'] = count($data);
                // }
            // dd("testeee",$data);

        return $data;
        
    }
}