<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;


use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;
class RepoRealizadoPromocoesTrans extends RepositoryNat51
{ 

     use \App\Core\Traits\ParamTrait;
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcPromocao'; 


    public function listarAll($orc_id, $orc_lotacao_id, $mes, $filtro){        
        // $data = $this->listajson();
        // dd($tipo_table);     
        // return new Response($data , 200);  
        // $this->setCodTela('REALPROM');      
        // $this->podeAcessar('listar',true,$this->getCodTela());
        $tb_orc_promocao = new OrcPromocao();        
        $tb_cargo = new Cargo();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tbl_funcionario = new Funcionario();
  
        DB::enableQueryLog();
        $query = "
        select
            
        CONCAT(func.cdn_funcionario, ' - ', func.nome_funcionario ) as description_func,
        CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) as description_cargo,
        CONCAT(c_p.cod_cargo_basic, ' - ', c_p.des_cargo_basic) as description_cargo_promovido,
        CONCAT(t.cdn_turma_trab, ' - ', t.des_turma_trab) as description_turma,
        CONCAT(t_p.cdn_turma_trab, ' - ', t_p.des_turma_trab) as description_turma_promovido,
        CONCAT(l.unid_lotac, ' - ', l.des_unid_lotac) as description_lotacao,
        CONCAT(l_p.unid_lotac, ' - ', l_p.des_unid_lotac) as description_lotacao_promovida,
        CONCAT(cc.cod_ccusto, ' - ',cc.des_ccusto) as description_ccusto,
        CONCAT(cc_p.cod_ccusto, ' - ',cc.des_ccusto) as description_ccusto_promovida,

            CASE mes_promocao
                
                WHEN 1 THEN 'Janeiro'
                WHEN 2 THEN 'Fevereiro'
                WHEN 3 THEN 'Março'
                WHEN 4 THEN 'Abril'
                WHEN 5 THEN 'Maio'
                WHEN 6 THEN 'Junho'
                WHEN 7 THEN 'Julho'
                WHEN 8 THEN 'Agosto'
                WHEN 9 THEN 'Setembro'
                WHEN 10 THEN 'Outubro'
                WHEN 11 THEN 'Novembro'
                WHEN 12 THEN 'Dezembro'
            END  as mes_promocao,
        
            func.cdn_funcionario,
            func.nome_funcionario,
            

            c.cod_cargo_basic as cargo_cod_atual,
            c.des_cargo_basic as cargo_atual,
            op.cargo_atual_id,

            c_p.cod_cargo_basic as cargo_promovido_cod,
            c_p.des_cargo_basic as cargo_promovido,
            op.cargo_promovido_id,
            
            
            t.cdn_turma_trab as turma_id,
            t.des_turma_trab as turma,
            op.turma_atual_id,

            t_p.cdn_turma_trab as turma_promovida_cdn,
            t_p.des_turma_trab as turma_promovida,
            op.turma_promovida_id,
            
            
            l.unid_lotac as lotacao_cod,
            l.des_unid_lotac as lotacao,
            op.lotacao_id,

            l_p.unid_lotac as lotacao_promovida_cod,
            l_p.des_unid_lotac as lotacao_promovida,
            op.lotacao_promovida_id,
            

        
            op.ccusto_id,
            op.ccusto_promovido_id,

        
            IIF(op.cargo_atual_id = op.cargo_promovido_id, 0, 1) as promocao_cargo,
            IIF(op.turma_atual_id = op.turma_promovida_id, 0, 1) as promocao_turma,
            IIF(op.lotacao_id = op.lotacao_promovida_id, 0,1 ) as promocao_lotacao,
            IIF(op.ccusto_id = op.ccusto_promovido_id, 0, 1) as promocao_ccusto
            
        from tbl_orc_promocao as op

        left join tbl_orc_lotacao as ol on ol.id = op.lotacao_id and ol.orcamento_id = $orc_id
        left join tbl_orc_lotacao as ol_p on ol_p.id = op.lotacao_promovida_id and ol.orcamento_id = $orc_id
        left join tbl_lotacao as l on l.id = ol.lotacao_id
        left join tbl_lotacao as l_p on l_p.id = ol_p.lotacao_id
        
        left join tbl_ccusto as cc on cc.id = ol.cc_custo_id
        left join tbl_ccusto as cc_p on cc_p.id = ol_p.cc_custo_id

        

        left join tbl_orc_cargo as oc on oc.id = op.cargo_atual_id and oc.orcamento_id = $orc_id
        left join tbl_orc_cargo as oc_p on oc_p.id = op.cargo_promovido_id and oc.orcamento_id = $orc_id
        left join tbl_cargo as c on c.id = oc.cargo_id
        left join tbl_cargo as c_p on c_p.id = oc_p.cargo_id
        
        left join tbl_orc_turma as ot on ot.id = op.turma_atual_id and ot.orc_id = $orc_id
        left join tbl_orc_turma as ot_p on ot_p.id = op.turma_promovida_id and ot.orc_id = $orc_id
        left join tbl_turma as t on t.id = ot.turma_id
        left join tbl_turma as t_p on t_p.id = ot_p.turma_id
        
        inner join tbl_funcionario as func on func.id =op.funcionario_id
        

        where op.orc_id = $orc_id
        --and op.lotacao_id = $orc_lotacao_id
		        and op.lotacao_id in (select id from tbl_orc_lotacao ol_orc where tipo_table = 'O' and exists (select * from tbl_orc_lotacao ol_fcst where id = $orc_lotacao_id and ol_fcst.lotacao_id = ol_orc.lotacao_id and ol_fcst.cc_custo_id = ol_orc.cc_custo_id))

        and op.tipo_table = 'R'      
        ";

        

        if(!is_null($filtro) && $filtro == 1){
            $data = $data= 'select tbl_orc_promocao op
            WHERE MONTH(op.periodo) = $mes';
            }
       


        // if(!is_null($filtro) && $filtro == 1){
        //     $query = $query." AND MONTH(op.periodo) = {$mes}";
        // }
        $data = DB::select($query);

        $dados = [];
        $data = json_decode(json_encode($data), true);
		for($i = 0; $i < count($data); $i++){
          
			$dados[$i] = (array)$data[$i];
			$dados[$i]['total_count'] = count($data);
        }
        // dd("testeee",$dados);

		return $dados;
        
            // dd("query", DB::getQueryLog());
            // dd("pivooooo",$this->pivo($data));
        // return $data;
      }

}