<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioAumentoSalarial extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcSalarioFuncionario';
    protected $form_rules = [];
    protected $rules_msg = [];

	public function __construct(){
		$this->setTimeOut(700);
		parent::__construct();
	}
    public function listarRelatorioAumentoSalarial($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
		$tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

		$tipo_table = 'F';
		if($tipo_table != null && $periodo != null){
			return $this->listarAumentoSalarialForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';

        $select = DB::select("SELECT distinct
			sal.orc_cargo_id,
			sal.lotacao_id,
			sal.ccusto_id,
			concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
			concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario,
			sal.funcionario_id,
			sal.orc_turma_id, orcturma.turno_id,

			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jan,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_fev,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mar,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_abr,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mai,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jun,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jul,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_ago,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_set,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_out,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_nov,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_dez,


			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) janeiro,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) fevereiro,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) março,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) abril,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) maio,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) junho,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) julho,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) agosto,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) setembro,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) outubro,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) novembro,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) dezembro
		
			FROM tbl_orc_salario_funcionario as sal

			left join tbl_calc_orcamento as calc on sal.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_salario_funcionario'

			join tbl_orc_lotacao as orclot on sal.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
			join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
			join tbl_ccusto as cc on orclot.cc_custo_id = cc.id
			join tbl_funcionario as func on func.id = sal.funcionario_id

			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on sal.orc_id = hd.orc_id and sal.orc_cargo_id = hd.orc_cargo_id and sal.lotacao_id = hd.lotacao_id and sal.orc_turma_id = hd.orc_turma_id and sal.tipo = 1
			and hd.tipo_table = '{$tipo_table}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_orc_turma as orcturma on sal.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			join tbl_orc_cargo as orccargo on orccargo.id = sal.orc_cargo_id and orccargo.orcamento_id = {$orc_id}
			join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			where sal.orc_id = {$orc_id} and sal.tipo = 1 and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and sal.tipo_table = '{$tipo_table}'
		");
		
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}
	public function listarAumentoSalarialAnalitico($orc_id){
		set_time_limit($this->getTimeOut());
		$tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
		//$tipo_table = 'F';
		// if($tipo_table != null && $periodo != null){
		// 	return $this->listarAumentoSalarialForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		// }
		$tipo_table = 'O';

        $select = DB::select("SELECT distinct
			sal.orc_cargo_id,
			sal.lotacao_id,
			sal.ccusto_id,
			concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
			concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario,
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			--concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
			--sal.orc_turma_id, orcturma.turno_id,

			--SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jan,
			--SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_fev,
			--SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mar,
			--SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_abr,

			--SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mai,
			--SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jun,
			--SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jul,
			--SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_ago,

			--SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_set,
			--SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_out,
			--SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_nov,
			--SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_dez,


			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) janeiro,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) fevereiro,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) março,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) abril,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) maio,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) junho,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) julho,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) agosto,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) setembro,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) outubro,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) novembro,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.funcionario_id) dezembro
		
			FROM tbl_orc_salario_funcionario as sal

			left join tbl_calc_orcamento as calc on sal.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_salario_funcionario'

			join tbl_orc_lotacao as orclot on sal.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
			join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
			join tbl_ccusto as cc on orclot.cc_custo_id = cc.id

			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on sal.orc_id = hd.orc_id and sal.orc_cargo_id = hd.orc_cargo_id and sal.lotacao_id = hd.lotacao_id and sal.orc_turma_id = hd.orc_turma_id and sal.tipo = 1
			and hd.tipo_table = '{$tipo_table}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_orc_turma as orcturma on sal.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			join tbl_orc_cargo as orccargo on orccargo.id = sal.orc_cargo_id and orccargo.orcamento_id = {$orc_id}
			join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			join tbl_funcionario as func on func.id = sal.funcionario_id

			where sal.orc_id = {$orc_id} and sal.tipo = 1 and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and sal.tipo_table = '{$tipo_table}'
		");

		return $select;
	}
	public function listarAumentoSalarialForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
		set_time_limit($this->getTimeOut());
		$select = DB::select("SELECT distinct
		sal.orc_cargo_id,
		sal.lotacao_id,
		sal.ccusto_id,
		sal.periodo,
		concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
		concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
		concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
		concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
		concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario,
		sal.funcionario_id,
		sal.orc_turma_id, orcturma.turno_id,

		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jan,
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_fev,
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mar,
		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_abr,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_mai,
		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jun,
		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_jul,
		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_ago,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_set,
		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_out,
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_nov,
		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id) total_dez,


		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) janeiro,
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) fevereiro,
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) março,
		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) abril,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) maio,
		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) junho,
		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) julho,
		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) agosto,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) setembro,
		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) outubro,
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) novembro,
		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY sal.lotacao_id, sal.ccusto_id, sal.orc_cargo_id, sal.orc_turma_id, orcturma.turno_id, sal.funcionario_id) dezembro
	
		FROM tbl_orc_salario_funcionario as sal

		left join tbl_calc_orcamento as calc on sal.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_salario_funcionario'

		join tbl_orc_lotacao as orclot on sal.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
		join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
		join tbl_ccusto as cc on orclot.cc_custo_id = cc.id
		join tbl_funcionario as func on func.id = sal.funcionario_id

		/*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on sal.orc_id = hd.orc_id and sal.orc_cargo_id = hd.orc_cargo_id and sal.lotacao_id = hd.lotacao_id and sal.orc_turma_id = hd.orc_turma_id and sal.tipo = 1
		and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
		left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
		/**/

		left join tbl_orc_turma as orcturma on sal.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
		left join tbl_turno as turno on orcturma.turno_id = turno.id

		join tbl_orc_cargo as orccargo on orccargo.id = sal.orc_cargo_id and orccargo.orcamento_id = {$orc_id}
		join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

		where sal.orc_id = {$orc_id} and sal.tipo = 1 and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and sal.tipo_table = '{$tipo_table}' and sal.periodo = '{$periodo}'
		");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}
}