<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioContratacoes extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcContratacoes';
    protected $form_rules = [];
    protected $rules_msg = [];

	public function __construct(){
		$this->setTimeOut(700);
		parent::__construct();
	}
    public function listarRelatorioContratacao($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
		$tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

		if($tipo_table != null && $periodo != null){
			return $this->listarContratacoesForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';
        $select = DB::select("
		SELECT distinct
		concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
		concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
		concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,

		concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
		cont.orc_turma_id, orcturma.turno_id,

		cont.orc_cargo_id, cont.lotacao_id, cont.ccusto_id,

		--SUM( isnull(calc.jan_orcado ,0) ) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jan,
		
		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jan,
	
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_fev,
		
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_mar,

		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_abr,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_mai,

		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jun,

		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jul,

		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_ago,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_set,

		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_out,
		
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_nov,

		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_dez,

		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) janeiro,
	
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) fevereiro,
		
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) março,

		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) abril,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) maio,

		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) junho,

		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) julho,

		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) agosto,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) setembro,

		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) outubro,
		
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) novembro,

		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) dezembro

		FROM tbl_orc_headcount_contratacoes as cont
		
		left join tbl_calc_orcamento as calc on cont.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_headcount_contratacoes'
		left join tbl_orc_cargo as orccargo on cont.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
		left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

		/*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on cont.orcamento_id = hd.orc_id and cont.orc_cargo_id = hd.orc_cargo_id and cont.lotacao_id = hd.lotacao_id and cont.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}'
		left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
		/**/

		left join tbl_orc_turma as orcturma on cont.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
		left join tbl_turno as turno on orcturma.turno_id = turno.id

		left join tbl_orc_lotacao as orc_lot on cont.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
		left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
		left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

		WHERE cont.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and cont.tipo_table = '{$tipo_table}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
        }
		return $dados;
	}
	
	public function listarContratacoesForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
		set_time_limit($this->getTimeOut());
		$select = DB::select("
		SELECT distinct
		concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
		concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
		concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,

		concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
		cont.orc_turma_id, orcturma.turno_id,

		cont.orc_cargo_id, cont.lotacao_id, cont.ccusto_id, cont.periodo,

		--SUM( isnull(calc.jan_orcado ,0) ) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jan,
		
		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jan,
	
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_fev,
		
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_mar,

		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_abr,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_mai,

		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jun,

		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_jul,

		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_ago,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_set,

		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_out,
		
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_nov,

		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id) total_dez,

		SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) janeiro,
	
		SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) fevereiro,
		
		SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) março,

		SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) abril,

		SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) maio,

		SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) junho,

		SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) julho,

		SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) agosto,

		SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) setembro,

		SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) outubro,
		
		SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) novembro,

		SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY cont.lotacao_id, cont.ccusto_id, cont.orc_cargo_id, cont.orc_turma_id, orcturma.turno_id) dezembro

		FROM tbl_orc_headcount_contratacoes as cont
		
		left join tbl_calc_orcamento as calc on cont.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_headcount_contratacoes'
		left join tbl_orc_cargo as orccargo on cont.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
		left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

		/*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on cont.orcamento_id = hd.orc_id and cont.orc_cargo_id = hd.orc_cargo_id and cont.lotacao_id = hd.lotacao_id and cont.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
		left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
		/**/

		left join tbl_orc_turma as orcturma on cont.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
		left join tbl_turno as turno on orcturma.turno_id = turno.id

		left join tbl_orc_lotacao as orc_lot on cont.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
		left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
		left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

		WHERE cont.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and cont.periodo = '{$periodo}' and cont.tipo_table = '{$tipo_table}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
        }
		return $dados;
	}
}    