<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioDemissoes extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcHeadcountDemissoes';
    protected $form_rules = [];
	protected $rules_msg = [];
	
	public function __construct(){
		$this->setTimeOut(700);
		parent::__construct();
	}

    public function listarRelatorioDemissoes($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
		$tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

		if($tipo_table != null && $periodo != null){
			return $this->listarDemissoesForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';
        $select = DB::select("SELECT DISTINCT
		concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
		concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
		concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo, dem.tipo,

		concat(turno.cdn_turno_trab, ' - ', turno.des_turno_trab, ' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
		
		dem.orc_cargo_id, dem.ccusto_id, dem.lotacao_id, dem.orc_turma_id,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jan_orcado ,0) 
				WHEN (tipo = 2 and mes = 1) THEN 1
				WHEN (tipo = 3 and mes = 1) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jan,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.fev_orcado ,0) 
				WHEN (tipo = 2 and mes = 2) THEN 1
				WHEN (tipo = 3 and mes = 2) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_fev,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mar_orcado ,0) 
				WHEN (tipo = 2 and mes = 3) THEN 1
				WHEN (tipo = 3 and mes = 3) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_mar,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.abr_orcado ,0) 
				WHEN (tipo = 2 and mes = 4) THEN 1
				WHEN (tipo = 3 and mes = 4) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_abr,


		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mai_orcado ,0) 
				WHEN (tipo = 2 and mes = 5) THEN 1
				WHEN (tipo = 3 and mes = 5) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_mai,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jun_orcado ,0) 
				WHEN (tipo = 2 and mes = 6) THEN 1
				WHEN (tipo = 3 and mes = 6) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jun,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jul_orcado ,0) 
				WHEN (tipo = 2 and mes = 7) THEN 1
				WHEN (tipo = 3 and mes = 7) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jul,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.ago_orcado ,0) 
				WHEN (tipo = 2 and mes = 8) THEN 1
				WHEN (tipo = 3 and mes = 8) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_ago,


		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.set_orcado ,0) 
				WHEN (tipo = 2 and mes = 9) THEN 1
				WHEN (tipo = 3 and mes = 9) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_set,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.out_orcado ,0) 
				WHEN (tipo = 2 and mes = 10) THEN 1
				WHEN (tipo = 3 and mes = 10) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_out,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.nov_orcado ,0) 
				WHEN (tipo = 2 and mes = 11) THEN 1
				WHEN (tipo = 3 and mes = 11) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_nov,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.dez_orcado ,0) 
				WHEN (tipo = 2 and mes = 12) THEN 1
				WHEN (tipo = 3 and mes = 12) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_dez,

	/***/

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jan_orcado ,0) 
				WHEN (tipo = 2 and mes = 1) THEN 1
				WHEN (tipo = 3 and mes = 1) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) janeiro,
		
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.fev_orcado ,0) 
				WHEN (tipo = 2 and mes = 2) THEN 1
				WHEN (tipo = 3 and mes = 2) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) fevereiro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mar_orcado ,0) 
				WHEN (tipo = 2 and mes = 3) THEN 1
				WHEN (tipo = 3 and mes = 3) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) março,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.abr_orcado ,0) 
				WHEN (tipo = 2 and mes = 4) THEN 1
				WHEN (tipo = 3 and mes = 4) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) abril,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mai_orcado ,0) 
				WHEN (tipo = 2 and mes = 5) THEN 1
				WHEN (tipo = 3 and mes = 5) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) maio,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jun_orcado ,0) 
				WHEN (tipo = 2 and mes = 6) THEN 1
				WHEN (tipo = 3 and mes = 6) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) junho,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jul_orcado ,0) 
				WHEN (tipo = 2 and mes = 7) THEN 1
				WHEN (tipo = 3 and mes = 7) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) julho,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.ago_orcado ,0) 
				WHEN (tipo = 2 and mes = 8) THEN 1
				WHEN (tipo = 3 and mes = 8) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) agosto,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.set_orcado ,0) 
				WHEN (tipo = 2 and mes = 9) THEN 1
				WHEN (tipo = 3 and mes = 9) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) setembro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.out_orcado ,0) 
				WHEN (tipo = 2 and mes = 10) THEN 1
				WHEN (tipo = 3 and mes = 10) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) outubro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.nov_orcado ,0) 
				WHEN (tipo = 2 and mes = 11) THEN 1
				WHEN (tipo = 3 and mes = 11) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) novembro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.dez_orcado ,0) 
				WHEN (tipo = 2 and mes = 12) THEN 1
				WHEN (tipo = 3 and mes = 12) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) dezembro

		
		
		from tbl_orc_headcount_demissoes as dem
		left join tbl_calc_orcamento as calc on dem.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_headcount_demissoes'

		/*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on dem.orcamento_id = hd.orc_id and dem.orc_cargo_id = hd.orc_cargo_id and dem.lotacao_id = hd.lotacao_id and dem.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}'
		left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
		/**/

		left join tbl_orc_cargo as orccargo on dem.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
		left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

		left join tbl_orc_turma as orcturma on dem.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
		left join tbl_turno as turno on orcturma.turno_id = turno.id

		left join tbl_orc_lotacao as orc_lot on dem.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
		left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
		left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

		where dem.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and dem.tipo_table = '{$tipo_table}'
		");
		
		$dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}
	
	public function listarDemissoesForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
		set_time_limit($this->getTimeOut());
		$select = DB::select("SELECT DISTINCT
		concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
		concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
		concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo, dem.tipo,

		concat(turno.cdn_turno_trab, ' - ', turno.des_turno_trab, ' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
		
		dem.orc_cargo_id, dem.ccusto_id, dem.lotacao_id, dem.orc_turma_id, dem.periodo,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jan_orcado ,0) 
				WHEN (tipo = 2 and mes = 1) THEN 1
				WHEN (tipo = 3 and mes = 1) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jan,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.fev_orcado ,0) 
				WHEN (tipo = 2 and mes = 2) THEN 1
				WHEN (tipo = 3 and mes = 2) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_fev,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mar_orcado ,0) 
				WHEN (tipo = 2 and mes = 3) THEN 1
				WHEN (tipo = 3 and mes = 3) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_mar,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.abr_orcado ,0) 
				WHEN (tipo = 2 and mes = 4) THEN 1
				WHEN (tipo = 3 and mes = 4) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_abr,


		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mai_orcado ,0) 
				WHEN (tipo = 2 and mes = 5) THEN 1
				WHEN (tipo = 3 and mes = 5) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_mai,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jun_orcado ,0) 
				WHEN (tipo = 2 and mes = 6) THEN 1
				WHEN (tipo = 3 and mes = 6) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jun,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jul_orcado ,0) 
				WHEN (tipo = 2 and mes = 7) THEN 1
				WHEN (tipo = 3 and mes = 7) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_jul,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.ago_orcado ,0) 
				WHEN (tipo = 2 and mes = 8) THEN 1
				WHEN (tipo = 3 and mes = 8) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_ago,


		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.set_orcado ,0) 
				WHEN (tipo = 2 and mes = 9) THEN 1
				WHEN (tipo = 3 and mes = 9) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_set,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.out_orcado ,0) 
				WHEN (tipo = 2 and mes = 10) THEN 1
				WHEN (tipo = 3 and mes = 10) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_out,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.nov_orcado ,0) 
				WHEN (tipo = 2 and mes = 11) THEN 1
				WHEN (tipo = 3 and mes = 11) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_nov,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.dez_orcado ,0) 
				WHEN (tipo = 2 and mes = 12) THEN 1
				WHEN (tipo = 3 and mes = 12) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.lotacao_id, dem.ccusto_id) total_dez,

	/***/

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jan_orcado ,0) 
				WHEN (tipo = 2 and mes = 1) THEN 1
				WHEN (tipo = 3 and mes = 1) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) janeiro,
		
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.fev_orcado ,0) 
				WHEN (tipo = 2 and mes = 2) THEN 1
				WHEN (tipo = 3 and mes = 2) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) fevereiro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mar_orcado ,0) 
				WHEN (tipo = 2 and mes = 3) THEN 1
				WHEN (tipo = 3 and mes = 3) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) março,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.abr_orcado ,0) 
				WHEN (tipo = 2 and mes = 4) THEN 1
				WHEN (tipo = 3 and mes = 4) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) abril,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.mai_orcado ,0) 
				WHEN (tipo = 2 and mes = 5) THEN 1
				WHEN (tipo = 3 and mes = 5) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) maio,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jun_orcado ,0) 
				WHEN (tipo = 2 and mes = 6) THEN 1
				WHEN (tipo = 3 and mes = 6) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) junho,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.jul_orcado ,0) 
				WHEN (tipo = 2 and mes = 7) THEN 1
				WHEN (tipo = 3 and mes = 7) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) julho,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.ago_orcado ,0) 
				WHEN (tipo = 2 and mes = 8) THEN 1
				WHEN (tipo = 3 and mes = 8) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) agosto,

		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.set_orcado ,0) 
				WHEN (tipo = 2 and mes = 9) THEN 1
				WHEN (tipo = 3 and mes = 9) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) setembro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.out_orcado ,0) 
				WHEN (tipo = 2 and mes = 10) THEN 1
				WHEN (tipo = 3 and mes = 10) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) outubro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.nov_orcado ,0) 
				WHEN (tipo = 2 and mes = 11) THEN 1
				WHEN (tipo = 3 and mes = 11) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) novembro,
		SUM(
			CASE WHEN tipo = 1 THEN isnull(calc.dez_orcado ,0) 
				WHEN (tipo = 2 and mes = 12) THEN 1
				WHEN (tipo = 3 and mes = 12) THEN isnull(dem.qtde_pessoas,0) ELSE 0 END) OVER(PARTITION BY dem.orc_cargo_id, dem.lotacao_id, dem.ccusto_id, dem.orc_turma_id, orcturma.turno_id) dezembro

		
		
		from tbl_orc_headcount_demissoes as dem
		left join tbl_calc_orcamento as calc on dem.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_headcount_demissoes'

		/*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on dem.orcamento_id = hd.orc_id and dem.orc_cargo_id = hd.orc_cargo_id and dem.lotacao_id = hd.lotacao_id and dem.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
		left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
		/**/

		left join tbl_orc_cargo as orccargo on dem.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
		left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

		left join tbl_orc_turma as orcturma on dem.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
		left join tbl_turno as turno on orcturma.turno_id = turno.id

		left join tbl_orc_lotacao as orc_lot on dem.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
		left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
		left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

		where dem.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and dem.periodo = '{$periodo}' and dem.tipo_table = '{$tipo_table}'
		");
		
		$dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}


	public function listarRelatorioDemissoesIndividual($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
		$tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

		if($tipo_table != null && $periodo != null){
			return $this->listarDemissoesForecastIndividual($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';
        $select = DB::select("SELECT DISTINCT
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo, dem.tipo,

			concat(turno.cdn_turno_trab, ' - ', turno.des_turno_trab, ' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
			concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario, dem.func_id,
			CASE dem.mes
			WHEN 1 THEN 'Janeiro'
			WHEN 2 THEN 'Fevereiro'
			WHEN 3 THEN 'Março'
			WHEN 4 THEN 'Abril'
			WHEN 5 THEN 'Maio'
			WHEN 6 THEN 'Junho'
			WHEN 7 THEN 'Julho'
			WHEN 8 THEN 'Agosto'
			WHEN 9 THEN 'Setembro'
			WHEN 10 THEN 'Outubro'
			WHEN 11 THEN 'Novembro'
			WHEN 12 THEN 'Dezembro'
			ELSE ' - ' END as 'mes',
			
			CASE dem.acordo
			WHEN 1 THEN 'Sim'
			ELSE 'Não' END as 'acordo',
			dem.orc_cargo_id, dem.ccusto_id, dem.lotacao_id, dem.orc_turma_id		
			
			from tbl_orc_headcount_demissoes as dem
			
			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on dem.orcamento_id = hd.orc_id and dem.orc_cargo_id = hd.orc_cargo_id and dem.lotacao_id = hd.lotacao_id and dem.orc_turma_id = hd.orc_turma_id
			and hd.tipo_table = '{$tipo_table}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_orc_cargo as orccargo on dem.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
			left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			left join tbl_orc_turma as orcturma on dem.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			left join tbl_orc_lotacao as orc_lot on dem.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
			left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
			left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

			inner join tbl_funcionario as func on func.id = dem.func_id

			where dem.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and dem.tipo_table = '{$tipo_table}'
		");
		
		$dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}

	public function listarDemissoesForecastIndividual($orc_id, $tipo_table, $periodo, $lotacoes_string){
		$select = DB::select("SELECT DISTINCT
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo, dem.tipo,

			concat(turno.cdn_turno_trab, ' - ', turno.des_turno_trab, ' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
			concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario, dem.func_id,
			CASE dem.mes
			WHEN 1 THEN 'Janeiro'
			WHEN 2 THEN 'Fevereiro'
			WHEN 3 THEN 'Março'
			WHEN 4 THEN 'Abril'
			WHEN 5 THEN 'Maio'
			WHEN 6 THEN 'Junho'
			WHEN 7 THEN 'Julho'
			WHEN 8 THEN 'Agosto'
			WHEN 9 THEN 'Setembro'
			WHEN 10 THEN 'Outubro'
			WHEN 11 THEN 'Novembro'
			WHEN 12 THEN 'Dezembro'
			ELSE ' - ' END as 'mes',
			
			CASE dem.acordo
			WHEN 1 THEN 'Sim'
			ELSE 'Não' END as 'acordo',
			dem.orc_cargo_id, dem.ccusto_id, dem.lotacao_id, dem.orc_turma_id		
			
			from tbl_orc_headcount_demissoes as dem
			
			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on dem.orcamento_id = hd.orc_id and dem.orc_cargo_id = hd.orc_cargo_id and dem.lotacao_id = hd.lotacao_id and dem.orc_turma_id = hd.orc_turma_id
			and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_orc_cargo as orccargo on dem.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
			left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			left join tbl_orc_turma as orcturma on dem.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			left join tbl_orc_lotacao as orc_lot on dem.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
			left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
			left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id

			inner join tbl_funcionario as func on func.id = dem.func_id

			where dem.orcamento_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and dem.tipo_table = '{$tipo_table}' and dem.periodo = '{$periodo}'
		");
		
		$dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}
}
