<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioFerias extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcFerias';
    protected $form_rules = [];
    protected $rules_msg = [];

	public function __construct(){
		$this->setTimeOut(700);
		parent::__construct();
	}
    public function listarRelatorioFeriasTurma($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

		$tipo_table = 'F';
		
		if($tipo_table != null && $periodo != null){
			return $this->listarFeriasTurmaForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';

        $select = DB::select("
        SELECT fe.lotacao_id, fe.ccusto_id, fe.cargo_id, --- POR TURMA
	
        concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
        concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
        concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
        concat( turno.cdn_turno_trab,' - ',turno.des_turno_trab,' - ', orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab) as turma,
        fe.orc_turma_id,orcturma.turno_id,

            SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jan,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_fev,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mar,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_abr,

            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mai,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jun,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jul,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_ago,

            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_set,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_out,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_nov,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_dez,



            SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) janeiro,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) fevereiro,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) março,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) abril,

            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) maio,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) junho,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) julho,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) agosto,

            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) setembro,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) outubro,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) novembro,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) dezembro
        
        FROM tbl_orc_ferias as fe

        left join tbl_calc_orcamento as calc on fe.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_ferias'

        join tbl_orc_lotacao as orclot on fe.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
        join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
        join tbl_ccusto as cc on orclot.cc_custo_id = cc.id

        /*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on fe.orcamento_id = hd.orc_id and fe.cargo_id = hd.orc_cargo_id and fe.lotacao_id = hd.lotacao_id and fe.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}'
        left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
        /**/

        left join tbl_orc_turma as orcturma on fe.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
        left join tbl_turno as turno on orcturma.turno_id = turno.id

        join tbl_orc_cargo as orccargo on orccargo.id = fe.cargo_id and orccargo.orcamento_id = {$orc_id}
        join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

        where fe.orcamento_id = {$orc_id} and fe.type = 0 and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and fe.tipo_table = '{$tipo_table}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
    }
    public function listarRelatorioFeriasFuncionario($orc_id, $tipo_table, $periodo){
		set_time_limit($this->getTimeOut());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
		$lotacoes_string = implode(",",$lotacoes);
		$tipo_table = 'F';
		
		if($tipo_table != null && $periodo != null){
			return $this->listarFeriasFuncionarioForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
		}
		$tipo_table = 'O';
        $select = DB::select("
			SELECT distinct fe.lotacao_id, fe.ccusto_id, fe.cargo_id, --- POR FUNCIONARIO
		
			fe.id,
			concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			concat( func.cdn_funcionario,' - ',func.nome_funcionario) as funcionario,
			concat( turno.cdn_turno_trab,' - ',turno.des_turno_trab,' - ', orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab) as turma,
			fe.orc_turma_id,fe.func_id,

			COUNT(fe.id) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) qtd_func,
			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jan,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_fev,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mar,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_abr,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mai,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jun,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jul,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_ago,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_set,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_out,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_nov,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_dez,


			COUNT(*) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, orcturma.id) qtd_func_,
			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) janeiro,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) fevereiro,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) março,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) abril,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) maio,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) junho,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) julho,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) agosto,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) setembro,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) outubro,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) novembro,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) dezembro
		
			FROM tbl_orc_ferias as fe

			left join tbl_calc_orcamento as calc on fe.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_ferias'

			join tbl_orc_lotacao as orclot on fe.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
			join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
			join tbl_ccusto as cc on orclot.cc_custo_id = cc.id

			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on fe.orcamento_id = hd.orc_id and fe.cargo_id = hd.orc_cargo_id and fe.lotacao_id = hd.lotacao_id and fe.orc_turma_id = hd.orc_turma_id
			and hd.tipo_table = '{$tipo_table}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_funcionario as func on fe.func_id = func.id

			left join tbl_orc_turma as orcturma on fe.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			join tbl_orc_cargo as orccargo on orccargo.id = fe.cargo_id and orccargo.orcamento_id = {$orc_id}
			join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			where fe.orcamento_id = {$orc_id} and orclot.lotacao_id in ($lotacoes_string) and fe.type = 1 and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and fe.tipo_table = '{$tipo_table}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
			$dados[$i]['total_count'] = count($select);
		}
		return $dados;
	}
	public function listarFeriasTurmaForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
		set_time_limit($this->getTimeOut());
		$select = DB::select("
        SELECT fe.lotacao_id, fe.ccusto_id, fe.cargo_id, --- POR TURMA
	
        concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao, fe.periodo,
        concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
        concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
        concat( turno.cdn_turno_trab,' - ',turno.des_turno_trab,' - ', orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab) as turma,
        fe.orc_turma_id,orcturma.turno_id,

            SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jan,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_fev,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mar,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_abr,

            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mai,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jun,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jul,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_ago,

            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_set,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_out,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_nov,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_dez,



            SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) janeiro,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) fevereiro,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) março,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) abril,

            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) maio,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) junho,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) julho,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) agosto,

            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) setembro,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) outubro,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) novembro,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.orc_turma_id, orcturma.turno_id) dezembro
        
        FROM tbl_orc_ferias as fe

        left join tbl_calc_orcamento as calc on fe.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_ferias'

        join tbl_orc_lotacao as orclot on fe.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
        join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
        join tbl_ccusto as cc on orclot.cc_custo_id = cc.id

        /*validacao da distribuição*/
		left join tbl_orc_lot_carg_headcount as hd on fe.orcamento_id = hd.orc_id and fe.cargo_id = hd.orc_cargo_id and fe.lotacao_id = hd.lotacao_id and fe.orc_turma_id = hd.orc_turma_id
		and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
        left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
        /**/

        left join tbl_orc_turma as orcturma on fe.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
        left join tbl_turno as turno on orcturma.turno_id = turno.id

        join tbl_orc_cargo as orccargo on orccargo.id = fe.cargo_id and orccargo.orcamento_id = {$orc_id}
        join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

        where fe.orcamento_id = {$orc_id} and fe.type = 0 and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
		calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
		calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
		calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and fe.tipo_table = '{$tipo_table}' and fe.periodo = '{$periodo}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
	}
	public function listarFeriasFuncionarioForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
		set_time_limit($this->getTimeOut());
		$select = DB::select("
			SELECT distinct fe.lotacao_id, fe.ccusto_id, fe.cargo_id, --- POR FUNCIONARIO
		
			fe.id, fe.periodo,
			concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
			concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
			concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
			concat( func.cdn_funcionario,' - ',func.nome_funcionario) as funcionario,
			concat( turno.cdn_turno_trab,' - ',turno.des_turno_trab,' - ', orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab) as turma,
			fe.orc_turma_id,fe.func_id,

			COUNT(fe.id) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) qtd_func,
			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jan,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_fev,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mar,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_abr,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_mai,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jun,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_jul,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_ago,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_set,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_out,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_nov,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id) total_dez,


			COUNT(*) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, orcturma.id) qtd_func_,
			SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) janeiro,
			SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) fevereiro,
			SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) março,
			SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) abril,

			SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) maio,
			SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) junho,
			SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) julho,
			SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) agosto,

			SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) setembro,
			SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) outubro,
			SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) novembro,
			SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY fe.lotacao_id, fe.ccusto_id,fe.cargo_id, fe.func_id, orcturma.id) dezembro
		
			FROM tbl_orc_ferias as fe

			left join tbl_calc_orcamento as calc on fe.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_ferias'

			join tbl_orc_lotacao as orclot on fe.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
			join tbl_lotacao  as lot on orclot.lotacao_id = lot.id
			join tbl_ccusto as cc on orclot.cc_custo_id = cc.id

			/*validacao da distribuição*/
			left join tbl_orc_lot_carg_headcount as hd on fe.orcamento_id = hd.orc_id and fe.cargo_id = hd.orc_cargo_id and fe.lotacao_id = hd.lotacao_id and fe.orc_turma_id = hd.orc_turma_id
			and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
			left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
			/**/

			left join tbl_funcionario as func on fe.func_id = func.id

			left join tbl_orc_turma as orcturma on fe.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
			left join tbl_turno as turno on orcturma.turno_id = turno.id

			join tbl_orc_cargo as orccargo on orccargo.id = fe.cargo_id and orccargo.orcamento_id = {$orc_id}
			join tbl_cargo as cargo on orccargo.cargo_id = cargo.id

			where fe.orcamento_id = {$orc_id} and orclot.lotacao_id in ($lotacoes_string) and fe.type = 1 and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
			calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
			calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
			calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 ) and fe.tipo_table = '{$tipo_table}' and fe.periodo = '{$periodo}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
			$dados[$i]['total_count'] = count($select);
		}
		return $dados;
	}
}    