<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioHeadcount extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
    protected $form_rules = [];
    protected $rules_msg = [];

    // private $nome;

    // public function __construct($nome){
    //     $this->nome = $nome;
    // }

    public function listarRelatorioHeadcount($orc_id, $tipo_table, $periodo){

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        if($tipo_table != null && $periodo != null){
            return $this->listarHeadcountForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
        }
        $tipo_table = 'O';

        // dd($lotacoes_string);

        $user = $this->getUserFromCurrentGuard();

        $query = "SELECT
        concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
        par.valor_parametro,
        parja.valor_parametro,
        concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
        concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
        concat(orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) as turma,
        hd.orc_cargo_id,hd.lotacao_id, hd.ccusto_id, hd.orc_turma_id,
    
        /******** CIMA **********/
        --atual_total
        SUM(hd.qtd_func_lot) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) /*/ (COUNT(hd.orc_turma_id) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id))*/ total_realizado
    
        ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_Fsct_dez
        --,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_orcado_anterior
        ,(SELECT SUM(orc_ant) from (SELECT AVG(hc_orc_ant.orcado_anterior) orc_ant from tbl_orc_lot_carg_headcount hc_orc_ant where hc_orc_ant.lotacao_id = hd.lotacao_id and hc_orc_ant.ccusto_id = hd.ccusto_id and tipo_table = '$tipo_table' group by hc_orc_ant.orc_cargo_id) src) as total_orcado_anterior

        ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_headcount_dez_A
    
        ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jan,
        SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_fev,
        SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mar,
        SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_abr,
    
        SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mai,
        SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jun,
        SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jul,
        SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_ago,
    
        SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_set,
        SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_out,
        SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_nov,
        SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_dez
    
        ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_1
    
        --,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_2
        ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - (SELECT SUM(orc_ant) from (SELECT AVG(hc_orc_ant.orcado_anterior) orc_ant from tbl_orc_lot_carg_headcount hc_orc_ant where hc_orc_ant.lotacao_id = hd.lotacao_id and hc_orc_ant.ccusto_id = hd.ccusto_id and tipo_table = '{$tipo_table}' group by hc_orc_ant.orc_cargo_id) src) total_variacao_2
    
        /*PCD TOTAL*/
        ,isnull( (select 
            count(*) as pcd_tot
            from tbl_funcionario func
            where
            func.lotacao_id = lot.id and
            func.ccusto_id = cc.id and
            func.pne = 1 and
            dat_demis_func is null
            group by func.lotacao_id, func.ccusto_id
        ), 0) total_pcd
    
        /*PROJECAO TOTAL*/
        ,isnull( CASE WHEN cargo.cota_pcd = 1
            THEN 
            CEILING(((SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id)) -  
                    (select 
                        count(*) as pcd
                        from tbl_funcionario func
                        where
                        func.lotacao_id = orc_lot.lotacao_id and
                        func.ccusto_id = orc_lot.cc_custo_id and
                        pne = 1 and
                        dat_demis_func is null
                        group by func.lotacao_id, func.ccusto_id
                    ))
                        * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100))
                
            ELSE 0 END, 0) as total_projecao
    
        /*PROJECAO JA TOTAL*/
        ,CASE
            WHEN cargo.cota_jovem_aprendiz = 1
                THEN CEILING((SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id)) * (CAST(isnull(parja.valor_parametro,0) as decimal(18,5)) / 100))
            ELSE 0 END as total_projecao_jovem_aprendiz
    
        /******** BAIXO **********/
        /*qtd_func_lot*/
        ,SUM(isnull(hd.qtd_func_lot ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) realizado
        /*,(select count(*) from tbl_funcionario as f
            inner join tbl_orc_turma as t on t.turma_id = f.turma_id and t.orc_id = $orc_id
            inner join tbl_orc_cargo as c on c.cargo_id = f.cargo_id and c.orcamento_id = $orc_id
            inner join tbl_orc_lotacao as l on l.lotacao_id = f.lotacao_id and l.orcamento_id = $orc_id
            where t.id = hd.orc_turma_id and c.id = hd.orc_cargo_id and l.id = hd.lotacao_id
            ) as realizado*/
        --,SUM(isnull(hd.forecast_original ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) Fsct_out
        ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) Fsct_dez
        --,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) orcado_anterior
        ,'-' /*orcado_anterior/count(*)over(partition by hd.lotacao_id, hd.orc_cargo_id) 29/03/2021*/ as orcado_anterior
        ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) headcount_dez_A
        
        ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) janeiro,
        SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) fevereiro,
        SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) março,
        SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) abril,
    
        SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) maio,
        SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) junho,
        SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) julho,
        SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) agosto,
    
        SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) setembro,
        SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) outubro,
        SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) novembro,
        SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) dezembro,
    
        SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) variacao_1
    
        --,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) variacao_2
        
        ,'-'/*SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) - (orcado_anterior/count(*)over(partition by hd.lotacao_id, hd.orc_cargo_id)) 29/03/2021 */as variacao_2
        
        --,COUNT( CASE WHEN func.pne = 1 THEN 1 ELSE 0 END) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) as pcd
    
        /*PCD*/
        ,ISNULL((select 
                count(*) as pcd
                from tbl_funcionario funcb
                where orccargo.cargo_id = funcb.cargo_id and 
                funcb.lotacao_id = orc_lot.lotacao_id and 
                funcb.ccusto_id = orc_lot.cc_custo_id and 
                funcb.turma_id = orcturma.turma_id and 
                funcb.pne = 1 and
                dat_demis_func is null
                group by funcb.lotacao_id, funcb.ccusto_id, funcb.cargo_id, funcb.turma_id),0) as pcd
    
        /*PROJECAO*/
        ,CASE
            WHEN cargo.cota_pcd = 1
                THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) -  
                    ISNULL(
                        (select 
                            count(*) as pcd
                            from tbl_funcionario func 
                            where cargo.id = func.cargo_id and 
                            func.lotacao_id = orc_lot.lotacao_id and 
                            func.ccusto_id = orc_lot.cc_custo_id and 
                            func.turma_id = orcturma.turma_id and 
                            pne = 1 and
                            dat_demis_func is null
                            group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id)
                        ,0))
                    * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100) )
                ELSE 0 END as projecao
    
        /*PROJECAO JA*/
        ,CASE 
            WHEN cargo.cota_jovem_aprendiz = 1 
                THEN  (SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id)) * (CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100)
            ELSE 0 END AS projecao_jovem_aprendiz
        
        -- CASE 
        -- WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
        -- WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
        -- ELSE 'Orçado' END 'Tipo', '' as 'Gerado_por'
    
    
        FROM tbl_orc_lot_carg_headcount as hd
    
        left join tbl_calc_orcamento as calc on hd.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
        join tbl_orc_cargo as orccargo on hd.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
        join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
    
        join tblg_parametros as p on p.cod_parametro = 'CTPCD'
        join tbl_orc_parametros as par on hd.orc_id = par.orcamento_id and par.parametro_id = p.id

        join tbl_orc_parametros as parja on hd.orc_id = parja.orcamento_id
        join tblg_parametros as pja on parja.parametro_id = pja.id and pja.cod_parametro = 'CTJAP'
    
        left join tbl_orc_turma as orcturma on hd.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
        left join tbl_turno as turno on orcturma.turno_id = turno.id
    
        left join tbl_orc_lotacao as orc_lot on hd.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
        left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
        left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id
    
        --left join tbl_funcionario as func on cargo.id = func.cargo_id and func.lotacao_id = orc_lot.lotacao_id and func.ccusto_id = orc_lot.cc_custo_id and func.turma_id = orcturma.turma_id
    
        where hd.orc_id = {$orc_id} and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
            calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
            calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = '{$tipo_table}'";
        
        if($user->tipo != 3){
            $query = $query." and orc_lot.lotacao_id in ($lotacoes_string)";
        }    
        

        $select = DB::select($query);
    

                                                                                            
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
        }
		return $dados;
    }
    public function listarHeadcountForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
        $select = DB::select("SELECT
        concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
        par.valor_parametro,
        parja.valor_parametro,
        concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
        concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
        concat(orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) as turma,
        hd.orc_cargo_id,hd.lotacao_id, hd.ccusto_id, hd.orc_turma_id, hd.periodo,
    
        /******** CIMA **********/
        --atual_total
        --SUM(qtd_func_lot) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) /*/ (COUNT(hd.orc_turma_id) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id))*/ total_realizado
        (
            select  COUNT(*) from tbl_funcionario a
            where (dat_demis_func is null or dat_demis_func > EOMONTH(GETDATE()))-- CAST(CONCAT(YEAR(GETDATE()),'-',MONTH(GETDATE()),'-31') as date))
            and lotacao_id = lot.id
            and ccusto_id = cc.id
            ) total_realizado
            
        ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_Fsct_dez
        ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_orcado_anterior
        ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_headcount_dez_A
    
        ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jan,
        SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_fev,
        SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mar,
        SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_abr,
    
        SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mai,
        SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jun,
        SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jul,
        SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_ago,
    
        SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_set,
        SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_out,
        SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_nov,
        SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_dez
    
        ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_1
    
        ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_2
        --,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - (SELECT SUM(orc_ant) from (SELECT AVG(hc_orc_ant.orcado_anterior) orc_ant from tbl_orc_lot_carg_headcount hc_orc_ant where hc_orc_ant.lotacao_id = hd.lotacao_id and hc_orc_ant.ccusto_id = hd.ccusto_id and tipo_table = '{$tipo_table}' group by hc_orc_ant.orc_cargo_id) src) total_variacao_2
    
        /*PCD TOTAL*/
        ,isnull( (select 
            count(*) as pcd
            from tbl_funcionario func
            where
            func.lotacao_id = orc_lot.lotacao_id and
            func.ccusto_id = orc_lot.cc_custo_id and
            pne = 1 and
            dat_demis_func is null
            group by func.lotacao_id, func.ccusto_id
        ), 0) total_pcd
    
        /*PROJECAO TOTAL*/
        ,isnull( CASE WHEN cargo.cota_pcd = 1
            THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) -  
                (select 
                    count(*) as pcd
                    from tbl_funcionario func
                    where
                    func.lotacao_id = orc_lot.lotacao_id and
                    func.ccusto_id = orc_lot.cc_custo_id and
                    pne = 1 and
                    dat_demis_func is null
                    group by func.lotacao_id, func.ccusto_id
                )) 
                * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100)) 
            ELSE 0 END, 0) as total_projecao
    
        /*PROJECAO JA TOTAL*/
        ,CASE
            WHEN cargo.cota_jovem_aprendiz = 1
                THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
            ELSE 0 END as total_projecao_jovem_aprendiz
    
        /******** BAIXO **********/
        /*qtd_func_lot*/
        ,SUM(isnull(hd.qtd_func_lot ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) realizado
        /*,(select count(*) from tbl_funcionario as f
            inner join tbl_orc_turma as t on t.turma_id = f.turma_id and t.orc_id = $orc_id
            inner join tbl_orc_cargo as c on c.cargo_id = f.cargo_id and c.orcamento_id = $orc_id
            inner join tbl_orc_lotacao as l on l.lotacao_id = f.lotacao_id and l.orcamento_id = $orc_id
            where t.id = hd.orc_turma_id and c.id = hd.orc_cargo_id and l.id = hd.lotacao_id
            ) as realizado*/
        --,SUM(isnull(hd.forecast_original ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) Fsct_out
        ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) Fsct_dez
        ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) orcado_anterior
        ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) headcount_dez_A
        
        ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) janeiro,
        SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) fevereiro,
        SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) março,
        SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) abril,
    
        SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) maio,
        SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) junho,
        SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) julho,
        SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) agosto,
    
        SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) setembro,
        SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) outubro,
        SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) novembro,
        SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) dezembro,
    
        SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) variacao_1
    
        ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) variacao_2
    
        --,COUNT( CASE WHEN func.pne = 1 THEN 1 ELSE 0 END) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) as pcd
    
        /*PCD*/
        ,ISNULL((select 
                count(*) as pcd
                from tbl_funcionario func 
                where cargo.id = func.cargo_id and 
                func.lotacao_id = orc_lot.lotacao_id and 
                func.ccusto_id = orc_lot.cc_custo_id and 
                func.turma_id = orcturma.turma_id and 
                pne = 1 and
                dat_demis_func is null
                group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id),0) as pcd
    
        /*PROJECAO*/
        ,CASE
            WHEN cargo.cota_pcd = 1
                THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) -  
                    ISNULL(
                        (select 
                            count(*) as pcd
                            from tbl_funcionario func 
                            where cargo.id = func.cargo_id and 
                            func.lotacao_id = orc_lot.lotacao_id and 
                            func.ccusto_id = orc_lot.cc_custo_id and 
                            func.turma_id = orcturma.turma_id and 
                            pne = 1 and
                            dat_demis_func is null
                            group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id)
                        ,0))
                    * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100) )
                ELSE 0 END as projecao
    
        /*PROJECAO JA*/
        ,CASE 
            WHEN cargo.cota_jovem_aprendiz = 1 
                THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id, hd.orc_turma_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
            ELSE 0 END AS projecao_jovem_aprendiz
        -- CASE 
        -- WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
        -- WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
        -- ELSE 'Orçado' END 'Tipo', '' as 'Gerado_por'
    
    
        FROM tbl_orc_lot_carg_headcount as hd
    
        left join tbl_calc_orcamento as calc on hd.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
        join tbl_orc_cargo as orccargo on hd.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
        join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
    
        join tblg_parametros as p on p.cod_parametro = 'CTPCD'
        join tbl_orc_parametros as par on hd.orc_id = par.orcamento_id and par.parametro_id = p.id

        join tbl_orc_parametros as parja on hd.orc_id = parja.orcamento_id
        join tblg_parametros as pja on parja.parametro_id = pja.id and pja.cod_parametro = 'CTJAP'
    
        left join tbl_orc_turma as orcturma on hd.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
        left join tbl_turno as turno on orcturma.turno_id = turno.id
    
        left join tbl_orc_lotacao as orc_lot on hd.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
        left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
        left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id
    
        --left join tbl_funcionario as func on cargo.id = func.cargo_id and func.lotacao_id = orc_lot.lotacao_id and func.ccusto_id = orc_lot.cc_custo_id and func.turma_id = orcturma.turma_id
    
        where hd.orc_id = {$orc_id} and orc_lot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
            calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
            calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
        ");

                                                                                            
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
        }
		return $dados;
    }
    public function listarRelatorioHeadcountSintetico($orc_id, $tipo_table, $periodo){

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        
        if($tipo_table != null && $periodo != null){
            return $this->listarRelatorioHeadcountSinteticoForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
        }
        $tipo_table = 'O';

        $user = $this->getUserFromCurrentGuard();

        $query="SELECT
            concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
            par.valor_parametro,
            parja.valor_parametro,
            concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
            concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
            concat(orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) as turma,
            hd.orc_cargo_id,hd.lotacao_id, hd.ccusto_id, hd.orc_turma_id,
        
            /******** CIMA **********/
            --atual_total
            SUM(hd.qtd_func_lot) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) /*/ (COUNT(hd.orc_turma_id) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id))*/ total_realizado
        
            ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_Fsct_dez
            ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_orcado_anterior
            ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_headcount_dez_A
        
            ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jan,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_fev,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mar,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_abr,
        
            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mai,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jun,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jul,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_ago,
        
            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_set,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_out,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_nov,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_dez
        
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_1
        
            --,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_2
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - (SELECT SUM(orc_ant) from (SELECT AVG(hc_orc_ant.orcado_anterior) orc_ant from tbl_orc_lot_carg_headcount hc_orc_ant where hc_orc_ant.lotacao_id = hd.lotacao_id and hc_orc_ant.ccusto_id = hd.ccusto_id and tipo_table = '{$tipo_table}' group by hc_orc_ant.orc_cargo_id) src) total_variacao_2
            /*PCD TOTAL*/
            ,isnull( (select 
                count(*) as pcd
                from tbl_funcionario func
                where
                func.lotacao_id = lot.id and
                func.ccusto_id = cc.id and
                func.pne = 1 and
                dat_demis_func is null
                group by func.lotacao_id, func.ccusto_id
            ), 0) total_pcd
        
            /*PROJECAO TOTAL*/
            ,isnull( CASE WHEN cargo.cota_pcd = 1
                THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) -  
                    (select 
                        count(*) as pcd
                        from tbl_funcionario func
                        where
                        func.lotacao_id = orc_lot.lotacao_id and
                        func.ccusto_id = orc_lot.cc_custo_id and
                        pne = 1 and
                        dat_demis_func is null
                        group by func.lotacao_id, func.ccusto_id
                    )) 
                    * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100)) 
                ELSE 0 END, 0) as total_projecao
        
            /*PROJECAO JA TOTAL*/
            ,CASE
                WHEN cargo.cota_jovem_aprendiz = 1
                    THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
                ELSE 0 END as total_projecao_jovem_aprendiz
        
            /******** BAIXO **********/
        
            ,SUM(isnull(hd.qtd_func_lot ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) realizado
            
            ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) Fsct_dez
            ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) orcado_anterior
            ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) headcount_dez_A
            
            ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) janeiro,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) fevereiro,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) março,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) abril,
        
            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) maio,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) junho,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) julho,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) agosto,
        
            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) setembro,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) outubro,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) novembro,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) dezembro,
        
            SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) variacao_1
        
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) variacao_2
        
            
        
            /*PCD*/
            ,ISNULL((select 
                    count(*) as pcd
                    from tbl_funcionario funcb 
                    where orccargo.cargo_id = funcb.cargo_id and 
                    funcb.lotacao_id = orc_lot.lotacao_id and 
                    funcb.ccusto_id = orc_lot.cc_custo_id and 
                    funcb.turma_id = orcturma.turma_id and 
                    funcb.pne = 1 and
                    dat_demis_func is null
                    group by funcb.lotacao_id, funcb.ccusto_id, funcb.cargo_id, funcb.turma_id),0) as pcd
        
            /*PROJECAO*/
            ,CASE
                WHEN cargo.cota_pcd = 1
                    THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) -  
                        ISNULL(
                            (select 
                                count(*) as pcd
                                from tbl_funcionario func 
                                where cargo.id = func.cargo_id and 
                                func.lotacao_id = orc_lot.lotacao_id and 
                                func.ccusto_id = orc_lot.cc_custo_id and 
                                func.turma_id = orcturma.turma_id and 
                                pne = 1 and
                                dat_demis_func is null
                                group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id)
                            ,0))
                        * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100) )
                    ELSE 0 END as projecao
        
            /*PROJECAO JA*/
            ,CASE 
                WHEN cargo.cota_jovem_aprendiz = 1 
                    THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
                ELSE 0 END AS projecao_jovem_aprendiz
            -- CASE 
            -- WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
            -- WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
            -- ELSE 'Orçado' END 'Tipo', '' as 'Gerado_por'
        
        
            FROM tbl_orc_lot_carg_headcount as hd
        
            left join tbl_calc_orcamento as calc on hd.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
            join tbl_orc_cargo as orccargo on hd.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
        
            join tblg_parametros as p on p.cod_parametro = 'CTPCD'
            join tbl_orc_parametros as par on hd.orc_id = par.orcamento_id and par.parametro_id = p.id

            join tbl_orc_parametros as parja on hd.orc_id = parja.orcamento_id
            join tblg_parametros as pja on parja.parametro_id = pja.id and pja.cod_parametro = 'CTJAP'
        
            left join tbl_orc_turma as orcturma on hd.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
            left join tbl_turno as turno on orcturma.turno_id = turno.id
        
            left join tbl_orc_lotacao as orc_lot on hd.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
            left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
            left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id
        
        
            where hd.orc_id = {$orc_id} and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
            calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
            calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = '{$tipo_table}'";
        
        if($user->tipo != 3){
            $query = $query." and orc_lot.lotacao_id in ($lotacoes_string)";
        }    
        

        $select = DB::select($query);

        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
    }

    public function listarRelatorioHeadcountSinteticoForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){

        $user = $this->getUserFromCurrentGuard();
        
        $where_lotacoes = $user->tipo == 3 ? "" : "and orc_lot.lotacao_id in ($lotacoes_string)";

        $select = DB::select("SELECT
            concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
            par.valor_parametro,
            parja.valor_parametro,
            concat(lot.unid_lotac,' - ',lot.des_unid_lotac) as lotacao,
            concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
            concat(orcturma.cdn_turma_trab,' - ',orcturma.des_turma_trab, ' - ', turno.cdn_turno_trab, ' - ', turno.des_turno_trab) as turma,
            hd.orc_cargo_id,hd.lotacao_id, hd.ccusto_id, hd.orc_turma_id,
        
            /******** CIMA **********/
            --atual_total
            SUM(hd.qtd_func_lot) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) /*/ (COUNT(hd.orc_turma_id) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id))*/ total_realizado
        
            ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_Fsct_dez
            ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_orcado_anterior
            ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_headcount_dez_A
        
            ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jan,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_fev,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mar,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_abr,
        
            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_mai,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jun,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_jul,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_ago,
        
            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_set,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_out,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_nov,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_dez
        
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_1
        
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) total_variacao_2
            --,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) - (SELECT SUM(orc_ant) from (SELECT AVG(hc_orc_ant.orcado_anterior) orc_ant from tbl_orc_lot_carg_headcount hc_orc_ant where hc_orc_ant.lotacao_id = hd.lotacao_id and hc_orc_ant.ccusto_id = hd.ccusto_id and tipo_table = '{$tipo_table}' group by hc_orc_ant.orc_cargo_id) src) total_variacao_2
            /*PCD TOTAL*/
            ,isnull( (select 
                count(*) as pcd
                from tbl_funcionario func
                where
                func.lotacao_id = orc_lot.lotacao_id and
                func.ccusto_id = orc_lot.cc_custo_id and
                pne = 1 and
                dat_demis_func is null
                group by func.lotacao_id, func.ccusto_id
            ), 0) total_pcd
        
            /*PROJECAO TOTAL*/
            ,isnull( CASE WHEN cargo.cota_pcd = 1
                THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) -  
                    (select 
                        count(*) as pcd
                        from tbl_funcionario func
                        where
                        func.lotacao_id = orc_lot.lotacao_id and
                        func.ccusto_id = orc_lot.cc_custo_id and
                        pne = 1 and
                        dat_demis_func is null
                        group by func.lotacao_id, func.ccusto_id
                    )) 
                    * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100)) 
                ELSE 0 END, 0) as total_projecao
        
            /*PROJECAO JA TOTAL*/
            ,CASE
                WHEN cargo.cota_jovem_aprendiz = 1
                    THEN CEILING( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
                ELSE 0 END as total_projecao_jovem_aprendiz
        
            /******** BAIXO **********/
        
            ,SUM(isnull(hd.qtd_func_lot ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) realizado
            
            ,SUM(isnull(hd.forecast_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) Fsct_dez
            ,SUM(isnull(hd.orcado_anterior ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) orcado_anterior
            ,SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) headcount_dez_A
            
            ,SUM(isnull(calc.jan_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) janeiro,
            SUM(isnull(calc.fev_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) fevereiro,
            SUM(isnull(calc.mar_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) março,
            SUM(isnull(calc.abr_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) abril,
        
            SUM(isnull(calc.mai_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) maio,
            SUM(isnull(calc.jun_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) junho,
            SUM(isnull(calc.jul_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) julho,
            SUM(isnull(calc.ago_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) agosto,
        
            SUM(isnull(calc.set_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) setembro,
            SUM(isnull(calc.out_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) outubro,
            SUM(isnull(calc.nov_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) novembro,
            SUM(isnull(calc.dez_orcado ,0)) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) dezembro,
        
            SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) - SUM( isnull(hd.forecast_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) variacao_1
        
            ,SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) - SUM( isnull(hd.orcado_anterior ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) variacao_2
        
            
        
            /*PCD*/
            ,ISNULL((select 
                    count(*) as pcd
                    from tbl_funcionario func 
                    where cargo.id = func.cargo_id and 
                    func.lotacao_id = orc_lot.lotacao_id and 
                    func.ccusto_id = orc_lot.cc_custo_id and 
                    func.turma_id = orcturma.turma_id and 
                    pne = 1 and
                    dat_demis_func is null
                    group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id),0) as pcd
        
            /*PROJECAO*/
            ,CASE
                WHEN cargo.cota_pcd = 1
                    THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) -  
                        ISNULL(
                            (select 
                                count(*) as pcd
                                from tbl_funcionario func 
                                where cargo.id = func.cargo_id and 
                                func.lotacao_id = orc_lot.lotacao_id and 
                                func.ccusto_id = orc_lot.cc_custo_id and 
                                func.turma_id = orcturma.turma_id and 
                                pne = 1 and
                                dat_demis_func is null
                                group by func.lotacao_id, func.ccusto_id, func.cargo_id, func.turma_id)
                            ,0))
                        * (CAST(isnull(par.valor_parametro,0) as decimal(18,5))/100) )
                    ELSE 0 END as projecao
        
            /*PROJECAO JA*/
            ,CASE 
                WHEN cargo.cota_jovem_aprendiz = 1 
                    THEN ( (SUM( isnull(calc.dez_orcado ,0) ) OVER(PARTITION BY hd.lotacao_id, hd.ccusto_id, hd.orc_cargo_id) ) * ( CAST(isnull(parja.valor_parametro,0) as decimal(18,5))/100) ) 
                ELSE 0 END AS projecao_jovem_aprendiz
            -- CASE 
            -- WHEN '{$tipo_table}' = 'F' THEN 'Forecast'
            -- WHEN '{$tipo_table}' = 'R' THEN 'Realizado'
            -- ELSE 'Orçado' END 'Tipo', '' as 'Gerado_por'
        
        
            FROM tbl_orc_lot_carg_headcount as hd
        
            left join tbl_calc_orcamento as calc on hd.id = calc.origem_id and calc.tbl_origem = 'tbl_orc_lot_carg_headcount'
            join tbl_orc_cargo as orccargo on hd.orc_cargo_id = orccargo.id and orccargo.orcamento_id = {$orc_id}
            join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
        
            join tblg_parametros as p on p.cod_parametro = 'CTPCD'
            join tbl_orc_parametros as par on hd.orc_id = par.orcamento_id and par.parametro_id = p.id

            join tbl_orc_parametros as parja on hd.orc_id = parja.orcamento_id
            join tblg_parametros as pja on parja.parametro_id = pja.id and pja.cod_parametro = 'CTJAP'
        
            left join tbl_orc_turma as orcturma on hd.orc_turma_id = orcturma.id and orcturma.orc_id = {$orc_id}
            left join tbl_turno as turno on orcturma.turno_id = turno.id
        
            left join tbl_orc_lotacao as orc_lot on hd.lotacao_id = orc_lot.id and orc_lot.orcamento_id = {$orc_id}
            left join tbl_lotacao as lot on orc_lot.lotacao_id = lot.id
            left join tbl_ccusto as cc on orc_lot.cc_custo_id = cc.id
        
        
            where hd.orc_id = {$orc_id} {$where_lotacoes} and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc.jan_orcado != 0 or calc.fev_orcado != 0 or calc.mar_orcado != 0 or calc.abr_orcado != 0 or
            calc.mai_orcado != 0 or calc.jun_orcado != 0 or calc.jul_orcado != 0 or calc.ago_orcado != 0 or
            calc.set_orcado != 0 or calc.out_orcado != 0 or calc.nov_orcado != 0 or calc.dez_orcado != 0 )) and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
        ");

        
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
    }
}