<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB;

class RepoRelatorioPCDJA extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
    protected $form_rules = [];
    protected $rules_msg = [];

    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();
    }
    public function listarPCDRelatorio($orc_id, $tipo_table, $periodo, $nivel_hier, $tipo){
        set_time_limit($this->getTimeOut());
        $select_cota = DB::select("SELECT * from tblg_parametros where cod_parametro = 'CTPCD'");
        if(count($select_cota) == 0){
            return false;
        }

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $cota = $select_cota[0]->valor_default/100;

        $concatena_periodo = $periodo == "null" ? "" : " and hc.periodo = '{$periodo}' ";
        // $this->montaSQLPCD($cota, $nivel_hier, $orc_id, $tipo_table, $lotacoes_string, $concatena_periodo, $tipo);
        // $select = DB::select("SELECT 
        //     LEFT(l.unid_lotac, 2) as 'unidade_lotacao', 

        //     (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2)) as atual,
            
        //     (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'jan',
        //     (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'fev',
        //     (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'mar',
        //     (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'abr',
        //     (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'mai',
        //     (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'jun',
        //     (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'jul',
        //     (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'ago',
        //     (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'set',
        //     (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'out',
        //     (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'nov',
        //     (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'dez',

        //     (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jan',

        //     (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_fev',
            
        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_mar',

        //     (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_abr',

        //     (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_mai',

        //     (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jun',

        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jul',

        //     (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_ago',

        //     (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_set',

        //     (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_out',

        //     (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_nov',

        //     (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_dez'
            
        //     from tbl_orc_lot_carg_headcount as hc
        //     join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
        //     join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
        //     join tbl_lotacao l on l.id = ol.lotacao_id
            
        //     -- join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
        //     -- join tbl_cargo as c on c.id = oc.cargo_id
        //     -- join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func.pne = 1
            
        //     -- left join tblg_parametros as par on cod_parametro like('%CTPCD%')
            
        //     where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
        //     group by LEFT(l.unid_lotac, 2)

        // UNION

        // select 
        //     LEFT(l.unid_lotac, 4) as 'unidade_lotacao', 

        //     (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4)) as atual,
            
        //     (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'jan',
        //     (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'fev',
        //     (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'mar',
        //     (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'abr',
        //     (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'mai',
        //     (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'jun',
        //     (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'jul',
        //     (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'ago',
        //     (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'set',
        //     (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'out',
        //     (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'nov',
        //     (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'dez',

        //     (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jan',

        //     (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_fev',
            
        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_mar',

        //     (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_abr',

        //     (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_mai',

        //     (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jun',

        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jul',

        //     (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_ago',

        //     (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_set',

        //     (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_out',

        //     (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_nov',

        //     (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_dez'
            
        //     from tbl_orc_lot_carg_headcount as hc
        //     join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
        //     join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
        //     join tbl_lotacao l on l.id = ol.lotacao_id
            
        //     -- join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
        //     -- join tbl_cargo as c on c.id = oc.cargo_id
        //     -- join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func.pne = 1
            
        //     -- left join tblg_parametros as par on cod_parametro like('%CTPCD%')
            
        //     where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
        //     group by LEFT(l.unid_lotac, 4)

        // UNION

        // select 
        //     LEFT(l.unid_lotac, 6) as 'unidade_lotacao', 

        //     (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6)) as atual,
            
        //     (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'cota_jan',
        //     (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'cota_fev',
        //     (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'cota_mar',
        //     (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'cota_abr',
        //     (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'cota_mai',
        //     (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'cota_jun',
        //     (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'cota_jul',
        //     (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'cota_ago',
        //     (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'cota_set',
        //     (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'cota_out',
        //     (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'cota_nov',
        //     (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'cota_dez',

        //     (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jan',

        //     (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_fev',
            
        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_mar',

        //     (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_abr',

        //     (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_mai',

        //     (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jun',

        //     (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jul',

        //     (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_ago',

        //     (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_set',

        //     (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_out',

        //     (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_nov',

        //     (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
        //     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
        //     where pne = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_dez'
            
        //     from tbl_orc_lot_carg_headcount as hc
        //     join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
        //     join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
        //     join tbl_lotacao l on l.id = ol.lotacao_id
            
        //     -- join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
        //     -- join tbl_cargo as c on c.id = oc.cargo_id
        //     -- join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func.pne = 1
            
        //     -- left join tblg_parametros as par on cod_parametro like('%CTPCD%')
            
        //     where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
        //     group by LEFT(l.unid_lotac, 6)
        // ");

        $select = DB::select($this->montaSQLPCD($cota, $nivel_hier, $orc_id, $tipo_table, $lotacoes_string, $concatena_periodo, $tipo));
        return $select;
    }

    public function listarJARelatorio($orc_id, $tipo_table, $periodo, $nivel_hier, $tipo){
        set_time_limit($this->getTimeOut());
        $select_cota = DB::select("SELECT * from tblg_parametros where cod_parametro = 'CTJAP'");
        if(count($select_cota) == 0){
            return false;
        }

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        $cota = $select_cota[0]->valor_default/100;

        $concatena_periodo = $periodo == "null" ? "" : " and hc.periodo = '{$periodo}' ";

        /*$select = DB::select("SELECT 
            LEFT(l.unid_lotac, 2) as 'unidade_lotacao', 

            (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            join tbl_cargo as c on c.id = funcionario.cargo_id
            where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2)) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'ago',
            (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'set',
            (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'out',
            (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_set',

            (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 2) = LEFT(l.unid_lotac, 2))) as 'diferenca_dez'
            
            from tbl_orc_lot_carg_headcount as hc
            join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            
            join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
            --join tbl_cargo as c on c.id = oc.cargo_id and c.cota_jovem_aprendiz = 1
            --join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func. = 1
            
            --left join tblg_parametros as par on cod_parametro like('%CTJAP%')
            
            where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
            group by LEFT(l.unid_lotac, 2)

        UNION

        SELECT 
            LEFT(l.unid_lotac, 4) as 'unidade_lotacao', 

            (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            join tbl_cargo as c on c.id = funcionario.cargo_id
            where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4)) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'ago',
            (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'set',
            (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'out',
            (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_set',

            (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 4) = LEFT(l.unid_lotac, 4))) as 'diferenca_dez'
            
            from tbl_orc_lot_carg_headcount as hc
            join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            
            join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
            --join tbl_cargo as c on c.id = oc.cargo_id and c.cota_jovem_aprendiz = 1
            --join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func. = 1
            
            --left join tblg_parametros as par on cod_parametro like('%CTJAP%')
            
            where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
            group by LEFT(l.unid_lotac, 4)

        UNION

    SELECT 
            LEFT(l.unid_lotac, 6) as 'unidade_lotacao', 

            (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            join tbl_cargo as c on c.id = funcionario.cargo_id
            where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6)) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0)) * {$cota}) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0)) * {$cota}) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0)) * {$cota}) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0)) * {$cota}) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0)) * {$cota}) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0)) * {$cota}) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0)) * {$cota}) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0)) * {$cota}) as 'ago',
            (SUM(ISNULL(co.set_orcado,0)) * {$cota}) as 'set',
            (SUM(ISNULL(co.out_orcado,0)) * {$cota}) as 'out',
            (SUM(ISNULL(co.nov_orcado,0)) * {$cota}) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0)) * {$cota}) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_set',

            (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and LEFT(lot.unid_lotac, 6) = LEFT(l.unid_lotac, 6))) as 'diferenca_dez'
            
            from tbl_orc_lot_carg_headcount as hc
            join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            
            join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
            --join tbl_cargo as c on c.id = oc.cargo_id and c.cota_jovem_aprendiz = 1
            --join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func. = 1
            
            --left join tblg_parametros as par on cod_parametro like('%CTJAP%')
            
            where hc.orc_id = {$orc_id} and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
            
            group by LEFT(l.unid_lotac, 6)
        ");*/

        $select = DB::select($this->montaSQLJA($cota, $nivel_hier, $orc_id, $tipo_table, $lotacoes_string, $concatena_periodo, $tipo));
        return $select;
    }

    private function montaSQLPCD($cota, $nivel, $orc_id, $tipo_table, $lotacoes_string, $concatena_periodo, $tipo){
        $qtd = $nivel + 2;
        $sql = "";
        while($qtd <= 8){
            $union = strlen($sql) > 0 ? " UNION " : "";
            $qtd_zeros = '';
            $i = 8-$qtd;
            while($i > 0){
                $qtd_zeros = $qtd_zeros.'0';
                $i--; 
            }
            
            $sql = $sql.$union."SELECT 
            distinct
            LEFT(l.unid_lotac, $qtd) as 'unidade_lotacao_cod', 
            concat((select top 1 LEFT(lot.des_unid_lotac, CHARINDEX('-', lot.des_unid_lotac)) from tbl_lotacao as lot where lot.unid_lotac = LEFT(l.unid_lotac, $qtd)+'{$qtd_zeros}' ), ' ', LEFT(l.unid_lotac, $qtd)) as 'unidade_lotacao',

            (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd)) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'ago',
            (SUM(ISNULL(co.set_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'set',
            (SUM(ISNULL(co.out_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'out',
            (SUM(ISNULL(co.nov_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) ) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_set',

             (-SUM(ISNULL(co.out_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            where pne = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_dez'
                
                from tbl_orc_lot_carg_headcount as hc
                join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
                join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
                join tbl_lotacao l on l.id = ol.lotacao_id
                
                join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
                join tbl_cargo as c on c.id = oc.cargo_id
                -- join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func.pne = 1
                
                -- left join tblg_parametros as par on cod_parametro like('%CTPCD%')
                
                where hc.orc_id = {$orc_id} and c.cota_pcd = 1 and c.ativo = 1 and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
                and RIGHT(LEFT(l.unid_lotac, $qtd), 2) <> '00'
                --group by LEFT(l.unid_lotac, $qtd)
            ";
            $qtd = $qtd + 2;
        }
        
        if($tipo != 3){
            return $sql;
        }
        $sql = $sql." UNION SELECT 
                '999999999999' as 'unidade_lotacao_cod',
                'MRN' as 'unidade_lotacao', 
                
                (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null) as atual,
                
                (SUM(ISNULL(co.jan_orcado,0) * {$cota})) as 'jan',
                (SUM(ISNULL(co.fev_orcado,0) * {$cota})) as 'fev',
                (SUM(ISNULL(co.mar_orcado,0) * {$cota})) as 'mar',
                (SUM(ISNULL(co.abr_orcado,0) * {$cota})) as 'abr',
                (SUM(ISNULL(co.mai_orcado,0) * {$cota})) as 'mai',
                (SUM(ISNULL(co.jun_orcado,0) * {$cota})) as 'jun',
                (SUM(ISNULL(co.jul_orcado,0) * {$cota})) as 'jul',
                (SUM(ISNULL(co.ago_orcado,0) * {$cota})) as 'ago',
                (SUM(ISNULL(co.set_orcado,0) * {$cota})) as 'set',
                (SUM(ISNULL(co.out_orcado,0) * {$cota})) as 'out',
                (SUM(ISNULL(co.nov_orcado,0) * {$cota})) as 'nov',
                (SUM(ISNULL(co.dez_orcado,0) * {$cota})) as 'dez',

                (-SUM(ISNULL(co.jan_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_jan',

                (-SUM(ISNULL(co.fev_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_fev',
                
                (-SUM(ISNULL(co.mar_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_mar',

                (-SUM(ISNULL(co.abr_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_abr',

                (-SUM(ISNULL(co.mai_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_mai',

                (-SUM(ISNULL(co.jun_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_jun',

                (-SUM(ISNULL(co.mar_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_jul',

                (-SUM(ISNULL(co.ago_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_ago',

                (-SUM(ISNULL(co.set_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_set',

                 (-SUM(ISNULL(co.out_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_out',

                (-SUM(ISNULL(co.nov_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_nov',

                (-SUM(ISNULL(co.dez_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                where pne = 1 and dat_demis_func is null)) as 'diferenca_dez'
                
                from tbl_orc_lot_carg_headcount as hc
                join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
                join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
                join tbl_lotacao l on l.id = ol.lotacao_id
                
                join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
                join tbl_cargo as c on c.id = oc.cargo_id
                -- join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id and func.pne = 1
                
                -- left join tblg_parametros as par on cod_parametro like('%CTPCD%')
                
            where hc.orc_id = {$orc_id} and c.cota_pcd = 1 and c.ativo = 1 and hc.tipo_table = '{$tipo_table}'".$concatena_periodo;

            
        return $sql;
    }

    private function montaSQLJA($cota, $nivel, $orc_id, $tipo_table, $lotacoes_string, $concatena_periodo, $tipo){
        $qtd = $nivel + 2;
        $sql = "";
        while($qtd <= 8){
            $qtd_zeros = '';
            $i = 8-$qtd;
            while($i > 0){
                $qtd_zeros = $qtd_zeros.'0';
                $i--; 
            }
            
            $union = strlen($sql) > 0 ? " UNION " : "";
            $sql = $sql.$union."SELECT distinct
            LEFT(l.unid_lotac, $qtd) as 'unidade_lotacao_cod', 
            concat((select top 1 LEFT(lot.des_unid_lotac, CHARINDEX('-', lot.des_unid_lotac)) from tbl_lotacao as lot where lot.unid_lotac = LEFT(l.unid_lotac, $qtd)+'{$qtd_zeros}' ), ' ', LEFT(l.unid_lotac, $qtd)) as 'unidade_lotacao',
            
            (select count(*) from tbl_funcionario as funcionario
            join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            join tbl_cargo as c on c.id = funcionario.cargo_id
            where c.des_cargo_basic = 'Jovem Aprendiz' and c.ativo = 1 and dat_demis_func is null and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, 2)) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'ago',
            (SUM(ISNULL(co.set_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'set',
            (SUM(ISNULL(co.out_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'out',
            (SUM(ISNULL(co.nov_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0) * {$cota} )over(partition by LEFT(l.unid_lotac, $qtd))) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null and /*c.cota_jovem_aprendiz = 1 and*/ c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_set',

            (-SUM(ISNULL(co.out_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0) * {$cota})over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0) * {$cota}) over(partition by LEFT(l.unid_lotac, $qtd)) + (select count(*) from tbl_funcionario as funcionario
                join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 and LEFT(lot.unid_lotac, $qtd) = LEFT(l.unid_lotac, $qtd))) as 'diferenca_dez'
                
                /*MRN*/
                -- (-SUM(ISNULL(co.jan_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_jan',

                -- (-SUM(ISNULL(co.fev_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_fev',

                -- (-SUM(ISNULL(co.mar_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_mar',

                -- (-SUM(ISNULL(co.abr_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_abr',

                -- (-SUM(ISNULL(co.mai_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_mai',

                -- (-SUM(ISNULL(co.jun_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_jun',

                -- (-SUM(ISNULL(co.jul_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_jul',

                -- (-SUM(ISNULL(co.ago_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_ago',

                -- (-SUM(ISNULL(co.set_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_set',

                -- (-SUM(ISNULL(co.out_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_out',

                -- (-SUM(ISNULL(co.nov_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_nov',
                    
                -- (-SUM(ISNULL(co.dez_orcado,0)) * {$cota} + (select count(*) from tbl_funcionario as funcionario
                --     join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                --     join tbl_cargo as c on c.id = funcionario.cargo_id
                --     where /*c.des_cargo_basic = 'Jovem Aprendiz'*/ c.cota_jovem_aprendiz = 1 and c.ativo = 1 )) as 'mrn_dez',

                from tbl_orc_lot_carg_headcount as hc
                join tbl_calc_orcamento co on co.origem_id = hc.id and co.tbl_origem = 'tbl_orc_lot_carg_headcount'
                join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
                join tbl_lotacao l on l.id = ol.lotacao_id
                
                join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
                join tbl_cargo as c on c.id = oc.cargo_id
                --join tbl_funcionario as func on func.cargo_id = c.id and func.lotacao_id = l.id --and func. = 1
                
                --left join tblg_parametros as par on cod_parametro like('%CTJAP%')
                
                where hc.orc_id = {$orc_id} and c.cota_jovem_aprendiz = 1 and c.cod_cargo_basic <> 12121 and l.unid_lotac <> '02020300' and hc.tipo_table = '{$tipo_table}' and l.id in ({$lotacoes_string})".$concatena_periodo."
                and RIGHT(LEFT(l.unid_lotac, $qtd), 2) <> '00'
                --group by LEFT(l.unid_lotac, $qtd)
            ";
            $qtd = $qtd + 2;
        }
        if($tipo != 3){
            return $sql;
        }
        
        $sql = $sql." UNION
        select
            '999999999999' as 'unidade_lotacao_cod',
            'MRN' as 'unidade_lotacao', 

            (select count(*) from tbl_funcionario as funcionario
            --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
            join tbl_cargo as c on c.id = funcionario.cargo_id
            where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null and c.ativo = 1) as atual,
            
            (SUM(ISNULL(co.jan_orcado,0) * {$cota} )) as 'jan',
            (SUM(ISNULL(co.fev_orcado,0) * {$cota} )) as 'fev',
            (SUM(ISNULL(co.mar_orcado,0) * {$cota} )) as 'mar',
            (SUM(ISNULL(co.abr_orcado,0) * {$cota} )) as 'abr',
            (SUM(ISNULL(co.mai_orcado,0) * {$cota} )) as 'mai',
            (SUM(ISNULL(co.jun_orcado,0) * {$cota} )) as 'jun',
            (SUM(ISNULL(co.jul_orcado,0) * {$cota} )) as 'jul',
            (SUM(ISNULL(co.ago_orcado,0) * {$cota} )) as 'ago',
            (SUM(ISNULL(co.set_orcado,0) * {$cota} )) as 'set',
            (SUM(ISNULL(co.out_orcado,0) * {$cota} )) as 'out',
            (SUM(ISNULL(co.nov_orcado,0) * {$cota} )) as 'nov',
            (SUM(ISNULL(co.dez_orcado,0) * {$cota} )) as 'dez',

            (-SUM(ISNULL(co.jan_orcado,0) * {$cota})  + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null and /*c.cota_jovem_aprendiz = 1 and*/ c.ativo = 1)) as 'diferenca_jan',

            (-SUM(ISNULL(co.fev_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_fev',
            
            (-SUM(ISNULL(co.mar_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_mar',

            (-SUM(ISNULL(co.abr_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_abr',

            (-SUM(ISNULL(co.mai_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_mai',

            (-SUM(ISNULL(co.jun_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_jun',

            (-SUM(ISNULL(co.mar_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_jul',

            (-SUM(ISNULL(co.ago_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_ago',

            (-SUM(ISNULL(co.set_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_set',

            (-SUM(ISNULL(co.out_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_out',

            (-SUM(ISNULL(co.nov_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_nov',

            (-SUM(ISNULL(co.dez_orcado,0) * {$cota}) + (select count(*) from tbl_funcionario as funcionario
                --join tbl_lotacao as lot on lot.id = funcionario.lotacao_id
                join tbl_cargo as c on c.id = funcionario.cargo_id
                where c.des_cargo_basic = 'Jovem Aprendiz' and dat_demis_func is null /*c.cota_jovem_aprendiz = 1 and*/ and c.ativo = 1 )) as 'diferenca_dez'
            

            from tbl_orc_lot_carg_headcount as hc
            join tbl_calc_orcamento co on co.tbl_origem = 'tbl_orc_lot_carg_headcount' and co.origem_id = hc.id
            join tbl_orc_lotacao ol on ol.id = hc.lotacao_id
            join tbl_lotacao l on l.id = ol.lotacao_id
            
            join tbl_orc_cargo as oc on oc.id = hc.orc_cargo_id
            join tbl_cargo as c on c.id = oc.cargo_id
            --join tbl_funcionario as func on func.cargo_id = c.id --and func.lotacao_id = l.id 
            
            where hc.orc_id = {$orc_id} and c.cota_jovem_aprendiz = 1 and c.cod_cargo_basic <> 12121 and l.unid_lotac <> '02020300' and hc.tipo_table = '{$tipo_table}'".$concatena_periodo."
        ";
        return $sql;
    }
}
// QUERY PARA TESTES
/*
select sum(calc.jan_orcado), sum(calc.jan_orcado)*0.05, left(lot.unid_lotac, 2) from tbl_orc_lot_carg_headcount as hd
inner join tbl_calc_orcamento as calc on calc.origem_id = hd.id and tbl_origem = 'tbl_orc_lot_carg_headcount'
inner join tbl_orc_lotacao as olot on olot.id = hd.lotacao_id
inner join tbl_lotacao as lot on lot.id = olot.lotacao_id
inner join tbl_orc_cargo as oc on oc.id = hd.orc_cargo_id
inner join tbl_cargo as c on c.id = oc.cargo_id
where hd.orc_id = 266 and hd.tipo_table = 'O' and c.cota_pcd = 1 and c.ativo = 1 group by left(lot.unid_lotac, 2)
*/