<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use Illuminate\Support\Facades\DB as DB;
class RepoRelatorioPromocao extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcPromocao';
    protected $form_rules = [];
    protected $rules_msg = [];

    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();
    }

    public function listarRelatorioPromocao($orc_id, $tipo_table, $periodo){
        set_time_limit($this->getTimeOut());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $tipo_table = $periodo != null ? 'F' : 'O';

		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id, $periodo, $tipo_table);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );
			
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;

        if($tipo_table != null && $periodo != null){
            return $this->listarPromocaoForecast($orc_id, $tipo_table, $periodo, $lotacoes_string);
        }
        $tipo_table = 'O';
        $select = DB::select("SELECT 
            concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
            concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
            
            concat(lotdestino.unid_lotac,' - ', lotdestino.des_unid_lotac) as lotacao_destino,
            concat(ccdestino.cod_ccusto,' - ',ccdestino.des_ccusto) as centro_custo_destino,
        
            concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
            concat(cargodestino.cod_cargo_basic,' - ',cargodestino.des_cargo_basic) as cargo_destino,
        
            concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
            concat(turnodestino.cdn_turno_trab,' - ', turnodestino.des_turno_trab,' - ', orcturmadestino.cdn_turma_trab, ' - ', orcturmadestino.des_turma_trab) as turma_destino,
            concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario,

            prom.turma_atual_id, orcturma.turno_id,
            prom.lotacao_id,
            prom.ccusto_id,
            cargo_atual_id,
            prom.funcionario_id,
            cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id,
            count(*) OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id, cargo_atual_id, prom.turma_atual_id, cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id, prom.funcionario_id) qtd,
            count(*) OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id) total_qtd,

            -- SUM(
			-- CASE
			-- WHEN cargo_promovido_id <> cargo_atual_id THEN 1
			-- ELSE 0 END
			-- )OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id) total_qtd,

			-- SUM(
			-- CASE
			-- WHEN cargo_promovido_id <> cargo_atual_id THEN 1
			-- ELSE 0 END)OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id, cargo_atual_id, prom.turma_atual_id, cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id, prom.funcionario_id),

            CASE mes_promocao
                
            WHEN 1 THEN 'Janeiro'
            WHEN 2 THEN 'Fevereiro'
            WHEN 3 THEN 'Março'
            WHEN 4 THEN 'Abril'
            WHEN 5 THEN 'Maio'
            WHEN 6 THEN 'Junho'
            WHEN 7 THEN 'Julho'
            WHEN 8 THEN 'Agosto'
            WHEN 9 THEN 'Setembro'
            WHEN 10 THEN 'Outubro'
            WHEN 11 THEN 'Novembro'
            WHEN 12 THEN 'Dezembro'
            
            END  as mes_promocao
            
            FROM tbl_orc_promocao as prom 
        
            left join tbl_orc_lotacao as orclot on prom.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
            left join tbl_lotacao as lot on orclot.lotacao_id = lot.id
            left join tbl_ccusto as cc on orclot.cc_custo_id = cc.id
            left join tbl_funcionario as func on func.id = prom.funcionario_id
        
            left join tbl_orc_lotacao as orclotdestino on prom.lotacao_promovida_id = orclotdestino.id and orclotdestino.orcamento_id = {$orc_id} 
            left join tbl_lotacao as lotdestino on orclotdestino.lotacao_id = lotdestino.id
            left join tbl_ccusto as ccdestino on prom.ccusto_promovido_id = ccdestino.id
        
            /*validacao da distribuição*/
            left join tbl_orc_lot_carg_headcount as hd on prom.orc_id = hd.orc_id and prom.cargo_atual_id = hd.orc_cargo_id and prom.lotacao_id = hd.lotacao_id and prom.turma_atual_id = hd.orc_turma_id
            and hd.tipo_table = '{$tipo_table}'
            left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
            /**/
        
            left join tbl_orc_turma as orcturma on prom.turma_atual_id = orcturma.id and orcturma.orc_id = {$orc_id}
            left join tbl_turno as turno on orcturma.turno_id = turno.id
        
            left join tbl_orc_turma as orcturmadestino on prom.turma_promovida_id = orcturmadestino.id and orcturmadestino.orc_id = {$orc_id}
            left join tbl_turno as turnodestino on orcturmadestino.turno_id = turnodestino.id
        
            left join tbl_orc_cargo as orccargo on orccargo.id = prom.cargo_atual_id and orccargo.orcamento_id = {$orc_id}
            left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
        
            left join tbl_orc_cargo as orccargodestino on orccargodestino.id = prom.cargo_promovido_id and orccargodestino.orcamento_id = {$orc_id}
            left join tbl_cargo as cargodestino on orccargodestino.cargo_id = cargodestino.id
        
            where prom.orc_id = {$orc_id} and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
            calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
            calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and prom.tipo_table = '{$tipo_table}'
        ");
        
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
    }

    public function listarPromocaoForecast($orc_id, $tipo_table, $periodo, $lotacoes_string){
        set_time_limit($this->getTimeOut());
        $select = DB::select("SELECT 
            concat(lot.unid_lotac,' - ', lot.des_unid_lotac) as lotacao,
            concat(cc.cod_ccusto,' - ',cc.des_ccusto) as centro_custo,
            
            concat(lotdestino.unid_lotac,' - ', lotdestino.des_unid_lotac) as lotacao_destino,
            concat(ccdestino.cod_ccusto,' - ',ccdestino.des_ccusto) as centro_custo_destino,
        
            concat(cargo.cod_cargo_basic,' - ',cargo.des_cargo_basic) as cargo,
            concat(cargodestino.cod_cargo_basic,' - ',cargodestino.des_cargo_basic) as cargo_destino,
        
            concat(turno.cdn_turno_trab,' - ', turno.des_turno_trab,' - ', orcturma.cdn_turma_trab, ' - ', orcturma.des_turma_trab) as turma,
            concat(turnodestino.cdn_turno_trab,' - ', turnodestino.des_turno_trab,' - ', orcturmadestino.cdn_turma_trab, ' - ', orcturmadestino.des_turma_trab) as turma_destino,
            concat(func.cdn_funcionario, ' - ', func.nome_funcionario) as funcionario,

            prom.turma_atual_id, orcturma.turno_id,
            prom.lotacao_id,
            prom.ccusto_id,
            cargo_atual_id,
            prom.periodo,
            prom.funcionario_id,
            cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id,
            count(*) OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id, cargo_atual_id, prom.turma_atual_id, cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id, prom.funcionario_id) qtd,
            count(*) OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id) total_qtd,

            -- SUM(
			-- CASE
			-- WHEN cargo_atual_id <> cargo_promovido_id THEN 1
			-- ELSE 0 END
			-- )OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id) as qtd,

			-- SUM(
			-- CASE
			-- WHEN cargo_atual_id <> cargo_promovido_id THEN 1
			-- ELSE 0 END)OVER(PARTITION BY prom.lotacao_id, prom.ccusto_id, cargo_atual_id, prom.turma_atual_id, cargo_promovido_id, turma_promovida_id, lotacao_promovida_id, ccusto_promovido_id, prom.funcionario_id) qtd
            
            CASE mes_promocao
                
            WHEN 1 THEN 'Janeiro'
            WHEN 2 THEN 'Fevereiro'
            WHEN 3 THEN 'Março'
            WHEN 4 THEN 'Abril'
            WHEN 5 THEN 'Maio'
            WHEN 6 THEN 'Junho'
            WHEN 7 THEN 'Julho'
            WHEN 8 THEN 'Agosto'
            WHEN 9 THEN 'Setembro'
            WHEN 10 THEN 'Outubro'
            WHEN 11 THEN 'Novembro'
            WHEN 12 THEN 'Dezembro'
            
            END  as mes_promocao
            
            FROM tbl_orc_promocao as prom 
        
            left join tbl_orc_lotacao as orclot on prom.lotacao_id = orclot.id and orclot.orcamento_id = {$orc_id} 
            left join tbl_lotacao as lot on orclot.lotacao_id = lot.id
            left join tbl_ccusto as cc on orclot.cc_custo_id = cc.id
            left join tbl_funcionario as func on func.id = prom.funcionario_id
        
            left join tbl_orc_lotacao as orclotdestino on prom.lotacao_promovida_id = orclotdestino.id and orclotdestino.orcamento_id = {$orc_id} 
            left join tbl_lotacao as lotdestino on orclotdestino.lotacao_id = lotdestino.id
            left join tbl_ccusto as ccdestino on prom.ccusto_promovido_id = ccdestino.id
        
            /*validacao da distribuição*/
            left join tbl_orc_lot_carg_headcount as hd on prom.orc_id = hd.orc_id and prom.cargo_atual_id = hd.orc_cargo_id and prom.lotacao_id = hd.lotacao_id and prom.turma_atual_id = hd.orc_turma_id
            and hd.tipo_table = '{$tipo_table}' and hd.periodo = '{$periodo}'
            left join tbl_calc_orcamento as calc_hd on hd.id = calc_hd.origem_id and calc_hd.tbl_origem = 'tbl_orc_lot_carg_headcount'
            /**/
        
            left join tbl_orc_turma as orcturma on prom.turma_atual_id = orcturma.id and orcturma.orc_id = {$orc_id}
            left join tbl_turno as turno on orcturma.turno_id = turno.id
        
            left join tbl_orc_turma as orcturmadestino on prom.turma_promovida_id = orcturmadestino.id and orcturmadestino.orc_id = {$orc_id}
            left join tbl_turno as turnodestino on orcturmadestino.turno_id = turnodestino.id
        
            left join tbl_orc_cargo as orccargo on orccargo.id = prom.cargo_atual_id and orccargo.orcamento_id = {$orc_id}
            left join tbl_cargo as cargo on orccargo.cargo_id = cargo.id
        
            left join tbl_orc_cargo as orccargodestino on orccargodestino.id = prom.cargo_promovido_id and orccargodestino.orcamento_id = {$orc_id}
            left join tbl_cargo as cargodestino on orccargodestino.cargo_id = cargodestino.id
        
            where prom.orc_id = {$orc_id} and orclot.lotacao_id in ($lotacoes_string) and (hd.qtd_func_lot != 0 or hd.forecast_anterior != 0 or 
            ( calc_hd.jan_orcado != 0 or calc_hd.fev_orcado != 0 or calc_hd.mar_orcado != 0 or calc_hd.abr_orcado != 0 or
            calc_hd.mai_orcado != 0 or calc_hd.jun_orcado != 0 or calc_hd.jul_orcado != 0 or calc_hd.ago_orcado != 0 or
            calc_hd.set_orcado != 0 or calc_hd.out_orcado != 0 or calc_hd.nov_orcado != 0 or calc_hd.dez_orcado != 0 )) and prom.tipo_table = '{$tipo_table}' and prom.periodo = '{$periodo}'
        ");
        $dados = [];
		for($i = 0; $i < count($select); $i++){
			$dados[$i] = (array)$select[$i];
		}
		return $dados;
    }
}
