<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;


use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioRealizado extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
    protected $form_rules = [];
    protected $rules_msg = [];

	public function __construct(){
		$this->setTimeOut(700);
		parent::__construct();
	}
    public function listarRelatorioRealizado($orc_id){
		set_time_limit($this->getTimeOut());
		// dd("orcamento", $orc_id);
		$tipo_table = 'R'; 
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		// $tb_orc_lot_carg_headcount = new OrcamLotCargoHeadcount();
		// $tb_calc_orcamento = new CalcOrcamento();
		// $tb_cargo = new Cargo();
		// $tb_centro_custo = new CentroCusto();
		// $tb_turma = new OrcTurma();
		// $tb_turno = new Turno();
		// $tb_lotacao = new OrcLotacao();
		// $tb_orc_cargo = new OrcCargo(); 
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
		$lotacoes = ( array_column( $dados, 'lotacao_id' ) );

			
		$lotacoes_string = implode(",",$lotacoes);
		$lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
		// dd("lot str", $lotacoes_string);
        
		DB::enableQueryLog();
		// $data_query = $tb_lotacao->join($tb_orc_lot_carg_headcount->getTable(),
		// $tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
		//   ->join($tb_calc_orcamento->getTable(), $tb_orc_lot_carg_headcount->getColunaAlias('id'), '=', 
		// 	  DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
		// 	  {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_lot_carg_headcount->getTable()}'"))
		//   ->join($tb_orc_cargo->getTable(),
		// 	  $tb_orc_lot_carg_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
		//   ->join($tb_cargo->getTable(),
		// 	  $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
		//   ->join($tb_centro_custo->getTable(),
		// 	  $tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
		//   ->join($tb_turma->getTable(),
		// 	  $tb_orc_lot_carg_headcount->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
		//   ->join($tb_turno->getTable(),
		// 		  $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
		// 	->select(
		// 		DB::raw($tb_calc_orcamento->getColunaAlias('id')),
		// 		DB::raw($tb_orc_lot_carg_headcount->getColunaAlias('id').' as id_princ'), 
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('orc_id'), 
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('qtd_func_lot'), 
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('atual_total'), 
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id'),
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('orcado_anterior'),
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('origem_sistema'),
		// 		$tb_orc_cargo->getColunaAlias('cargo_id'), 
		// 		$tb_cargo->getColunaAlias('cod_cargo_basic'), 
		// 		$tb_cargo->getColunaAlias('des_cargo_basic'),
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id'), 
		// 		$tb_centro_custo->getColunaAlias('cod_ccusto'), 
		// 		$tb_turma->getColunaAlias('cdn_turma_trab'), 
		// 		$tb_turma->getColunaAlias('des_turma_trab'), 
		// 		$tb_turno->getColunaAlias('cdn_turno_trab'),
		// 		$tb_turno->getColunaAlias('des_turno_trab'),
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('orc_turma_id'),
  
		// 		// DB::raw($forecast_dez_anterior.' as forecast_anterior'), 
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('forecast_anterior'),
		// 		$tb_orc_lot_carg_headcount->getColunaAlias('forecast_total'),
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jan"),
		// 		$tb_calc_orcamento->getColunaAlias('jan_orcado'),
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_fev"),
		// 		$tb_calc_orcamento->getColunaAlias('fev_orcado'), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mar, 
		// 		{$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_abr, 
		// 		{$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mai, 
		// 		{$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jun, 
		// 		{$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jul, 
		// 		{$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_ago, 
		// 		{$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_set, 
		// 		{$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_out, 
		// 		{$tb_calc_orcamento->getColunaAlias('out_orcado')}"),
  
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_nov, 
		// 		{$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
				
		// 		DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('ccusto_id')}, 
		// 		{$tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id')},
		// 		{$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_dez, 
		// 		{$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
		// 	)
		// 	->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')},
		// 	{$tb_turma->getColunaAlias('cdn_turma_trab')}")   
		// 	->where([
		// 		[$tb_orc_lot_carg_headcount->getColunaAlias('orc_id'),$orc_id],
		// 	    [$tb_orc_lot_carg_headcount->getColunaAlias('tipo_table'),$tipo_table],
		// 	])->whereIn($tb_orc_lot_carg_headcount->getColunaAlias('lotacao_id'), $lotacoes);

		$query = "SELECT
			tbl_calc_orcamento.id, tbl_orc_lot_carg_headcount.id as id_princ, 
		[tbl_orc_lot_carg_headcount].[orc_id], [tbl_orc_lot_carg_headcount].[qtd_func_lot], 
		[tbl_orc_lot_carg_headcount].[atual_total], 
		[tbl_orc_lot_carg_headcount].[lotacao_id], 
		[tbl_orc_lot_carg_headcount].[orcado_anterior], 
		[tbl_orc_lot_carg_headcount].[origem_sistema],
		[tbl_orc_cargo].[cargo_id], 
		[tbl_cargo].[cod_cargo_basic], 
		[tbl_cargo].[des_cargo_basic], 
		[tbl_orc_lot_carg_headcount].[ccusto_id], 
		[tbl_ccusto].[cod_ccusto], 
		[tbl_orc_turma].[cdn_turma_trab], 
		[tbl_orc_turma].[des_turma_trab], 
		[tbl_turno].[cdn_turno_trab], 
		[tbl_turno].[des_turno_trab], 
		[tbl_orc_lot_carg_headcount].[orc_turma_id], 
		[tbl_orc_lot_carg_headcount].[forecast_anterior], 
		[tbl_orc_lot_carg_headcount].[forecast_total],
		CONCAT(tbl_cargo.cod_cargo_basic, ' - ', tbl_cargo.des_cargo_basic) as 'cargo',
		
		SUM(tbl_calc_orcamento.jan_orcado) OVER(partition by   
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_jan, 
		[tbl_calc_orcamento].[jan_orcado], 
	  	SUM(tbl_calc_orcamento.fev_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
		tbl_orc_cargo.cargo_id) t_headcount_fev, [tbl_calc_orcamento].[fev_orcado], 
	 	SUM(tbl_calc_orcamento.mar_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_mar, 
		tbl_calc_orcamento.mar_orcado, 
	  	SUM(tbl_calc_orcamento.abr_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_abr, 
		tbl_calc_orcamento.abr_orcado, 
	  	SUM(tbl_calc_orcamento.mai_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_mai, 
		tbl_calc_orcamento.mai_orcado, 
	  	SUM(tbl_calc_orcamento.jun_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_jun, 
		tbl_calc_orcamento.jun_orcado, 
	  	SUM(tbl_calc_orcamento.jul_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_jul, 
		tbl_calc_orcamento.jul_orcado, 
	  	SUM(tbl_calc_orcamento.ago_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_ago, 
		tbl_calc_orcamento.ago_orcado, 
	  	SUM(tbl_calc_orcamento.set_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_set, 
		tbl_calc_orcamento.set_orcado, 
	  	SUM(tbl_calc_orcamento.out_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_out, 
		tbl_calc_orcamento.out_orcado, 
	 	SUM(tbl_calc_orcamento.nov_orcado) OVER(partition by
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_nov, 
		tbl_calc_orcamento.nov_orcado, 
	 	SUM(tbl_calc_orcamento.dez_orcado) OVER(partition by 
			tbl_orc_lot_carg_headcount.ccusto_id, 
			tbl_orc_lot_carg_headcount.lotacao_id,
			tbl_orc_cargo.cargo_id) t_headcount_dez, 			
	  	tbl_calc_orcamento.dez_orcado ,
		CONCAT([tbl_lotacao].unid_lotac, ' - ', [tbl_lotacao].des_unid_lotac) as lotacao		
	  
		from [tbl_orc_lotacao]
		inner join [tbl_orc_lot_carg_headcount] on [tbl_orc_lot_carg_headcount].[lotacao_id] = [tbl_orc_lotacao].[id] 
		inner join [tbl_calc_orcamento] on [tbl_orc_lot_carg_headcount].[id] = tbl_calc_orcamento.origem_id 
			and tbl_calc_orcamento.tbl_origem = 'tbl_orc_lot_carg_headcount' 
		inner join [tbl_orc_cargo] on [tbl_orc_lot_carg_headcount].[orc_cargo_id] = [tbl_orc_cargo].[id] 
		inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
		inner join [tbl_lotacao] on [tbl_lotacao].id = [tbl_orc_lotacao].lotacao_id
		inner join [tbl_ccusto] on [tbl_orc_lot_carg_headcount].[ccusto_id] = [tbl_ccusto].[id] 
		inner join [tbl_orc_turma] on [tbl_orc_lot_carg_headcount].[orc_turma_id] = [tbl_orc_turma].[id] 
		inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 
		
	
		where ([tbl_orc_lot_carg_headcount].[orc_id] = $orc_id and [tbl_orc_lot_carg_headcount].[tipo_table] = '$tipo_table') 
		and [tbl_orc_lotacao].[lotacao_id] 
		in ($lotacoes_string)
		order by tbl_ccusto.cod_ccusto, tbl_cargo.cod_cargo_basic,
		tbl_orc_turma.cdn_turma_trab";

		$data = DB::select($query);
		$dados = [];
		$data = json_decode(json_encode($data), true);
			// $data = $data_query->get()->toArray();
			// dd("query", DB::getQueryLog());
			// dd("testeee",$data);
			//  dd("pivooooo",$this->pivo($data));
		  return $data;
    }
}