<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;


 
use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioRealizadoAumentos extends RepositoryNat51
{ 

    use \App\Core\Traits\ParamTrait;
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcSalarioFuncionario'; 

    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();
    }
    public function listarRelatorioRealizadoAumentos($orc_id){        
        set_time_limit($this->getTimeOut());
        // $data = $this->listajson();
        // dd($tipo_table);     
        // return new Response($data , 200);  
        // $this->setCodTela('REALAS');      
        // $this->podeAcessar('listar',true,$this->getCodTela());
    //    dd("mes", $mes);

        $tbl_orc_lotacao_controller = new OrcLotacaoController();
        $dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        // dd("lotacao", $lotacoes_string);
      
        $query = "SELECT 
        CONCAT(c.cod_cargo_basic, ' - ',c.des_cargo_basic) as description_cargo,
        CONCAT(func.cdn_funcionario, ' - ',func.nome_funcionario) as description_func,
        func.cdn_funcionario,
        CASE MONTH(osf.periodo) 
            WHEN 1 THEN 'Janeiro'
            WHEN 2 THEN 'Fevereiro' 
            WHEN 3 THEN 'Março'
            WHEN 4 THEN 'Abril'
            WHEN 5 THEN 'Maio'
            WHEN 6 THEN 'Junho'
            WHEN 7 THEN 'Julho'
            WHEN 8 THEN 'Agosto'
            WHEN 9 THEN 'Setembro'
            WHEN 10 THEN 'Outubro'
            WHEN 11 THEN 'Novembro'
            WHEN 12 THEN 'Dezembro'
        END as mes,
        co.jan_orcado,
        co.fev_orcado,
        co.mar_orcado,
        co.abr_orcado,
        co.mai_orcado,
        co.jun_orcado,
        co.jul_orcado,
        co.ago_orcado,
        co.set_orcado,
        co.out_orcado,
        co.nov_orcado,
        co.dez_orcado,
		[tbl_ccusto].cod_ccusto,
		CONCAT([tbl_lotacao].unid_lotac, ' - ', [tbl_lotacao].des_unid_lotac) as lotacao
        
        
        from tbl_orc_salario_funcionario as osf
        inner join tbl_orc_lotacao as ol on ol.id = osf.lotacao_id and ol.orcamento_id = $orc_id
		inner join [tbl_lotacao] on [tbl_lotacao].id = ol.lotacao_id
		inner join [tbl_ccusto] on [tbl_ccusto].id = ol.cc_custo_id
        inner join tbl_orc_cargo as oc on oc.id = osf.orc_cargo_id and oc.orcamento_id = $orc_id
        inner join tbl_cargo as c on c.id = oc.cargo_id
        inner join tbl_funcionario as func on func.id = osf.funcionario_id
        inner join tbl_calc_orcamento as co on co.origem_id = osf.id and co.tbl_origem = 'tbl_orc_salario_funcionario'
        
        where osf.orc_id = $orc_id
        and osf.tipo_table = 'R'
        and ol.lotacao_id in ($lotacoes_string)";

        $data = DB::select($query);   
        $dados = json_decode(json_encode($data), true);
        return $dados;
    }


}