<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Funcionario;



use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioRealizadoContratacoes extends RepositoryNat51{
    protected $model_name_space = 'App\Modules\Natureza51\Entities\OrcHeadcountContratacoes';
    protected $form_rules = [];
    protected $rules_msg = [];

    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();
    }

    public function listarRelatorioRealizadoContratacoes($orc_id){
        // dd("orcamento", $orc_id);
        set_time_limit($this->getTimeOut());
        $tipo_table = 'R'; 
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
		// dd("lot str", $lotacoes_string);
        
        /*$tb_orc_headcount_contrat = new OrcHeadcountContratacoes();    
        $tb_cargo = new Cargo();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        $tbl_funcionario = new Funcionario();*/
	
        
		DB::enableQueryLog();

        $query = "SELECT 
              CASE MONTH(tbl_funcionario.dat_admis_func) 
                WHEN 1 THEN 'Janeiro'
                WHEN 2 THEN 'Fevereiro'
                WHEN 3 THEN 'Março'
                WHEN 4 THEN 'Abril'
                WHEN 5 THEN 'Maio'
                WHEN 6 THEN 'Junho'
                WHEN 7 THEN 'Julho'
                WHEN 8 THEN 'Agosto'
                WHEN 9 THEN 'Setembro'
                WHEN 10 THEN 'Outubro'
                WHEN 11 THEN 'Novembro'
                WHEN 12 THEN 'Dezembro'
            END as mes,
            [tbl_orc_headcount_contratacoes].[orc_cargo_id], 
            [tbl_orc_headcount_contratacoes].[orc_turma_id],  
            [tbl_orc_headcount_contratacoes].[lotacao_id],
            [tbl_funcionario].[cdn_funcionario], 
            [tbl_funcionario].[nome_funcionario], 
            [tbl_funcionario].[dat_admis_func], 
            [tbl_funcionario].[cargo_id], 
            [tbl_cargo].[cod_cargo_basic], 
            [tbl_cargo].[des_cargo_basic], 
            [tbl_orc_turma].[cdn_turma_trab], 
            [tbl_orc_turma].[des_turma_trab], 
            [tbl_turno].[cdn_turno_trab], 
            [tbl_turno].[des_turno_trab],
            CONCAT(tbl_cargo.cod_cargo_basic, ' - ',tbl_cargo.des_cargo_basic) as cargo,
			[tbl_ccusto].cod_ccusto,
			CONCAT([tbl_lotacao].unid_lotac, ' - ', [tbl_lotacao].des_unid_lotac) as lotacao		

        from [tbl_orc_headcount_contratacoes] 

        inner join [tbl_orc_lotacao] on [tbl_orc_headcount_contratacoes].[lotacao_id] = [tbl_orc_lotacao].[id] 
		inner join [tbl_lotacao] on [tbl_lotacao].id = [tbl_orc_lotacao].lotacao_id
		inner join [tbl_ccusto] on [tbl_ccusto].id = [tbl_orc_lotacao].cc_custo_id
        inner join [tbl_orc_cargo] on [tbl_orc_headcount_contratacoes].[orc_cargo_id] = [tbl_orc_cargo].[id] 
        inner join [tbl_cargo] on [tbl_orc_cargo].[cargo_id] = [tbl_cargo].[id] 
        inner join [tbl_orc_turma] on [tbl_orc_headcount_contratacoes].[orc_turma_id] = [tbl_orc_turma].[id] 
        inner join [tbl_turno] on [tbl_orc_turma].[turno_id] = [tbl_turno].[id] 
        inner join [tbl_funcionario] on [tbl_funcionario].[id] = [tbl_orc_headcount_contratacoes].[func_id]

        where ([tbl_orc_headcount_contratacoes].[orcamento_id] = $orc_id 
        and [tbl_orc_headcount_contratacoes].[tipo_table] = '$tipo_table')
        and [tbl_orc_lotacao].[lotacao_id] in ($lotacoes_string)";

		$data = DB::select($query);
        // dd("query", DB::getQueryLog($data));
		$dados = [];
		$data = json_decode(json_encode($data), true);
			// $data = $data_query->get()->toArray();
			
			// dd("testeee",$data);
			//  dd("pivooooo",$this->pivo($data));
		  return $data;
    }
}