<?php
namespace App\Modules\Natureza51\Repositories;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Turno; 
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;


use Carbon\Carbon;
use Illuminate\Support\Facades\DB as DB;

class RepoRelatorioRealizadoFerias extends RepositoryNat51
{  

     use \App\Core\Traits\ParamTrait;
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcFerias'; 

    public function __construct(){
        $this->setTimeOut(700);
        parent::__construct();
    }
    public function listarAll($orc_id){     
        set_time_limit($this->getTimeOut());
        // $this->setCodTela('REALFER');      
        // $this->podeAcessar('listar',true,$this->getCodTela());
        $tbl_orc_lotacao_controller = new OrcLotacaoController();
		$dados = $tbl_orc_lotacao_controller->makeEstrutura($orc_id);
        $lotacoes = ( array_column( $dados, 'lotacao_id' ) );
        $lotacoes_string = implode(",",$lotacoes);
        $lotacoes_string = strlen($lotacoes_string) == 0 ? "0" : $lotacoes_string;
        $query = "
        
        SELECT 
        oc.id 'orc_cargo_id',
        ot.id 'orc_turma_id',
        o_ferias.func_id, 
        CASE MONTH(o_ferias.periodo) 
            WHEN 1 THEN 'Janeiro'
            WHEN 2 THEN 'Fevereiro'
            WHEN 3 THEN 'Março'
            WHEN 4 THEN 'Abril'
            WHEN 5 THEN 'Maio'
            WHEN 6 THEN 'Junho'
            WHEN 7 THEN 'Julho'
            WHEN 8 THEN 'Agosto'
            WHEN 9 THEN 'Setembro'
            WHEN 10 THEN 'Outubro'
            WHEN 11 THEN 'Novembro'
            WHEN 12 THEN 'Dezembro'
        END as mes,
        c.cod_cargo_basic, 
        c.des_cargo_basic, 
        CONCAT(c.cod_cargo_basic, ' - ', c.des_cargo_basic) AS 'cargo',
        tm.cdn_turma_trab, 
        tm.des_turma_trab, 
        CONCAT(tm.cdn_turma_trab, ' - ', tm.des_turma_trab) AS 'turma',
        tn.cdn_turno_trab, 
        tn.des_turno_trab, 
        CONCAT(tn.cdn_turno_trab, ' - ', tn.des_turno_trab) AS 'turno',
        CONCAT(tm.cdn_turma_trab, ' - ', tm.des_turma_trab, '-', tn.cdn_turno_trab, ' - ', tn.des_turno_trab) AS 'turma_turno',
        func.cdn_funcionario, 
        func.nome_funcionario, 
        CONCAT(func.cdn_funcionario, ' - ', func.nome_funcionario) AS 'funcionario',
        ISNULL(co.jan_orcado, 0) 'jan',
        ISNULL(co.fev_orcado, 0) 'fev',
        ISNULL(co.mar_orcado, 0) 'mar',
        ISNULL(co.abr_orcado, 0) 'abr',
        ISNULL(co.mai_orcado, 0) 'mai',
        ISNULL(co.jun_orcado, 0) 'jun',
        ISNULL(co.jul_orcado, 0) 'jul',
        ISNULL(co.ago_orcado, 0) 'ago',
        ISNULL(co.set_orcado, 0) 'set',
        ISNULL(co.out_orcado, 0) 'out',
        ISNULL(co.nov_orcado, 0) 'nov',
        ISNULL(co.dez_orcado, 0) 'dez',
        SUM(IIF(ISNULL(co.jan_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_jan',
        SUM(IIF(ISNULL(co.fev_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_fev',
        SUM(IIF(ISNULL(co.mar_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_mar',
        SUM(IIF(ISNULL(co.abr_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_abr',
        SUM(IIF(ISNULL(co.mai_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_mai',
        SUM(IIF(ISNULL(co.jun_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_jun',
        SUM(IIF(ISNULL(co.jul_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_jul',
        SUM(IIF(ISNULL(co.ago_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_ago',
        SUM(IIF(ISNULL(co.set_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_set',
        SUM(IIF(ISNULL(co.out_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_out',
        SUM(IIF(ISNULL(co.nov_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_nov',
        SUM(IIF(ISNULL(co.dez_orcado, 0) > 0, 1, 0)) OVER(PARTITION BY o_ferias.cargo_id) as 't_dez',
        o_ferias.lotacao_id,
        [tbl_ccusto].cod_ccusto,
        CONCAT([tbl_lotacao].unid_lotac, ' - ', [tbl_lotacao].des_unid_lotac) as lotacao

        FROM tbl_orc_ferias o_ferias
    
    JOIN tbl_orc_cargo oc ON oc.id = o_ferias.cargo_id
    JOIN tbl_orc_turma ot ON ot.id = o_ferias.orc_turma_id
    JOIN tbl_funcionario func on func.id = o_ferias.func_id
    JOIN tbl_cargo c ON c.id = oc.cargo_id
    JOIN tbl_turma tm ON tm.id = ot.turma_id
    JOIN tbl_turno tn ON tn.id = ot.turno_id
    JOIN tbl_calc_orcamento co ON co.origem_id = o_ferias.id and co.tbl_origem = 'tbl_orc_ferias'
    join tbl_orc_lotacao ol on ol.id = o_ferias.lotacao_id
    inner join [tbl_lotacao] on [tbl_lotacao].id = ol.lotacao_id
    inner join [tbl_ccusto] on [tbl_ccusto].id = ol.cc_custo_id

        WHERE o_ferias.tipo_table = 'R'
        AND o_ferias.orcamento_id = $orc_id 
        and ol.[lotacao_id] in ($lotacoes_string)";
    //    dd("testeee",$data, $orc_id, $orc_lotacao_id  );

     
    
        $data = DB::select($query);

               
                // $dados = [];
                $dados = json_decode(json_encode($data), true);
 
                // for($i = 0; $i < count($data); $i++){
                
                //     $dados[$i] = (array)$data[$i];
                //     $dados[$i]['total_count'] = count($data);
                // }
            // dd("testeee",$dados);

        return $dados;
        
    }
}