<?php
namespace App\Modules\Natureza51\Repositories;

use Illuminate\Support\Facades\DB;

class RepoScriptsLiberaParamForecast extends RepoOrcamento{

    private $periodo;
    private $orc_id;
    private $usuario_id;
    private $nulo = null;
    public $msg;

    public function __construct($periodo, $orc_id){
        $this->periodo = $periodo;
        $this->orc_id = $orc_id;
        $this->usuario_id = $this->fillModificadoPor();
    }
    public function inserirTudo(){
        // DB::beginTransaction\(\);
        if($this->insertLotacao() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertCargo() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertCargoArea() === false){
            DB::rollBack();
            return false;
        }// ok - inseriu menos registros(26) - *
        if($this->insertBonus() === false){
            DB::rollBack();
            return false;
        }//ok * 
        if($this->insertBeneficio() === false){
            DB::rollBack();
            return false;
        }// ok * 
        if($this->insertBeneficioCargo() === false){
            DB::rollBack();
            return false;
        }// ok * 
        if($this->insertBeneficioFuncionario() === false){
            DB::rollBack();
            return false;
        }// ok * 
        if($this->insertDespesas() === false){
            DB::rollBack();
            return false;
        }// não possue - ok - *
        if($this->insertTurma() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertEvento() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertDissidio() === false){
            DB::rollBack();
            return false;
        }// não possue - ok - *
        if($this->insertSalarioFuncionario() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertPPR() === false){
            DB::rollBack();
            return false;
        }// ok *
        if($this->insertTurmaEvento() === false){
            DB::rollBack();
            return false;
        }// ok - não - *
        if($this->insertEventoLotacaoCargo() === false){
            DB::rollBack();
            return false;
        }// não possue - ok - *
        if($this->insertNaturezaEventos() === false){
            DB::rollBack();
            return false;
        }// ok - colocar cod_natureza e natureza_id - *
        if($this->insertHoraExtra() === false){
            DB::rollBack();
            return false;
        }// ok - *
        if($this->insertHistorico() === false){
            DB::rollBack();
            return false;
        }
        // DB::commit();
        return true;
    }
    public function insertLotacao(){
        $sql = "EXEC gerar_orc_lotacao_forecast :orc_id, :periodo, :usuario_id";

        // DB::beginTransaction\(\);
        try{

            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Lotações. Erro: 220120211539<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        }
        catch(\Exception $e){
            $this->msg = "Falha ao inserir Lotações. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
        return true;
    }
    public function insertCargo(){
        // DB::beginTransaction\(\);
        $nulo = null;
        try{                   
            $sql = "EXEC clone_orcamento_cargo :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Cargo. Erro: 220120211610<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Cargo. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertCargoArea(){
        // DB::beginTransaction\(\);
        $nulo = null;
        try{                   
            $sql = "EXEC clone_orcamento_cargos_area_sal :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Lotação por Cargo. Erro: 250120210836<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Lotação por Cargo. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }
    
    public function insertBonus(){
        $nulo = null;
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_bonus :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Bônus. Erro: 250120211200<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Bônus. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertBeneficio(){
        $nulo = null;
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_beneficio :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Benefícios. Erro: 250120211347<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Benefícios. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertBeneficioCargo(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_benef_lot_carg :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Benefício por Cargo. Erro: 250120211500<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Benefício  por Cargo. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertBeneficioFuncionario(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_benef_lot_func :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Benefício por Funcionário. Erro: 250120211557<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Benefício  por Funcionário. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertDespesas(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_despesas :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone , :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Despesas. Erro: 250120211617<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Despesas. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertTurma(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orc_turma :orc_id, :clone_orc_id, :user, :tipo_table, :periodo";

            $tipo = 'F';
            // $user_id = $this->fillCriadoPor();
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user', $this->usuario_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Despesas. Erro: 250120211645<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Despesas. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertEvento(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_eventos :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Eventos. Erro: 260120210806<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Eventos. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertDissidio(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_dissidio :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Acordo Coletivo. Erro: 260120210829<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Acordo Coletivo. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertSalarioFuncionario(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_salario_funcionario :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Salário por Funcionário. Erro: 260120210955<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Salário por Funcionário. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertPPR(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_ppr :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir PR. Erro: 260120211015<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir PR. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertTurmaEvento(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_turma_evento :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Turma Evento. Erro: 260120211032<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Turma Evento. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertEventoLotacaoCargo(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_lotacao_cargo_evento :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Eventos por Lotação e Cargo. Erro: 260120211051<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Eventos por Lotação e Cargo. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertNaturezaEventos(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC clone_orcamento_natureza_eventos :orc_id, :clone_orc_id, :tipo_table, :periodo, :tipo_clone, :usuario_id";

            $tipo = 'F';
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
            $stmt->bindParam(':tipo_clone', $this->nulo, \PDO::PARAM_NULL );
            $stmt->bindParam(':usuario_id', $this->usuario_id, \PDO::PARAM_INT );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Natureza Eventos. Erro: 260120211103<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Natureza Eventos. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }
    
    public function insertHoraExtra(){
        
        // DB::beginTransaction\(\);
        try{                 
            
            $sql = "EXEC clone_hora_extra :orc_id, :clone_orc_id, :user_id, :tipo_table, :periodo";

            $tipo = 'F';
            // $user_id = $this->fillCriadoPor();
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':clone_orc_id', $this->orc_id, \PDO::PARAM_INT );
            $stmt->bindParam(':user_id', $this->usuario_id, \PDO::PARAM_INT );
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR );
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR );
                                        
            if(!$stmt->execute()){
                $this->msg = "Falha ao inserir Horas Extras. Erro: 260120211139<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Horas Extras. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }

    public function insertHistorico(){
        
        // DB::beginTransaction\(\);
        try{                   
            $sql = "EXEC sp_hist_parametros :orc_id, :periodo, :tipo_table";

            $tipo = 'F';
            // $user_id = $this->fillCriadoPor();
            $stmt = DB::getPdo()->prepare($sql);
            $stmt->bindParam(':orc_id', $this->orc_id, \PDO::PARAM_INT);
            $stmt->bindParam(':periodo', $this->periodo, \PDO::PARAM_STR);
            $stmt->bindParam(':tipo_table', $tipo, \PDO::PARAM_STR);

            if (!$stmt->execute()) {
                $this->msg = "Falha ao inserir Histórico das Configurações. Erro: 240320221319<br>";
                DB::rollBack();
                return false;
            }
            // DB::commit();
            return true;
        } catch (\Exception $e) {
            $this->msg = "Falha ao inserir Histórico das Configurações. {$e->getMessage()}<br>";
            DB::rollBack();
            return false;
        }
    }
}
/*
alter table tbl_orc_cargo
add constraint pd_tipo_table DEFAULT 'O' for tipo_table;
*/