<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoTurno;
use App\Modules\Natureza51\Repositories\RepoEventos;
use App\Modules\Natureza51\Entities\OrcTurma;
use Illuminate\Support\Facades\DB;

class RepoTurma extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Turma';
     protected $form_rules=[

                           
                           'turno_id'=>'required|exists:tbl_turno,id',
                           'cdn_turma_trab'=>'required|unique:tbl_turma,cdn_turma_trab',
                         ];

    protected $rules_msg=[
                           
                           'turno_id.required'=>'O campo turno é obrigatório',
                           'turno_id.exists'=>'O campo turno é obrigatório',           
                           'cdn_turma_trab.required' => 'O campo Cód. Turma é obrigatório',                  
                           'cdn_turma_trab.unique' => 'Cód. Turma já foi cadastrado'
                           
                                               
                        ]; 
 

    public function listaTurmaTurno(){
      $turno = new RepoTurno();
      $turma = $this->getModelEntity();
      $list = $turma->join($turno->getModelEntity()->getTable(),$turma->getColunaAlias('turno_id'),$turno->getModelEntity()->getColunaAlias('id'))
      ->select(
        $turma->getColunaAlias('turno_id'),
        $turma->getColunaAlias('evento_adc_id'),
        $turma->getColunaAlias('evento_ext_id'),
        $turma->getColunaAlias('adic_noturno'),
        $turma->getColunaAlias('extra_noturno'),
        $turma->getColunaAlias('ativo'),
        $turma->getColunaAlias('id'),
        $turma->getColunaAlias('des_turma_trab'),
        $turma->getColunaAlias('cdn_turma_trab'),
        $turno->getModelEntity()->getColunaAlias('des_turno_trab'),
        $turno->getModelEntity()->getColunaAlias('cdn_turno_trab')
      )
      ->get()->toArray();

      for($i=0;$i<count($list);$i++){
        $dados[$i]=array_merge($list[$i],array( "description"=>$list[$i]['cdn_turma_trab'].' - '.$list[$i]['des_turma_trab'],
                                                "turno"=>$list[$i]['cdn_turno_trab'].' - '.$list[$i]['des_turno_trab']
                                              ));

      }

      return $dados;

    }

    public function update(array $data,$id,$attribute="id"){
      $this->form_rules['cdn_turma_trab']='required';

      return parent::update($data,$id,$attribute);
    }

    public function listGroupTurma(){
      $data = $this->getModelEntity()->select('cdn_turma_trab','des_turma_trab', DB::raw('COUNT(*) qtd_turnos'))
        ->groupBy('des_turma_trab','cdn_turma_trab')
        ->orderBy('qtd_turnos','desc')
        ->get()->toArray();

        for($i=0;$i<count($data);$i++){
          $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_turma_trab'].' - '.$data[$i]['des_turma_trab']));
      }
      return $dados;
    }

    public function listaTurmas(){
      // $turno = new RepoTurno();
      // $evento1 = new RepoEventos();
      // $evento2 = new RepoEventos();
      // $turma = $this->getModelEntity();
      // $list = $turma->leftJoin($turno->getModelEntity()->getTable(),$turma->getColunaAlias('turno_id'),$turno->getModelEntity()->getColunaAlias('id'))
      // ->leftJoin($evento1->getModelEntity()->getTable(). 'as evento_adc' ,$turma->getColunaAlias('evento_adc_id'),'evento_adc.id')
      // ->leftJoin($evento2->getModelEntity()->getTable(). 'as evento_ext' ,$turma->getColunaAlias('evento_ext_id'),'evento_ext.id')
      // ->select(
      //   $turma->getTable().'.*',
      //   $turno->getModelEntity()->getColunaAlias('des_turno_trab'),
      //   $evento1->getModelEntity()->getColunaAlias('des_event').'as des_evento_adc',
      //   $evento2->getModelEntity()->getColunaAlias('des_event').'as des_evento_ext'
      // )
      // ->get()->toArray();
 
      $list = DB::select("
      select [tbl_turma].*, 
      [tbl_turno].[des_turno_trab], 
      [tbl_turno].[cdn_turno_trab], 
      evento_adc.[des_event] as des_evento_adc, 
      evento_ext.des_event as des_evento_ext,
      evento_adc.cdn_event as cdn_event_adc,
      evento_ext.cdn_event as cdn_event_ext,
      case 
      when tbl_turma.tip_horario_turno = 1 then 'Administrativo' 
      when tbl_turma.tip_horario_turno = 2 then 'Fixo'
      when tbl_turma.tip_horario_turno = 3 then 'Revezamento'
            end as des_tip_horario_turno,
      concat(tbl_turno.cdn_turno_trab, ' - ', tbl_turno.des_turno_trab ) as description_turno,
      concat(evento_ext.cdn_event, ' - ', evento_ext.des_event ) as description_evento_ext,
      concat(evento_adc.cdn_event, ' - ', evento_adc.des_event ) as description_evento_adc

      from [tbl_turma] 
      left join [tbl_turno] on [tbl_turma].[turno_id] = [tbl_turno].[id] 
      left join [tbl_eventos] evento_adc on [tbl_turma].[evento_adc_id] = evento_adc.[id] 
      left join [tbl_eventos] evento_ext on [tbl_turma].[evento_ext_id] = evento_ext.[id]
     
     
      ");

      for($i=0;$i<count($list);$i++){ 

        $list[$i]->description = $list[$i]->cdn_turma_trab.' - '.$list[$i]->des_turma_trab;
        // $dados[$i]=array_merge($list[$i],array("description"=>$list[$i]->cdn_turma_trab.' - '.$list[$i]->des_turma_trab));
      }
      return $list;

    }
    
    
}
