<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoTurno;
use App\Modules\Natureza51\Repositories\RepoEventos;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Facades\DB;
 
class RepoTurmaEvento extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\TurmaEvento';
     protected $form_rules=[

                           
                           'turma_id'=>'required|exists:tbl_turma,id',
                           'evento_id'=>'required|exists:tbl_eventos,id',
                           'qtd_hrs'=>'required'
                         ];

    protected $rules_msg=[
                           
                           'turma_id.required'=>'O campo turma é obrigatório',
                           'evento_id.required'=>'O campo evento é obrigatório',           
                           'qtd_hrs.required' => 'O campo quantidade de horas é obrigatório',                  
                           
                        ]; 

                        public function __construct()
                        {
                          parent::__construct();
                        }

    public function inserir($dados){
      $repo_calc_orcamento = new RepoCalcOrcamento();
      $select = $this->getModelEntity()->select()->where([
        [$this->getModelEntity()->getColunaAlias('turma_id'),$dados['turma_id']],
        [$this->getModelEntity()->getColunaAlias('evento_id'),$dados['evento_id']],
      ])->get()->toArray();
        
      if(count($select) > 0){
        $this->setError("Registro já existente.<br>Erro: 100620201641");
        return false;
      }
      else{
        $meses = $dados['meses'];
        unset($dados['meses']);
        unset($dados['_token']);        
        unset($dados['id']); 
        $inserir = $this->create($dados);
        if(!$inserir){
          $this->setError("Falha ao inserir registro.<br>Erro: 100620201642");
          return false;
        }

        $merge_tb_calc = [
          'origem_id' => $inserir->id,
          'tbl_origem' => $this->getModelEntity()->getTable()
        ];


        if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses))){
            $retorno['status'] = 'error';
            $retorno['submsg']='Falha ao inserir o registro. Erro: 031220192046';
            $retorno['msg']=$repo_calc_orcamento->getErrosFlatted();
            $hasErro = true;
            abort(500, $retorno['msg']);
            return false;
        }
        
        return true;
      }
    }
    public function listar(){
      // $select = $this->getModelEntity()->with([
      //   'getEvento'=>function($query){
      //     return $query;
      //   },
      //   'getTurma'=>function($query){
      //     return $query->with([
      //       'getTurno'=>function($query){
      //         return $query;
      //       }
      //     ]);
      //   }
      // ])->get()->toArray();
      // // dd($select[1]['qtd_hrs'] == 0);

      // for($i = 0; $i < count($select); $i++){
      //   $select[$i]['descricao_evento'] = $select[$i]['get_evento']['cdn_event'].' - '.$select[$i]['get_evento']['des_event'];
      //   $select[$i]['descricao_turma'] = $select[$i]['get_turma']['cdn_turma_trab'].' - '.$select[$i]['get_turma']['des_turma_trab'];
      //   $select[$i]['descricao_turno'] = $select[$i]['get_turma']['get_turno']['cdn_turno_trab'].' - '.$select[$i]['get_turma']['get_turno']['des_turno_trab'];
      //   $select[$i]['Horas'] = number_format($select[$i]['qtd_hrs'], 4, ',', '.');
      //   unset($select[$i]['get_evento']);
      //   unset($select[$i]['get_turma']);
      // }
      $data = DB::select("
                        select  
                        tbl_tv.id,
                        tbl_e.id evento_id,
                        tbl_t.id turma_id,
                        tbl_tv.qtd_hrs,
                        tbl_tv.empresa_id,
                        tbl_tno.id turno_id,
                        concat(tbl_e.cdn_event, ' - ', tbl_e.des_event ) descricao_evento, 
                        concat(tbl_t.cdn_turma_trab, ' - ', tbl_t.des_turma_trab ) descricao_turma,
                        concat(tbl_tno.cdn_turno_trab, ' - ', tbl_tno.des_turno_trab ) descricao_turno,
                        format (tbl_tv.qtd_hrs, 'N', 'pt-br') Horas,
                        c.id calc_orc_id,
                        tbl_tv.created_at,
                        tbl_tv.updated_at,
                        tbl_tv.created_by,
                        tbl_tv.updated_by,
                        institb_usuario.nome as created,
                        tbl_usu.nome as updated,
                        format (c.[jan_orcado], 'N', 'pt-br') jan_orcado,
                        format (c.[fev_orcado], 'N', 'pt-br') fev_orcado,
                        format (c.[mar_orcado], 'N', 'pt-br') mar_orcado,
                        format (c.[abr_orcado], 'N', 'pt-br') abr_orcado,
                        format (c.[mai_orcado], 'N', 'pt-br') mai_orcado,
                        format (c.[jun_orcado], 'N', 'pt-br') jun_orcado,
                        format (c.[jul_orcado], 'N', 'pt-br') jul_orcado,
                        format (c.[ago_orcado], 'N', 'pt-br') ago_orcado,
                        format (c.[set_orcado], 'N', 'pt-br') set_orcado,
                        format (c.[out_orcado], 'N', 'pt-br') out_orcado,
                        format (c.[nov_orcado], 'N', 'pt-br') nov_orcado,
                        format (c.[dez_orcado], 'N', 'pt-br') dez_orcado
                        
                        from tbl_turma_evento as tbl_tv
                        
                        left join tbl_turma tbl_t on tbl_t.id = tbl_tv.turma_id
                        left join tbl_turno tbl_tno on tbl_tno.id = tbl_t.turno_id
                        left join tbl_eventos tbl_e on tbl_e.id = tbl_tv.evento_id
                        left join institb_usuario on institb_usuario.id = tbl_tv.created_by
                        left join institb_usuario as tbl_usu on tbl_usu.id = tbl_tv.updated_by
                        inner join tbl_calc_orcamento c on c.origem_id = tbl_tv.id and tbl_origem = 'tbl_turma_evento'
      ");
      // dd("testeeee---->>>>", $data);


      


      return $data;
    }
}




 