<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Usuario;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class RepoUsuario extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Usuario';
    
      protected $form_rules=[
      					'nome'=>'required',
      					'email'=>'required|unique:institb_usuario,email',
						'funcionario_id'=>'required'
      				];

    protected $rules_msg=[
    					'nome.required'=>'O campo nome é obrigatório',
						'email.required'=>'O campo email é obrigatório',
						'email.unique'=>'E-mail já cadastrado',
						'funcionario_id.required'=>'O campo Funcionario é obrigatório'
						
						]; 
	public function update(array $data,$id,$attribute="id"){
		// dd("data usuario", $data);
		// $data['data_validade'] = Carbon::parse($data['data_validade'])->format('ymd');
		$this->form_rules['email'].=','.$id;
		
		return parent::update($data,$id,$attribute);
															
	}

	public function listar(){
		$tbl_funcionario = new Funcionario();
		$tbl_usuario = new Usuario();
		// $a=$this->allWith([
		// 	'getNumReg'=>function($query){}
		// ])->toArray();
		$a = $this->getModelEntity()
		->leftJoin($tbl_funcionario->getTable(), $this->getModelEntity()->getColunaAlias('funcionario_id'), $tbl_funcionario->getColunaAlias('id'))

		->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
         )
         ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $this->getModelEntity()->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
		 )
		 
		->select(
			$this->getModelEntity()->getColunaAlias('id'),
			$this->getModelEntity()->getColunaAlias('id_empresa'),
			$this->getModelEntity()->getColunaAlias('id_grupo'),
			$this->getModelEntity()->getColunaAlias('id_filial'),
			$this->getModelEntity()->getColunaAlias('id_grupo_acesso'),
			$this->getModelEntity()->getColunaAlias('id_permissao'),
			$this->getModelEntity()->getColunaAlias('id_grupo_empresarial'),
			$this->getModelEntity()->getColunaAlias('nome'),
			$this->getModelEntity()->getColunaAlias('senha'),
			$this->getModelEntity()->getColunaAlias('email'),
			$this->getModelEntity()->getColunaAlias('status'),
			$this->getModelEntity()->getColunaAlias('funcionario_id'),
			$this->getModelEntity()->getColunaAlias('usuario_dominio'),
			$this->getModelEntity()->getColunaAlias('data_validade'),
			$this->getModelEntity()->getColunaAlias('data_alt_senha'),
			$this->getModelEntity()->getColunaAlias('numero_dias_senha'),
			$this->getModelEntity()->getColunaAlias('tipo'),
			$this->getModelEntity()->getColunaAlias('api_token'),

			$tbl_funcionario->getColunaAlias('num_reg_func'),
			$tbl_funcionario->getColunaAlias('nome_funcionario'),
			$tbl_funcionario->getColunaAlias('cdn_funcionario'),

			DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),// HH:mm
			DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),

			DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('updated_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em"),
         	DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por")

		)
		->get()->toArray();

		
		for($i = 0; $i < count($a); $i++){
			
			// $a[$i]['num_reg_func'] = $a[$i]['get_num_reg']['num_reg_func'];
			// $a[$i]['nome_funcionario'] = $a[$i]['get_num_reg']['nome_funcionario'];
			// $a[$i]['cdn_funcionario'] = $a[$i]['get_num_reg']['cdn_funcionario'];
			$a[$i]['data_validade'] = $this->formataData($a[$i]['data_validade']);
			// $a[$i]['description_created_at'] = $a[$i]['created_at'] != null ? $this->formataData($a['created_at']) : '-';
         	// $a[$i]['description_updated_at'] = $a[$i]['updated_at'] != null ? $this->formataData($a['updated_at']) : '-';
			unset($a[$i]['get_num_reg']);

			if($a[$i]['tipo'] == 1){
				$a[$i]['Usuario'] = 'Desenvolvedor';
				$a[$i]['nome'] = $a[$i]['nome'];
			}
			elseif($a[$i]['tipo'] == 2){
				$a[$i]['Usuario'] = 'Administrador';
				$a[$i]['nome'] = $a[$i]['nome_funcionario'];
			}
			elseif($a[$i]['tipo'] == 3){
				$a[$i]['Usuario'] = 'Técnico';
				$a[$i]['nome'] = $a[$i]['nome_funcionario'];
			}
			elseif($a[$i]['tipo'] == 4){
				$a[$i]['Usuario'] = 'Comum';
				$a[$i]['nome'] = $a[$i]['nome_funcionario'];
			}
			else{
				$a[$i]['Usuario'] = '-';
			}
		}
		// dd('nbjshgknsdkjnf', $a);

		return $a;
	}

	public function formataData($data){
		if($data == null){
			 return '';
		}else{
			 $ano = substr($data, 0, 4);
			 $meses = substr($data, 5, 2);
			 $dia = substr($data, 8, 2);
			//  $data = $dia.'/'.$meses.'/'.$ano;
			 $data = $ano.'-'.$meses.'-'.$dia;
			 return $data;
		}
	}

	public function getPassord($func_id){
		$func = Funcionario::find($func_id);
		if(!$func){
			return $this->getModelEntity()->getDefaultPassword();
		}
		if(!$func->cpf){
			return $this->getModelEntity()->getDefaultPassword();
		}

		return $func->cpf;
	}

    public function updatePassword($newEncryptedPassword, $id){
		$atualizar = DB::update("update institb_usuario set senha = ? where id = ?", [$newEncryptedPassword, $id]);
		return is_numeric($atualizar) ? true : false ;
    }

}
