<?php

namespace App\Support\TreeTable;

use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;
use App\Support\TreeTable\CollumRender;

class AtmTreeTable
{
    private $matrix=[];
    private $matrix_original=[];
    private $settings=[];
    private $current_keys=[];
    private $current_record;
    private $merged_matrix=[];
    private $renderized_matrix=[];
    private $parent_row=[];
    /**
     * Lista com todas as chaves que ja foram adicionadas
     */
    private $already_keys=[]; 
    private $is_recursive=false;
    /**
     * 
     * @param type $settings
     *                  columns=>[[
     *                             from=>"id", //Obrigatorio campo corresponte ao da matriz de dadis
     *                              field_out=>"",  
     *                              
     *                             ]]
     * @param type $matrix
     */
    public function __construct($settings, &$matrix, $parent_row=null){
        $this->setMatrixOriginal($matrix)
            ->setSettings($settings)
            ->setMatrix($matrix)
            ->seParentRow($parent_row);
    }
    private function setMatrixOriginal($value){
       $this->matrix_original=$value;
       return $this;
   }
    private function setMatrix($value){
        $this->matrix=$value;
        return $this;
    }
    private function setSettings($value){
        $this->settings=$value;
        return $this;
    }
    private function setCurrentKeys($value){
        $this->current_keys=$value;
        return $this;
    } 
    private function setCurrentRecord($value){
        $this->current_record=$value;
        return $this;
    } 
    private function getMatrixOrinal(){ return $this->matrix_original; }
    private function getCurrentRecord(){ return $this->current_record;}    
    private function setMergedMatrix($value){ 
          $this->merged_matrix=$value;
          return $this;
    }
    private function genarateKeyByValues($keys_and_values=null){
        $k_v= is_null($keys_and_values)? $this->getKeysValues() : $keys_and_values;
        return Str::slug(implode("_",$k_v));
    }
    private function setAlReadyKeys($value){
        $this->already_keys=$value;
        return $this;
    }
    private function alReadyKeysClear($key=null){
        if(is_null($key)){
            return $this->setAlReadyKeys([]);
        }
        
        $already_keys=$this->getAlReadyKeys();
        $index= array_search($key, $already_keys);
        if($index===false){
            return $this;
        }
        Arr::forget($already_keys, $index);
        return $this->setAlReadyKeys($already_keys);
    }
    private function seParentRow($value){
        $this->parent_row=$value;
        return $this;                
    }
    private function setIsRecursive($value){
        $this->is_recursive=$value;
        return $this;
    }
    function isRecursive(){ return $this->is_recursive===true;}
    function isArlReadyKeys($key){
        if(in_array($key, $this->getAlReadyKeys())===false){
            return false;
        }
        return true;
    }
    function alReadyKeysAppend($key){
        if($this->isArlReadyKeys($key)===true){
            return false;
        }
        $already_keys=$this->getAlReadyKeys();
        $already_keys[]=$key;
        $this->setAlReadyKeys($already_keys);
        return true;
    }
    protected function getKeysValues($keys_p=null, $record_p=null){
        $record= $record_p? $record_p : $this->getCurrentRecord();
        $keys= $keys_p? $keys_p  : $this->getCurrentKeys();        
        return Arr::only($record, $keys); 
    }
    function getAlReadyKeys(){ return $this->already_keys;}
    function getRenderizedMatrix(){ return $this->renderized_matrix;}
    function getMergedMatrix(){ return $this->merged_matrix;}
    function getMatrix(){ return $this->matrix;}
    function getSettings(){ return $this->settings;}
    function getCurrentKeys(){ return $this->current_keys;}
    function geParentRow(){ return $this->parent_row;}
    function getParentFilter(){
        $settings=$this->getSettings();
        return isset($settings['parent_filter']) ? $settings['parent_filter'] : null; 
    }
    function hasFilter($settings=null){
        $settings=empty($settings) ? $this->getSettings() : $settings ;
        $has_filter=isset($settings['filter_data'])? $settings['filter_data'] : [];
        return empty($has_filter) ? false : $has_filter;
    }
    
    /**
     * Verifica se o current_record pertence a parent
     * @param type $parent_filter
     * @param type $row
     * @param type $parent_row
     */
    function isChildren($parent_filter=null,$row=null, $parent_row=null){
        $parent_filter=is_null($parent_filter)? $this->getParentFilter() : $parent_filter;
        return is_null($parent_filter)? true :
                $parent_filter(is_null($row) ? $this->getCurrentRecord() : $row, 
                                 is_null($parent_row) ? $this->geParentRow() : $parent_row);
        
    }
    function filteredDatasSettings($settings=null, $data=null){
        $settings=empty($settings) ? $this->getSettings() : $settings;
        $has_filter=$this->hasFilter($settings);
        $dados=$this->getDataFromSettings($settings, $data);
        
        if($has_filter===false){
            return $dados;
        }
        $instance=$this;
        return  Arr::where($dados,function($value) use($has_filter, $instance){
            
                    foreach($has_filter as $j=>$w){
                        if(!$w($value[$j])){
                            return false;
                        }
                    }
                return $instance->isChildren(null, $value, null);   
                //return true;
            });
        
    }
    function getDataFromSettings($settings=null, $data=null){
        if($this->isRecursive()){
            return $this->getMatrixOrinal();
        }
        
        $settings=empty($settings) ? $this->getSettings() : $settings ;
        $data=is_null($data)? $this->getMatrix() : $data;
        $dados_s=isset($settings['data']) ? $settings['data'] : $data;
        
        
        return $dados_s;
    }
    /**
     * 
     * @return type
     * @TODO ALUISIO FERREIRA DE SOUSA 16/11/2019
     * Melhorar:
     * - Caso o chidren tenha o seu proprio data ele não esta sendo usado esta sendo considerado
     * apenas o matrix_original. O que limita o metodo a processar apenas matriz plana 
     * - Criar rotina de excluir da matrix_original o item processado para reduzir o processamento e memoria para as interacoes seguintes 
     */
    public function render(){
        $retorno=[];
        $settings=$this->getSettings();  
        
        $matrix=$this->setMatrix($this->getDataFromSettings())
            ->setCurrentKeys($settings["keys"])//$settings["keys"]
           ->filteredDatasSettings();  
        $merged=$this->getMergedMatrix();
        
        if(count($matrix)==0){
           return $this->getMergedMatrix();
        }
        
        try{
            do{
                $key_atual_of_matrix=key($matrix);
                $row=$matrix[$key_atual_of_matrix];
                $chave_atual=$this->setCurrentRecord($row)->genarateKeyByValues();
                
                if(!$this->alReadyKeysAppend($chave_atual)){
                    continue;
                }

                $merged[]=["data"=>$this->processRow()];
                $index_atual=max(count($merged)-1,0);
                //$this->renderized_matrix[$chave_atual]=$this->processRow();    
                
                $children_settings= !isset($settings['children']) ? [] : $settings['children'];

                if(empty($children_settings)){
                    $this->setMergedMatrix($merged);
                    continue;
                }
                $this->setIsRecursive(false);

                if(isset($children_settings['is_recursive'])){
                    if($children_settings['is_recursive']===true){
                        $this->setIsRecursive(true);
                       $children_settings=$settings;
                    }                
                }
                //$key_atual_of_matrix
                /**
                 * @todo
                 * ::Remove oregistro atual da matriz para reduzir
                 * o tempo de pesquisa e memoria para proxima interacao
                 */
                //$this->removeFromMatrix();

                $children_data=$this->getMatrixOrinal(); //$this->filteredDatasSettings($children_settings);
                
                $children_instance=new AtmTreeTable($children_settings, $children_data, $row);
                $ch_dados=$children_instance->render();
                
                if(empty($ch_dados)===false){                   
                    $merged[$index_atual]["children"]=$ch_dados;
                }
            
                $this->setMergedMatrix($merged);

            }
            while(next($matrix));
        }
        catch(\Exception $e){
            dd($settings["keys"], array_keys($settings), $this->getMatrixOrinal(), $e);
        }
        
        return $this->getMergedMatrix();
    }
    private function processRow($row=null, $settings=null){
        $row_data=is_null($row)? $this->getCurrentRecord() : $row;
        $settings= is_null($settings) ? $this->getSettings() : $settings;
        $retorno=[];
        if(isset($settings['columns'])==false){
            abort(500, "A propriedade columns não foi configurada. Erro: 161120191033");
        }
        $columns=$settings['columns'];
        foreach ($columns as $k=>$coluna_atual){
            $coluna_obj=new CollumRender($coluna_atual, $row_data);
            $renderized_value=$coluna_obj->render($this->getMatrix());
            $key_out=$renderized_value->field_name;
            $retorno[$key_out]=$renderized_value->value;
        }
       return $retorno;
    }
    private function Order(){
        $array=$this->getMatrix();
        $instance=$this;
        $matrix=Arr::sort($array, function ($value) use($instance){
            return $instance->hasKeys(null, $value) ?  $this->getKeysValues($value, $instance->getCurrentKeys()) : $value;
        });
        $this->setMatrix($matrix);
    }
    private function removeFromMatrix($key=null,$matrix=null){
        $array=is_null($matrix) ? $this->getMatrix() : $matrix;
        Arr::forget($array, (is_null($key)? key($array) : $key));
        return $array;
    }
    function hasKeysAux($keys, $record_keys){ return count($record_keys) === count($keys); }
    /**
     * ::Verifica se as chaves existem no registro atual da matriz
     * @param ARRAY(indexed)|NULL $keys_p OPTIONAL Caso não seja informado será utilizado o @see getCurrentKyes() 
     * @param ARRAY(MIXED)|NULL  $record_p OPTIONAL Caso não seja informado será utilizado o @see getCurrentRecord()
     * @return BOOLEAN Se todas as todos os campos que compoem a chave primaria estiverem no registro atual retorna TRUE do contrario FALSE
     */
    private function hasKeys($keys_p=null, $record_p=null){        
        $record= $record_p? $record_p : $this->getCurrentRecord();
        $keys= $keys_p? $keys_p  : $this->getCurrentKeys();
        return $this->hasKeysAux($keys, array_keys($record, $keys));
    }
    /**
     * @TODO ALUISIO FERREIRA DE SOUSA 14/11/2019
     * Verifica se os valres do registro atual correpondem a chave primaria
     * @param type $keys_p
     * @param type $record_p
     * @return boolean
     */
    private function valuesIsPrimaryKey($keys_p=null, $record_p=null){
        $record= $record_p? $record_p : $this->getCurrentRecord();
        $keys= $keys_p? $keys_p  : $this->getCurrentKeys();
        
         if(!$this->hasKeys($keys, $record)){
            return false;
         }
        $array=$this->getMatrix();
       // $filtered =Arr::where($array,)
        return true;
    }

    public function listar(){

    $result = $this->getRepositoryOrModel()
                    ->allWith(['getGrupoTreeTableItem'=>function($query)
                    {
                        $query->with('getValores');    
                    },
                    'getColunas'
                    ]);    
                    
                    return $result;
                   
    $retorno = ['data' => []];    
    
    $first = $result->first();
   }
    
    
}
