<?php
namespace App\Support\TreeTable;
use Illuminate\Support\Str;

/**
 * Description of CollumRender
 *
 * @author ALUISIO FERREIRA DE SOUSA 
 * 16/11/2019 
 */
class CollumRender {
    private $column_instance;
    private $row_data;
    private $from; //::nome da propriedade que fornecerá o valor de saida;
    private $field_out;//::Obrigratoria será o nome da chave de saida
    private $field_out_render_func;//Função para gerar o nome da coluna de saida;
    /**
     * Função para processar o valor de saida. 
     * Na função sempre serao passados os seguintes parametros:
     * $row_data: Valores da linha atual
     * $value: valor da coluna atual ou um valor informado pelo usuario, 
     * matrix: matriz com todas as linhas(Nao processadas ainda)
     */
    private $render_value;
    function __construct($p_column_settings, $values){
        $this->setColumnInstance($p_column_settings)
                ->setRowData($values);
    }
    private function setColumnInstance($value){
        
        if(!isset($value['field_out'])){
            abort('500', 'A propriedade field_out não foi informada. Erro: 161120191202');
        }
        
        $this->column_instance=$value;
        
        return $this->setParams();
    }
    private function setParams(){
        
        $instance=!$this->hasInstance() ? [] : $this->getColumnInstance();
        $fields=['from','field_out', 'render_value','field_out_render_func'];
        foreach($fields as $field){
            $call='set'.Str::camel($field);
            $this->{$call}(!isset($instance[$field]) ? null : $instance[$field] );            
        }
        
        return $this;
    }
    private function setRowData($value){
        $this->row_data=$value;
        return $this;
    }
    private function setFrom($value){
        $this->from=$value;
        return $this;
    }
    private function setFieldOutRenderFunc($value){
        $this->field_out_render_func=$value;
        return $this;
    }
    function getFrom(){ return !$this->from ? $this->getFieldOut() : $this->from; }
    private function setFieldOut($value){
        $this->field_out=$value;
        return $this;
    }
    function getFieldOut(){ return $this->field_out;}
    private function setRenderValue($value){
        $this->render_value= is_string($value)? trim($value) : $value;
        return $this;
    }
    function getRenderValue(){ return is_null($this->render_value) ? null : $this->render_value;}
    function getFieldOutRenderFunc(){ return  $this->field_out_render_func;}
    function getRowData(){ return $this->row_data; }
    function hasRowData(){ return empty($this->row_data)? false : true; }
    function getColumnInstance(){ return $this->column_instance;}
    function hasInstance(){ return !$this->column_instance ? false : true; }
    function getValue(){
        $retorno=null;
        
        if($this->hasRowData()===false){
            goto saida;
        }
        
        $rd=$this->getRowData();
        $key_return=$this->getFrom();
        
        if(!isset($rd[$key_return])){
          goto saida;
        }
        
        $retorno=$rd[$key_return];
      
        saida:
            return $retorno;
    }
    /**
     * $row_data: Valores da linha atual
     * $value: valor da coluna atual ou um valor informado pelo usuario, 
     * matrix: matriz com todas as linhas(Nao processadas ainda)
     */
    function render($matrix=[]){
        $value=null;
        $extra_data=[];
        
        $field_out_render=$this->getFieldOutRenderFunc();
        $field_name=is_null($field_out_render)===false?
            $field_out_render($this->getRowData(), $this->getValue(), $matrix, $extra_data)
            : $this->getFieldOut();
        
        
        if(!$this->getRenderValue()){
            $value=$this->getValue();
            goto saida;
        }
        
        $func=$this->getRenderValue();
        
        
        $value=$func($this->getRowData(), $this->getValue(), $matrix, $extra_data);
       
             
        
        saida:
        return (object)["field_name"=>$field_name, 'value'=>$value];
    }
}
