<?php
use Illuminate\Support\Str;

if (!function_exists('add_mask')) {
  function add_mask($value, $mask, $autocomplete = false, $pad_type = STR_PAD_LEFT) {

    $len_val = strlen($value);
    $len_mask = strlen(preg_replace('/[^9aA#]/', '', $mask));

    if ($len_val === $len_mask) {
      $result = '';

      $arr_mask = str_split($mask);
      $arr_value = str_split($value);

      $x = 0;
      for($i = 0, $j = count($arr_mask); $i < $j; $i++) {

        if ($arr_mask[$i] === '9' && is_numeric($arr_value[$x])) {
          $result .= $arr_value[$x];
          $x++;
        }
        elseif ($arr_mask[$i] === '#' && preg_match('/[0-9a-zA-Z]/', $arr_value[$x])) {
          $result .= $arr_value[$x];
          $x++;
        }
        elseif (($arr_mask[$i] === 'A' || $arr_mask[$i] === 'a') && preg_match('/[a-zA-Z]/', $arr_value[$x])) {
          $result .= $arr_value[$x];
          $x++;
        }
        elseif (!preg_match('/[9aA#]/', $arr_mask[$i])) {
          $result .= $arr_mask[$i];
        }
        else {
          throw new BadMethodCallException('Caracter invalido');
        }
      }
      return $result;
    }
    else {
      if ($autocomplete === false) {
        throw new BadMethodCallException('Tamanho da mascara deve ser igual a do valor');
      }
      else {
        return add_mask(str_pad($value, $len_mask, $autocomplete, $pad_type), $mask);
      }
    }
  }
}

if (!function_exists('remove_mask')) {
  function remove_mask($value, $mask){

    if (strlen($value) === strlen($mask)) {
      $result = '';

      $arr_mask = str_split($mask);
      $arr_value = str_split($value);

      for($i = 0, $j = count($arr_mask); $i < $j; $i++) {

        if ($arr_mask[$i] === '9' && is_numeric($arr_value[$i])) {
          $result .= $arr_value[$i];
        }
        elseif ($arr_mask[$i] === '#' && preg_match('/[0-9a-zA-Z]/', $arr_value[$i])) {
          $result .= $arr_value[$i];
        }
        elseif (($arr_mask[$i] === 'A' || $arr_mask[$i] === 'a') && preg_match('/[a-zA-Z]/', $arr_value[$i])) {
          $result .= $arr_value[$i];
        }
        elseif (!preg_match('/[9aA#]/', $arr_mask[$i])) {
        }
        else {
          throw new BadMethodCallException('Caracter invalido');
        }
      }
      return $result;
    }
    else {
      throw new BadMethodCallException('Tamanho da mascara deve ser igual a do valor');
    }

  }
}

if (!function_exists('add_mask_cnpj')) {
  function add_mask_cnpj($value) {
    return add_mask($value, '99.999.999/9999-99');
  }
}

if(!function_exists('format_plural')){

  function format_plural($count, $singular, $plural, $args = array(), $options = array()) {
    if ($count == 1) {
      return isset($options['return_formated']) ? ('1 '.$singular) : $singular;
    }else{
      return isset($options['return_formated']) ? ($count.' '.$plural) : $plural;
    }
  }
}

function truncate_text($texto, $limit, $sufix='...'){
    if(strlen($texto)<=$limit){
        return $texto;
    } 
    return (substr($texto,0,$limit)).$sufix;
}

/**
* Extrai de um date_interval String(ex.: 1 Day) o nome do intervalo
* @param STRING $str_interval é esperada uma string que represente um formato de intervalo de data. Obs o intervalo tem que ser apenas de uma granulação. não pode ser algo como 1 WEEK 3 DAYS tem que ser 1 week  
* 
* @return STRING caso a str_interval seja valida é retornado uma string ( Ex; Week) se não o retorno é uma string vazia
*/
function extract_interval_name($str_interval){
    $a=explode(' ', $str_interval);
    $r='';
    if(isset($a[1])){
        $b=get_time_scale_by_name($a[1]);
        return ($b>0)? $a[1] : $r;
    }
    return $r;
}
function get_time_scale_by_name($name='sec'){
  switch( strtolower($name)){
    case 'y': case 'year': case 'years': case 'ano':  case 'anos':
     $retorno=31536000;
    break;
    case 'm': case 'month': case 'months': case 'mês':  case 'meses':
     $retorno=2592000;
    break;
    case 'w': case 'week': case 'weeks': case 'semana':  case 'semanas':
     $retorno=604800;
    break;
    case 'd': case 'day': case 'days': case 'dia':  case 'dias':
     $retorno=86400;
    break;
    case 'h': case 'hour': case 'hours': case 'hora':  case 'horas':
     $retorno=3600;
    break;
    case 'i': case 'min': case 'minutes': case 'minuto':  case 'minutos':
     $retorno=60;
    break;
    case 's': case 'sec': case 'seconds': case 'segundo':  case 'segundos':
     $retorno=1;
    break;
    default :
     $retorno=0;
    break; 
  }
  return $retorno;
}
function translate_time_unit(){
    
}
function format_interval($interval, $granularity = 2){
  $units = array(
    ' year| years' => 31536000,
    ' month| months' => 2592000,
    ' week| weeks' => 604800,
    ' day| days' => 86400,
    ' hour| hours' => 3600,
    ' min| min' => 60,
    ' sec| sec' => 1
  );
  $output = '';
  foreach ($units as $key => $value) {
    $key = explode('|', $key);
    if ($interval >= $value) {
      $div=floor($interval / $value);
      $formatado=format_plural($div, $key[0],$key[1], array(), array('return_formated'=>true));
      $output .= ($output ? ' ' : '') .$formatado ;
      $interval %= $value;
      if($granularity==$retorno_em){
         break;
      }
      $granularity--;
    }
    if ($granularity == 0) {
      break;
    }
  }
  return $output ? $output : '0 sec'; //t('0 sec', array(), array('langcode' => $langcode));
}
/**
* Verifica se uma STRING|INT corresponde a um minuto valido 00 á 59.
* @param STRING|INT $minuto  STRING ou INT que represente os minutos. Quando valor for menor que 10 deverá ter o 0(Zero) a esquerda.
* 
* @return TRUE ou FALSE
*/
function is_minuto($minuto){
	if(!preg_match('#^[0-5][0-9]{1,2}?$#i',$minuto)){
		return false;
		
	}
	return true;
}
/**
* Verifica se uma string é uma hora valida do formato 24 com zero a esquerda em numeros menores que 10
* @param INT String $hora  
* 
* @return TRUE ou FALSE
*/
function is_hora($hora){
	if(!preg_match('#^[0-1][0-9]|[2][0-3]{1,2}$#i',$hora)){
		return false;		
	}
	return true;
}
function get_client_ip() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if(isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}
function get_user_agent(){
    return  isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;
}
function pega_mes($mes_atual, $qtd){
		
		if($qtd == 0){
			$mes = $mes_atual;
		}
		elseif($qtd == 1){
			if($mes_atual == '01'){
				$mes = "12";	
			}else{
				$mes = $mes_atual - 1;
			}
		}
		elseif($qtd == 2){
			if($mes_atual == '01'){
				$mes = "11";	
			}elseif($mes_atual == '02'){
				$mes = "12";	
			}else{
				$mes = $mes_atual - 2;
			}
		}
		elseif($qtd == 3){
			if($mes_atual == '01'){
				$mes = "10";	
			}elseif($mes_atual == '02'){
				$mes = "11";	
			}else{
				$mes = $mes_atual - 3;
			}
		}
		elseif($qtd == 4){
			if($mes_atual == '01'){
				$mes = "09";	
			}elseif($mes_atual == '02'){
				$mes = "10";	
			}else{
				$mes = $mes_atual - 4;
			}
		}
		
		switch($mes){
			
			case "01": $mes_es = "JAN";
						break;
			case "02": $mes_es = "FEV";
						break;
			case "03": $mes_es = "MAR";
						break;
			case "04": $mes_es = "ABR";
						break;						
			case "05": $mes_es = "MAI";
						break;
			case "06": $mes_es = "JUN";
						break;
			case "07": $mes_es = "JUL";
						break;
			case "08": $mes_es = "AGO";
						break;
			case "09": $mes_es = "SET";
						break;		
			case "10": $mes_es = "OUT";
						break;			
			case "11": $mes_es = "NOV";
						break;			
			case "12": $mes_es = "DEZ";
						break;												
																										
		}
		
		return $mes_es;
	}
if (!function_exists('dias_uteis')) {
  function dias_uteis(DateTime $data_ini, DateTime $data_fim, $feriados = array(), $sabados = false) {
    $ini = clone $data_ini;
        $uteis = 0;

    while ($ini->getTimestamp() <= $data_fim->getTimestamp()) {

      $dS = $ini->format('w');

      if ($dS != "0" && ($dS != "6" || $sabados)) {

        if (!empty($feriados)) {
          if (array_search($ini->format('d/m/Y'), $feriados) === false) {
            $uteis++;
          }
        }
        else {
          $uteis++;
        }
      }
      $ini->add(new DateInterval('P1D'));
    }

    return $uteis;
  }
}
if (!function_exists('ultimo_dia_mes')) {
  function ultimo_dia_mes($mes, $ano = null) {
    if (empty($ano)) {
      $ano = date('Y');
    }

    return date("t", mktime(0,0,0,$mes,'01',$ano));
  }
}
if(!function_exists('validateEan13')){
 function validateEan13($barcode)
{
    // check to see if barcode is 13 digits long
    if (!preg_match("/^[0-9]{13}$/", $barcode)) {
        return false;
    }

    $digits = $barcode;

    // 1. Add the values of the digits in the 
    // even-numbered positions: 2, 4, 6, etc.
    $even_sum = $digits[1] + $digits[3] + $digits[5] +
                $digits[7] + $digits[9] + $digits[11];

    // 2. Multiply this result by 3.
    $even_sum_three = $even_sum * 3;

    // 3. Add the values of the digits in the 
    // odd-numbered positions: 1, 3, 5, etc.
    $odd_sum = $digits[0] + $digits[2] + $digits[4] +
               $digits[6] + $digits[8] + $digits[10];

    // 4. Sum the results of steps 2 and 3.
    $total_sum = $even_sum_three + $odd_sum;

    // 5. The check character is the smallest number which,
    // when added to the result in step 4, produces a multiple of 10.
    $next_ten = (ceil($total_sum / 10)) * 10;
    $check_digit = $next_ten - $total_sum;

    // if the check digit and the last digit of the 
    // barcode are OK return true;
    if ($check_digit == $digits[12]) {
        return true;
    }

    return false;
}
}
 /*
     * Remove os acentos 
     *  
     */
if(!function_exists('removeAcentos')){
    function removeAcentos($str)
    {
        if (empty($str)) {
            return $str;
        }
        
        $string = trim($str);
        $singleByteString = mb_convert_encoding(mb_strtolower($string, 'UTF-8'), 'ISO-8859-1', 'UTF-8');
        $noAccentsString = strtr($singleByteString, utf8_decode('ãâáàäéèêëíìïîóõòôöúùüûçñ'), 'aaaaaeeeeiiiiooooouuuucn');
        $noAccentsString = preg_replace('/[^\w\s\(\)\[\]\-\.\/\'"`´\@\=\+\*\%\$\!]/i', '', $noAccentsString);
        //return mb_strtoupper(mb_convert_encoding($noAccentsString, 'UTF-8', 'ISO-8859-1'), 'UTF-8');
        return mb_convert_encoding($noAccentsString, 'UTF-8', 'ISO-8859-1');
    }
}  

 function removeAcentosERP($str)
    {
        if (empty($str)) {
            return $str;
        }
        
        $string = trim($str);
        $singleByteString = mb_convert_encoding(mb_strtolower($string, 'UTF-8'), 'ISO-8859-1', 'UTF-8');
        $noAccentsString = strtr($singleByteString, utf8_decode('ãâáàäéèêëíìïîóõòôöúùüûçñ'), 'aaaaaeeeeiiiiooooouuuucn');
        $noAccentsString = preg_replace('/[^\w\s\(\)\[\]\-\.\/\'"`´\@\=\+\*\%\$\!]/i', '', $noAccentsString);
        return $noAccentsString;//, 'UTF-8', 'ISO-8859-1');
    }

    if(!function_exists('find_mult_in_keys')){
        function find_mult_in_keys($query, $ids){
            foreach ($ids as $key=>$value) {
                $query->where($key, '=', $value);
            }
            return $query;
       }
    }
    
    if(!function_exists('response_with_token')){
        function response_with_token($user){
            $token = json_encode($user);
            $hash_token= hash("sha256", time());
            $expire=31536000;
            $accesss_token="lalalalalal";
            $refresh_token="xxaajkhglkhklhl";   
             $objct=["value"=>"",
                "mac"=>"",
                "iv"=>"",
                "token_type"=>"Bearer",
                "expires_in"=> $expire,
                "access_token"=>true,   
                "refresh_token"=>$refresh_token,
                "user"=>$user
            ];
             $response=new \Illuminate\Http\Response(); 
             return $response->withHeaders($objct)->content(json_encode(['uuu'=>'ssas', 'ass'=>'564564654']));
        }
        
    }
    function getSodiumCryptoSecretboxNoncebytes(){
        return SODIUM_CRYPTO_SECRETBOX_NONCEBYTES;
       // return 24;
    }
    
    function getSodiumSecretboxKeyBytes(){
       return SODIUM_CRYPTO_SECRETBOX_KEYBYTES;
       // return 64;
    }

    /**
     * @author Samuel Domingos de Lima 
     * @param 
     */
  function convertDecimalEn(array $number){
     foreach ($number as $key => $value) {
      $number[$key] =  str_replace('.','',$value); 
      $number[$key] =  str_replace(',','.',$number[$key]); 
    } 
    return $number;
  }

  function validaArray($array){
    return (convertDecimalEn(array('number'=>$array[0]['salario'])));
    // for ($i=0; $i < count($array) ; $i++) { 
       
    // }
  }
    
   function safeDecrypt(string $encrypted, string $key = null){
            $key = $key ? $key : getSodiumCryptoKey();//hex2bin(getSodiumCryptoKey());
            $decoded    = base64_decode($encrypted);
            $nonce      = mb_substr($decoded, 0, getSodiumCryptoSecretboxNoncebytes(), '8bit');
            $ciphertext = mb_substr($decoded, getSodiumCryptoSecretboxNoncebytes(), null, '8bit');
            $plain = sodium_crypto_secretbox_open($ciphertext, $nonce, $key);
             
            if (!is_string($plain)) {
                throw new \RangeException('Falha ao decriptar string. 300820191436');
            }
            sodium_memzero($ciphertext);
            sodium_memzero($key);
            return $plain;
    }         
   function safeEncrypt(string $message, string $key = null){
        
        $key = $key ? $key : getSodiumCryptoKey();
        
        if (($len_key=mb_strlen($key, '8bit')) !== getSodiumSecretboxKeyBytes()) {
                throw new \RangeException('Key is not the correct size (must be 32 bytes).'.$len_key.'--'.getSodiumSecretboxKeyBytes());
        }
        
        $nonce = random_bytes(getSodiumCryptoSecretboxNoncebytes());
        $str_bin=$nonce.sodium_crypto_secretbox($message, $nonce, $key);
        sodium_memzero($message);
        sodium_memzero($key);
        $cipher =base64_encode($str_bin);
        return $cipher;
    }
   function getSodiumCryptoKey(){
     
     $len= getSodiumSecretboxKeyBytes(); // env('SODIUM_CRYPTO_KEY_LENGTH', 64);  
     $sodium_64=env('SODIUM_CRYPTO_KEY_64', 'nXSE8OmIE5uzm4XJyDXHTHJllyUtnANfDi6kJV14ZGO2kxCtLCdt0eFB0SINPTJq');
     $sodium_32=env('SODIUM_CRYPTO_KEY_32', 'E8OmIE5uzm4XJyDXHTHJllyUtnANfDi6');
     
     return $len==32 ? $sodium_32 : $sodium_64;
    }

     function formatarNumeroPtBr($number,$decimal=2){
        return number_format($number,$decimal,',','.');

    } 
    
    function validaCPF($cpf) {
      //https://gist.github.com/rafael-neri/ab3e58803a08cb4def059fce4e3c0e40
      // Extrai somente os números
      $cpf = preg_replace( '/[^0-9]/is', '', $cpf );
       
      // Verifica se foi informado todos os digitos corretamente
      if (strlen($cpf) != 11) {
          return false;
      }
  
      // Verifica se foi informada uma sequência de digitos repetidos. Ex: 111.111.111-11
      if (preg_match('/(\d)\1{10}/', $cpf)) {
          return false;
      }
  
      // Faz o calculo para validar o CPF
      for ($t = 9; $t < 11; $t++) {
          for ($d = 0, $c = 0; $c < $t; $c++) {
              $d += $cpf{$c} * (($t + 1) - $c);
          }
          $d = ((10 * $d) % 11) % 10;
          if ($cpf{$c} != $d) {
              return false;
          }
      }
      return true;
  
  }
  function repDecimal($number){

     return $number =  str_replace('.',',',$number);

  }
  function repDecimalSubtr($number){
    $novo_salario=str_replace('.',',',$number);
    return substr($novo_salario,0,-3);
  }
  function convertDec($number){
    
     $number =  str_replace('.','',$number); 
     $number =  str_replace(',','.',$number); 
   return $number;
 }
 function getMonthName($m)
 {
     switch ($m) {
        case '01': case 1: 
            return 'janeiro';
            break;
        case '02': case 2:
            return 'fevereiro';
            break;
        case '03': case 3:
            return 'março';
            break;
        case '04': case 4:
            return 'abril';
            break;
        case '05': case 5:
            return 'maio';
            break;
        case '06': case 6:
            return 'junho';
            break;
        case '07': case 7:
            return 'julho';
            break;
        case '08': case 8:
            return 'agosto';
            break;
        case '09': case 8:
            return 'setembro';
            break;
        case '10': case 10:
            return 'outubro';
            break;
        case '11': case 11: 
            return 'novembro';
            break;
        case '12': case 12:
            return 'dezembro';
            break;
    }
    
}
/**
 * ALUISIO FERREIRA DE SOUSA
 * @param type $birthday Ex: 17/10/1982
 * @return string Ex: 1982-10-17
 * @TODO não verifica se tem hora na string ou se a string esta no formato correto;
 */
function formatBirthday($birthday){
    
    $birthday = str_replace('\\', '', $birthday);
    $birthday = explode('/', $birthday);
    $birthday = sprintf("%02s", $birthday[2]).'-'.sprintf("%02s", $birthday[0]).'-'.sprintf("%02s", $birthday[1]);

    return $birthday;
}
function formatCurrency($number){
    return 'R$ '.number_format($number, 2, ',', '.');
}

function unformatCurrency($currency){
    $out = str_replace('R$ ', '', $currency);
    $out = str_replace('.', '', $out);
    $out = str_replace(',', '.', $out);

    return $out;
}
function getBrowser(){
    
    $u_agent = $_SERVER['HTTP_USER_AGENT'];
    $bname = 'Unknown';
    $platform = 'Unknown';
    $version = "";
    // First get the platform?
    if (preg_match('/linux/i', $u_agent)) {
        $platform = 'linux';
    } else if (preg_match('/macintosh|mac os x/i', $u_agent)) {
        $platform = 'mac';
    } else if (preg_match('/windows|win32/i', $u_agent)) {
        $platform = 'windows';
    }
    // Next get the name of the useragent yes seperately and for good reason
    if (preg_match('/MSIE/i', $u_agent) && !preg_match('/Opera/i', $u_agent)) {
        $bname = 'Internet Explorer';
        $ub = "MSIE";
    } else if (preg_match('/Firefox/i', $u_agent)) {
        $bname = 'Mozilla Firefox';
        $ub = "Firefox";
    } else if (preg_match('/Chrome/i', $u_agent)) {
        $bname = 'Google Chrome';
        $ub = "Chrome";
    } else if (preg_match('/Safari/i', $u_agent)) {
        $bname = 'Apple Safari';
        $ub = "Safari";
    } else if (preg_match('/Opera/i', $u_agent)) {
        $bname = 'Opera';
        $ub = "Opera";
    } else if (preg_match('/Netscape/i', $u_agent)) {
        $bname = 'Netscape';
        $ub = "Netscape";
    }
    // finally get the correct version number
    $known = array('Version', $ub, 'other');
    $pattern = '#(?<browser>' . join('|', $known) . ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
    if (!preg_match_all($pattern, $u_agent, $matches)) {
        // we have no matching number just continue
    }
    // see how many we have
    $i = count($matches['browser']);
    if ($i != 1) {
        //we will have two since we are not using 'other' argument yet
        //see if version is before or after the name
        if (strripos($u_agent, "Version") < strripos($u_agent, $ub)) {
            $version = $matches['version'][0];
        } else {
            $version = $matches['version'][1];
        }
    } else {
        $version = $matches['version'][0];
    }
    // check if we have a number
    if ($version == null || $version == "") {
        $version = "?";
    }

    return array('userAgent' => $u_agent,
        'name' => $bname,
        'version' => $version,
        'platform' => $platform,
        'pattern' => $pattern);
}
function getClassName($object){
    return strtolower((new \ReflectionClass($object))->getShortName());
 }
 /**
  * 
  * @param type $str_date
  */
 function truncate_date_str($str_date, $with_hour=false){
    $str_date = substr(date_parse_from_js($str_date, $with_hour), 0, 19);
    $str_date .= strlen($str_date) < 19 ? " 00:00:00" : "";
    if($with_hour!==true){
        $arr_dt=explode(' ', $str_date);
        return $arr_dt[0];
    }
    return $str_date;
 }
 /**
  * 
  * @param type $str_data EX: 2020-10-15T03:19:00.000Z;
  * @return type
  */
 function date_parse_from_js($str_data, $with_hour=true){
     $dt=explode('T', trim($str_data));
     if($with_hour!==true){
         return $dt[0];
     }
     $hr_min=isset($dt[1])? trim($dt[1]) : '';
     $hora_minutos= !empty($hr_min) ? substr($hr_min,0, min(strlen($hr_min)-5, strlen($hr_min))) : '';
     return $dt[0]." ".$hora_minutos;
 }
 /**
     * @param STRING $str_date Recebe uma string no formato Y-m-d
     * @return STRING devolve uma string data no formato d/m/Y
     * @TODO Necessario mais tratativas
     */
 
  function dateToBrFormat($str_date, $format='d/m/Y', $return_ob=false){
     $dt_str=truncate_date_str($str_date);
     $a = \DateTime::createFromFormat('Y-m-d', $dt_str);
     if($return_ob===true){
         return $a;
     }
     return $a === false ? $str_date : $a->format($format);
}
function getLongDate($date){
    $date = strtotime($date);
    $date = date('d', $date).' de '.getMonthName(date('m', $date)).', '.date('Y', $date);

    return $date;  
}
function mesesValidacao($dados){
  //dd($dados);
  $meses=array(
            floatval($dados['jan_orcado']),floatval($dados['fev_orcado']),floatval($dados['mar_orcado']),floatval($dados['abr_orcado']),
            floatval($dados['mai_orcado']),floatval($dados['jun_orcado']),floatval($dados['jul_orcado']),floatval($dados['ago_orcado']),
            floatval($dados['set_orcado']),floatval($dados['out_orcado']),floatval($dados['nov_orcado']),floatval($dados['dez_orcado']),
            );
            //dd($meses);
            $atual = 1;
            $anterior = 0;
            $conta = 0;
            $conta_else = 0;
            for($atual = 1; $atual < count($meses); $atual++){
                $anterior = $atual - 1; 
                //dd("meses",$meses[10],"meses2",$meses[11]);
                if($meses[$anterior] > $meses[$atual]){
                  //dd("caiu if");
                  $conta++;
                }
                else{
                  //dd("caiu else");
                  $conta_else++;
                }
            }
            //dd($conta,$conta_else,$atual,$anterior);
            if($conta == 0){
              return true;
            }
            else{
             return false;
            }
}
function validacaoIndice($dados){
  //dd($dados);
  $meses=array(
            floatval($dados['jan_indice']),floatval($dados['fev_indice']),floatval($dados['marc_indice']),floatval($dados['abril_indice']),
            floatval($dados['maio_indice']),floatval($dados['jun_indice']),floatval($dados['jul_indice']),floatval($dados['agost_indice']),
            floatval($dados['set_indice']),floatval($dados['out_indice']),floatval($dados['nov_indice']),floatval($dados['dez_indice']),
            );
            //dd($meses);
            $atual=1;
            $anterior=0;
            $conta=0;
            $conta_else=0;
            for($atual=1;$atual<count($meses);$atual++){
               $anterior=$atual-1;
                //dd("meses",$meses[2],"meses2",$meses[1]);
                if($meses[$anterior] > $meses[$atual]){
                  //dd("caiu if");
                  $conta++;
                }else{
                  //dd("caiu else");
                  $conta_else++;
                } 
            }
            //dd($conta,$conta_else,$atual,$anterior);
            if($conta==0){
              return true;
            }
            else{
             return false;
            }
}

function tirarAcentos($string){
  return preg_replace(array("/(á|à|ã|â|ä)/","/(Á|À|Ã|Â|Ä)/","/(é|è|ê|ë)/","/(É|È|Ê|Ë)/","/(í|ì|î|ï)/","/(Í|Ì|Î|Ï)/","/(ó|ò|õ|ô|ö)/","/(Ó|Ò|Õ|Ô|Ö)/","/(ú|ù|û|ü)/","/(Ú|Ù|Û|Ü)/","/(ñ)/","/(Ñ)/","/(ç)/","/(Ç)/"),explode(" ","a A e E i I o O u U n N c C"),$string);
}

// function mesesNull($dados,$tipo){
  

//   if($tipo==1){
   
//     $meses=array(
//       ($dados['jan_indice']),($dados['fev_indice']),($dados['marc_indice']),($dados['abril_indice']),
//       ($dados['maio_indice']),($dados['jun_indice']),($dados['jul_indice']),($dados['agost_indice']),
//       ($dados['set_indice']),($dados['out_indice']),($dados['nov_indice']),($dados['dez_indice']),
//       );
//   }
//   else{
//     $meses=array(
//       ($dados['jan_orcado']),($dados['fev_orcado']),($dados['mar_orcado']),($dados['abr_orcado']),
//       ($dados['mai_orcado']),($dados['jun_orcado']),($dados['jul_orcado']),($dados['ago_orcado']),
//       ($dados['set_orcado']),($dados['out_orcado']),($dados['nov_orcado']),($dados['dez_orcado']),
//       );
//   }
//   //dd($meses);
//   for($i=0;$i<count($meses);$i++){
//     if($meses[$i]<0){
//       return false;
//     }
//     return true;
//   }
            
// }
function monetarioVirgula(&$valor){
  $virgula = strstr($valor,',');
  
  if($virgula){
    $ponto = strstr($valor,'.');
    if($ponto){
      $valor_1 = str_replace( '.','',$valor);
      $valor_2 = str_replace( ',','.',$valor_1);
      $valor = $valor_2;
      
      return $valor;
    }
    else{
      $valor_2_ponto = str_replace( ',','.',$valor);
      $valor = $valor_2_ponto;
      return $valor;
    }
  }
  else{
    return intval($valor,10);
  }
}
function zeroInicial(&$valor){
  $ponto = strpos($valor,'.');
  if($ponto == 0){
    $ponto = 0 + $valor;
    return $ponto;
  }
}
function formataMonetarioQuatro($valor){
  $dado = $valor;
  
  if($valor == '0,00'){
    return $valor;
  }
  if(substr($valor,-2) == '00'){
    if( (substr($valor,-3) == ',00') ){
      return $valor;
    }
    $tamanho = strlen($dado);
    $size = $tamanho-2;
    $valor = substr($dado, 0, $size);
    return $valor;
  }else{
    return $valor;
  }
}
function formataData($data){
  if($data == null){
      return '-';
  }
  $ano = substr($data, 0, 4);
  $mes = substr($data, 5, 2);
  $dia = substr($data, 8, 2);
  return $dia.'/'.$mes.'/'.$ano;
}
function insereValorArray(Array &$array, Array $colunas){
	foreach($colunas as $col){
		if(array_key_exists($col, $array) == false || $array[$col] == null){
		$array[$col] = 0;
		}
    }
}