<?php

namespace App\Core\Http\Controllers\Auth;


use App\Core\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

use Auth;
//use  Illuminate\Session\Store;
use Session;
use Symfony\Component\HttpFoundation\Session\SessionBagInterface;
use DB;
use Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cache;
use Carbon\Carbon;

use App\Core\Entities\TblgLog;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

   
    /**
     * Create a new controller instance.
     *
     * @return void
     */
  
    
     /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    //use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = 'home';
    private $guard_name='insti';
    
    function getGuardname(){ 
            return 'insti';
        //return $this->getGuardByServer()!=$this->guard_name? 'INVALID_GUARD_FOR_THIS_SERVER' : $this->guard_name; 
        
    }
    private function logoutAction(){
        Session::flush();
        Auth::guard($this->getGuardname())->logout();
        return $this;
    }
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    public function login(Request $request){       
      
        $fail_json=function(){
            return response()->json(['status'=>'error', 'msg'=>'É necessário efetuar o login',
                                    'submsg'=>'Recarregue a página. Os dados não salvas serão perdidas. Erro: 040520191800' ],
                        301);
        };
        $fail_view=function(){ 
            $keys=csrf_field();
            //    return 'mostrando a tela de login'.$keys;
            return view('auth.login'); 
            
        };
        $okJson=function(){
            return response()->json(['status'=>'success', 
                                    'msg'=>'Login efetuado com successo',
                                    'submsg'=>'Bem-vindo.',
                                    'dados'=>[]
                                    ],
                        200);
        };
        $okView=function(){ return redirect('/home'); };
        
        if((!$request->ajax() && !$request->wantsJson())){
            $ok=$okView;
            $fail=$fail_view;
        }
        else{
            $ok=$okJson;
            $fail=$fail_json;
        }
        
         return Auth::check() ? $ok(): $fail();
    }
    
   public function logout(){
       $this->logoutAction();
	return redirect('login');
    }

    public function postLogin(Request $request){
        
        Session::flush();
        $retorno=$this->getArrayRetornoDefault();        
        $http_code=500;
        $credentials = request(['email', 'password']);
        
       $login=$credentials['email'];
       $password=$credentials['password'];
        
        if(empty($login)){
           $retorno['msg']='Preencha o campo email';
           $retorno['submsg']='Erro: 300820191205';
           goto saida;
        }
        if(empty($password)){
           $retorno['msg']='Preencha o campo senha';
           $retorno['submsg']='Erro: 300820191206';
           goto saida;
        }
        
        $logou=auth()->guard($this->getGuardname())->attempt($credentials);
       
        if(!$logou){
           $retorno['msg']='Usuário e/ou senha invalido';
           $retorno['submsg']='Erro: 300820191206';
           $http_code=301;
           goto saida;
        }
               
        $user = Auth::guard($this->setCurrentGuard()->getGuardname())->user();
        $retorno['status']='success';
        $retorno['msg']='Login efetuado com sucesso!';
        $retorno['submsg']='Bem vindo.';
        $retorno['dados']=['api_authorizations'=> safeEncrypt(json_encode($user->getTokenObject())), 
                           'user_data'=>$user];
        $http_code=200;
        
        saida:
            
            $is_view=(!$request->ajax() && !$request->wantsJson());
            
            
            if($retorno['status']=='success'){
                return $this->retornoJsonDefault($retorno, $http_code);
                //return $is_view ? redirect($this->redirectTo) : $this->retornoJsonDefault($retorno, $http_code);
            }
            else{
                return $is_view ? redirect('login')
                ->with(array('message' => $retorno))
		->withInput() : $this->retornoJsonDefault($retorno, $http_code);
            }
            
    }
    protected function postLoginByToken($credentials){
         //'email', 'password'
      
      $user_model = \App\InstiUser::where('email', $credentials['email'])->first();

      // Validate Company
      if(!$user_model) {
        return response()->json([
          'error' => 'Invalid credentials'
        ], 401);
      }

      // Validate Password
      if (!Hash::check($credentials['password'], $user_model->password)) {
          return response()->json([
            'error' => 'Invalid credentials'
          ], 401);
      }

      // Generate Token
      $token = JWTAuth::fromUser($user_model);

      // Get expiration time
      $objectToken = JWTAuth::setToken($token);
      $expiration = JWTAuth::decode($objectToken->getToken())->get('exp');

      return response()->json([
        'access_token' => $token,
        'token_type' => 'bearer',
        'expires_in' => JWTAuth::decode()->get('exp')
      ]);
    }
     private function setCurrentGuard(){
         //Session::set('current_guard', $this->getGuardname()); 
        session(['current_guard'=>$this->getGuardname()]); 
        return $this;
    }
}
