<?php

namespace App\Core\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Session;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Http\Response;
use App\Support\AtmToken;
class InstiMid
{
    use \App\Traits\UserUtilsTrait;
    
    private function setUserFromIdToken($user_token_id){
        Auth::guard($this->getCurrentGuard())->loginUsingId($user_token_id,true);
        return $this;
    }
    private function checkPayLoad($pay_load){
        if(!$pay_load){ return false;}
        if(!isset($pay_load->api_token)){ return false;}
        /*Auth
        if(){
            
        }*/
        
    }
    
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        return $next($request);
          $expects=['/login','/logout','/logar', '/csr-xtoken'];
          $curr_path=$request->getRequestUri();  
        
        if(in_array($curr_path, $expects)){
            return $next($request);
        }
       
        //$hash="eyJpdiI6IlNsYkpGazQ5RlJuTHByQlFBTjRJZ2c9PSIsInZhbHVlIjoiNkFVcVRnbUJRcXBxUHdDOEhNNnNKbE5POXAwMTNERmlFb3ZrUW0rYzFSZFpOb0Y0MXpPd0d3ZXpvSTVpb0YwQ3l0TW1ZYk02VEYrUHhWK0ZVVTBUT0pWTmR2K0ZoVkxud2ZRMTNHa2pWZGV4VmJ2UG41UnRQZzhQRjc0a29JS2ZIYitmbGhjcGNkalR0dnRaTXVyR0NYWXVyK3R5SHJhakVCVG1xMUF1OFpiK1lQSUZFQ0FpcXpyeFN0TzZPaGNncGRWZkFJUWhHcEY5K3Frd0xPVEp4amg1cmc3SERpRmRjTTZJXC8xNEF2bmRBTWtPWGFZWk9hYW9mV2s5UnlWbGc1U3NMM1ExV3phWnZyWDN6QXlHdjRBPT0iLCJtYWMiOiJjZjk5NmQ1ZGM2NTZiNDQ1NmJjMzM1MWI3OWJiYjUxNjY4NTJmMmU1MWExZjc1NGQwZmZkYjljMzlmNjE2YmU4In0=";
        $hash=$request->bearerToken();
                
        if(empty($hash)){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 020920190850']), 301);
        }
        
        $now_timestamp= Carbon::now()->timestamp;
        $decrypted="";
        $decrypted=safeDecrypt($hash);
        $is_json=$request->ajax() || $request->wantsJson();
        $returnJson=function(){        
             return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Favor efetuar o login para ter acesso ao conteúdo',
                                            'submsg'=>'Erro: 300820191714']), 301); 
        };
        $returnView=function(){
            return redirect()->route('/login');
        };
        if(is_null($decrypted)){
            return $is_json? $returnJson() : $returnView();
        }
        $objt= json_decode($decrypted);
        $experes_in=isset($objt->expires_in) ? $objt->expires_in : 0;
        $user_token=isset($objt->token) ? $objt->token : null;
        $user_token_id=isset($user_token->id) ? intval($user_token->id) : 0;
        $api_token=new AtmToken(isset($user_token->api_token) ? json_decode(safeDecrypt($user_token->api_token)) : null);
        $user_data=$this->setUserFromIdToken($user_token->id)->getUserFromCurrentGuard();
        $user_token_db=new AtmToken(isset($user_data->api_token) ? json_decode(safeDecrypt($user_data->api_token)) : null); 
        
        if($experes_in<=$now_timestamp){
              return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token expirado. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191715']), 419); 
        }
        
        if(is_null($user_data)){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191716']), 301);
            
        }
        if($user_data->id!=$user_token_id){
             return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191717']), 301);
        }
        if(!$user_token_db->has()){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191905']), 301); 
        }
        if($user_token_db->getExpire()<=$now_timestamp){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token expirado. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191906']), 419); 
        }
        if($user_token_db->getTokenStr() != $api_token->getTokenStr()){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 300820191906']), 301);
        }
        if( $user_token_db->getIpClient() != get_client_ip()){
            return new Response(json_encode(['status'=>'error',
                                             'msg'=>'Token inválido. Faça o login novamente.',
                                            'submsg'=>'Erro: 081020191728']), 301);
        }
        
        $this->beforeContinue();
        
        return $next($request);
    }
    private function beforeContinue(){
        $this->getUserFromCurrentGuard()->setUnidadeSelecionada('U01');
        
    }
}
