<?php
namespace App\Core\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Auth\Access\Gate as GateContract;
//use App\Core\Providers\CustomUserProvider;
use App\Core\Providers\InstiUserProvider;
use Illuminate\Support\ServiceProvider;
//use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class InstiAuthProvider extends ServiceProvider {

    protected $policies = ['App\Model' => 'App\Policies\ModelPolicy',];

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    
    public function boot(GateContract $gate ){  
      
        Auth::provider('insti', function($app, array $config) {
            
         // Return an instance of             Illuminate\Contracts\Auth\UserProvider...
             return new InstiUserProvider('insti.connection');
        });
        
        $gate->define('rules', function ($user, $tag, $need_all=false) {
                $rules=is_string($tag) ? explode(',', $tag) : $tag;
             return $need_all===true? $user->getRulesByName($rules)->count()==count($rules) : $user->hasRule($rules);
        });
    }
   
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register(){
        
    }
}
