<?php

namespace App\Traits;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Contracts\Validation\Factory;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Log;

//use App\Traits\ErpModelsTraits;

use Auth;
use Carbon\Carbon;
use Yajra\Oci8\Eloquent\OracleEloquent as Eloquent;
Use App\Entities\historico\Historico;
Use App\Entities\historico\HistoricoDetalhes;

use DB;
use Config;
use Session;

trait AtmModelTraitObj
{
    //getConnectionName()
    protected $field_auto=['INSERIR'=>[
                                    'id_user',
                                    'criado_em',
                                    'criado_em_str',
                                    'hora_str',
                                    'criado_por',
                                    'filial',
                                    'cod_empresa',
                                    'cod_estab',
                                    'user_origin'],
                            'EDITAR'=>[
                                'modificado_em',
                                'id_user_modificado',
                                'modificado_por',
                                'modificado_por_origin']
                        ];
    protected $mode;//:::'INSERIR', 'EDITAR', 'DELETAR' track_history
    private $prepared_historic_data;
    private $old_data=[];
    private $new_data=[];
    protected function setMode($value){
        $value=trim(strtoupper($value));
        switch ($value) {
            case 'INSERIR':
            break;
            case 'EDITAR':
            break;
            case 'DELETAR':
            break;
            default:
                $value= 'NAO INFORMADO '.$value;
            break;
        }
        $this->mode=$value;
        return $this;
    }
    public function getMode(){ return $this->mode; }
    /*
     * É recomendando chamar esse metodo depois que usar os metodos
     * createErp, updateErp, deleteErp.
     * depois que estes metodos são utilizados não se consegue pegar o Dirty
     * É utilizado no preprarHistorico
     * @see preprarHistorico
     * @see getPreparedHistoricData
     */
    protected function getNewData(){ return empty($this->new_data)===false?:$this->getDirty(); }
    /**
     * Retorna apenas os dados antigos dos campos que foram alterados
     * se nenhum campo foi alterado retorna os valores antigos de todos os campos
     * Esse metodo também é recomendado a utilização apos createErp, updateErp, deleteErp.
     * @return MIXED ARRAY
     * @see preprarHistorico
     */
    protected function getOriginalData(){
         if(empty($this->old_data)===false){
              return $this->old_data;
         }
         foreach($this->getNewData() as $campo=>$valor){
            $this->old_data=array_add($this->old_data, $campo, $this->getOriginal($campo));
         }
         //:::Se não teve alterado devolve
         //::: todos os campos orinais
         //:: isso geralmente acontece no delete
         if(count($this->old_data)==0){
            $this->old_data=$this->getOriginal();
         }
         return $this->old_data;
    }
    public function teveAlteracao(){
         return empty($this->getNewData())===false;
    }
    /**
    * @param MIXED|ARRAY $dados
    * @param MIXED|ARRAY $rules
    * @param MIXED|ARRAY $messages Opcional
    * @param MIXED|ARRAY $customAttributes Opcional
    * @return $this instance
    */
    public function createAtm($dados, $rules, $messages=array(), $customAttributes=array()){
        $this->resetErpErro()->setMode('INSERIR');

        $validator = $this->validator($dados , $rules, $messages, $customAttributes);
          if ($validator->fails()) {
              foreach($validator->errors()->all() as $k=>$v){
                 $this->setErpErro($v);
              }
             goto saida;
           }
          
        $salvou=$this->prepareDados($dados)->save();
       //   $a=$this->prepareDados($dados)->getPreparedHistoricData();
          
         // var_dump($dados, $a);
        //  exit();
          
        if($salvou){
               try{
                    $this->saveHistorico();
               }
               catch (\Exception $e){
                    $this->setErpErro('Falha ao salvar o historico');
                    $this->setErpErro($e);
                    $this->emergencyMail('ERP - Falha ao salvar o historico - onINSERT', $e);                   
               }
          }
          else{
              $this->setErpErro('Não criou o registro');
          }
        saida:
        return $this;
     }
     /*
     * @param MIXED|ARRAY $dados
     * @param MIXED|ARRAY $rules
     * @param MIXED|ARRAY $messages Opcional
     * @param MIXED|ARRAY $customAttributes Opcional
     * @return $this instance
     */
     public function updateAtm($dados, $rules, $messages=array(), $customAttributes=array()){
          
        $this->resetErpErro()->setMode('EDITAR');
        $validator = $this->validator($dados , $rules, $messages, $customAttributes);
        if ($validator->fails()) {
            foreach($validator->errors()->all() as $k=>$v){
                $this->setErpErro($v);
            }
            goto saida;
        }
        $this->prepareDados($dados);
        if(!$this->isDirty()){//:::Se não teve alteração para não ter que salvar log
                $this->setErpErro('Não teve alteração os dados, por isso não foi feita a atualização.');
            goto saida;
        }
        if($this->save()){
             try{
               $this->saveHistorico();
            }
            catch (\Exception $e){
                $this->setErpErro('Falha ao salvar o historico');
                $this->setErpErro($e);
                $this->emergencyMail('ERP - Falha ao salvar o historico - onUPDATE', $e);
            }
        }else{
            $this->setErpErro('Não teve salvou');
        }
        saida:
            return $this;
     }
     /**
     * Delete e salva no log
     * @return Boolena|null o retorno é o mesmo do metodo delete de um MODEL
     */
     public function deleteAtm(){
        $this->resetErpErro()->setMode('DELETAR')->preprarHistorico();
        $deletou=$this->delete();
        if($deletou){
            try{
               $this->saveHistorico();
            }
            catch (\Exception $e){
               $this->setErpErro('Falha ao salvar o historico');
               $this->setErpErro($e);
               $this->emergencyMail('ERP - Falha ao salvar o historico - onDELETE', $e);
            }
        }

        return $deletou;
     }
     /**
         Faz o equivalente ao MassAssignment alem de incluir os campos automaticos
         @param $dados MIXED ARRAY
         @return $this
     */
    protected function prepareDados($dados){
        $colunas=$this->getNomeColunas(); //:::array com nomes das colunas da tabela
        $fillables=$this->getFillable(); //:::array com todas as colunas na propriedade fillable do model. OBS pode ter contem apenas uma chave com o valor *
        $guardeds=$this->getGuarded(); //:::array com todos os campos protegidos. OBS pode ter contem apenas uma chave com o valor *
        $nome_chave=$this->getNomeChavePrimaria(); //:::nome do campo chave primaria
        $totallyGuarded = $this->totallyGuarded(); //:::se todos os campos so protegidos
        $changed=[];
        if($totallyGuarded){
             abort(500,'O model nao aceita preenchimento massivo. Massive Assigns Error.');
            // \App::abort(500, 'Something bad happened');
        }
        //$this->getConnection()->getPdo()
       // var_dump('++++++',$this->getConnection());
       // exit();
        foreach($colunas as $k=>$v){
            //:::Se é a chave primaria ignora
            //:::Caso seja chave primaria composta continua
            if($nome_chave==$v && $nome_chave=='id' && is_array($nome_chave)===false){
                continue;
            }
            //:::Se não é um campo de preenchimento automatico verificar:
            if(in_array($v, $this->field_auto[$this->getMode()])===false){
                //:::Se esta protegido
                if($this->isGuarded($v)===true && count($guardeds)>=1 && $guardeds[0]!='*'){
                    continue; //ignorar
                }
                //:::Se não é fillable
                //:::Se campo não esta na lista dos fillables
                if($this->isFillable($v)===false ||
                     (count($fillables)>=1 && $fillables[0]!='*' && in_array($v,$fillables)===false)){
                    continue; //:::ignorar
                }
                //:::Se nao existe em dados
                if(!isset($dados[$v])){
                    continue;
                }
                //::Se esta no modo editar

                if($this->getMode()=='EDITAR'){
                    if($this[$v]==$dados[$v]){ //:::verifica se teve alteração. Poderia usar o metodo dirty
                        continue;
                    }
                    $changed[]=$v;
                }
                $this[$v]=$dados[$v];
            }
            else{ //:::Se e um campo de preenchimento automatico
                $this[$v]=isset($dados[$v]) ? $dados[$v]: '';//'nada';//:::O valor é alterado automaticamente no mutator
            }
        }
        //:::Se nenhum campo foi alterado e o modo é editar
        //:::Evita que apenas o campo modificado em  seja salvo no log
        if(count($changed)==0 && $this->getMode()=='EDITAR'){
            $this->syncOriginal(); //:::Volta os campos automaticos para os valores originais
        }
       
        $this->preprarHistorico();
        return $this;
    }
    public function getPreparedHistoricData(){
        if(is_null($this->prepared_historic_data)){
            $this->prepared_historic_data=(Object)['novo'=>[], 'antigo'=>[]];
        }
        return $this->prepared_historic_data;
    }
    /**
    * Separa os dados antigos e os novos de um registro em um model
    * set o valor para a propriedade prepared_historic_data= Object  um objeto com as propriedades novo, antigo ambos
    array associativo onde as chaves são os nomes dos campos
     @return  this
    */
    protected function preprarHistorico(){
        $dados_antigos=[];
        $dados_novos=[];
        //:::Se não teve alteração pega todos os dados antigos
        //:::Geralmente isso acontece na operação de delete
        if(!$this->isDirty()){
            $dados_antigos=$this->getOriginal();
            goto saida;
        }
        //:::Se teve alteracao pegar os dados antigos apenas dos campos que foram alterados
        $dados_novos=$this->getDirty();
        foreach($dados_novos as $k=>$v){
            $dados_antigos=array_add($dados_antigos, $k, $this->getOriginal($k));
        }
        saida:
          $this->prepared_historic_data= (Object)['novo'=>$dados_novos, 'antigo'=>$dados_antigos];
          return $this;
    }
    /**
    @param STRING $tipo
    @param STRING $observacao
    */
    protected function saveHistorico($observacao=''){
        $retorno=false;

        //::: Se não foi setado para salvar historico para o evento
        if(in_array($this->mode, $this->getTrackedsEvents())===false){
            goto saida;
        }
        //:::Separa o dados antigos e os novos;
        $dados=$this->getPreparedHistoricData();
        //$this->preprarHistorico();

        if(empty($dados->novo) && empty($dados->antigo)){
            goto saida;
        }

        $historico=new Historico();
        //::: Garante que o log vai ser salvo apenas
        //::: Na tabela de logo da emprea e não por filial

        $user=$this->getUserFromCurrentGuard();
        $conn_default=DB::getDefaultConnection();//$user->getConnectionName();
        $con_atual=$historico->getConnectionName();//getConnection();

        if(is_null($con_atual)===false && $con_atual!=$conn_default){
             $historico->setConnection($conn_default);
        }else{
             $con_atual=$conn_default;
        }
        if(is_array($campo_chave=$this->getNomeChavePrimaria())){
               $campo_chave_str=implode(',', $campo_chave);
        }
        else{
            $campo_chave_str=$campo_chave;
            $campo_chave=[$campo_chave];
        }
        $valor_chave=implode(',', array_map(function($atual){ 
                        return $this->getAttribute($atual);
            }, $campo_chave));
        $historico_data=[
                        'id_user'=>$this->fillIdUser(),
                        'login'=>$this->fillLogin(),
                        'nome'=>$this->fillCriadoPor(),
                        'conexao'=>$this->getConnectionName(),
                        'tabela'=>$this->getNomeTabela(),
                        'tipo'=>$this->mode,
                        'observacao'=>$observacao,
                        'criado_em'=>$this->fillCriadoEm(),
                        'data_str'=>$this->fillCriadoEm()->format('d/m/Y'),
                        'hora'=>$this->fillCriadoEm()->format('H:i:m'),
                        'campo_chave'=>$campo_chave_str,
                        'valor_chave'=>$valor_chave,
                        'ip_acesso'=>get_client_ip()];

        //:::Prepara os detalhes
        $campos=array_unique(array_merge(array_keys($dados->novo), array_keys($dados->antigo)));
        $detalhes=[];
        foreach($campos as $k=>$campo){
            $detalhes[]=new HistoricoDetalhes(['campo'=>$campo,
                                            'valor_antigo'=>isset($dados->antigo[$campo])? substr($dados->antigo[$campo],0,4000) :'',
                                            'valor_novo'=>isset($dados->novo[$campo])? substr($dados->novo[$campo],0,4000) :''
                                        ]);
        }
        //:::Salva no banco os historico
        //::: Se a conexao do model já esta com transaction
        if($this->getConnection()->getPdo()->inTransaction()==1){
            $historico->create($historico_data)
                    ->detalhes()
                    ->saveMany($detalhes);
            goto saida;
        }
         DB::transaction(function() use($historico, $historico_data, $detalhes){
            $historico->create($historico_data)
                    ->detalhes()
                    ->saveMany($detalhes);
         });

        saida:
         return $retorno;
    }
    
    private function emergencyMail($subject, $msg){
        mail('aluisio@insti.com.br', $subject, $msg);
    }
}