<?php

namespace App\Traits;

use Auth;
use Carbon\Carbon;

trait FieldAutofillTrait
{
   function fillCriadoEm($value=''){
          return Carbon::now();
     }
     function fillCriadoEmStr($value=''){
          return Carbon::now()->format('d/m/Y');
     }
     function fillHoraStr($value=''){
          return Carbon::now()->format('H:i:s');
     }
     function fillIdUser($value=''){
        return $this->getUserFromCurrentGuard() ? $this->getUserFromCurrentGuard()->id : $value ;
     }
      function fillCriadoPor($value=''){
         $user=$this->getUserFromCurrentGuard();
         return setUsuarioNomeTruncate($user ? $user->nome : $value);
     }
     function fillLogin($value=''){
         $user=$this->getUserFromCurrentGuard();
         return $user? $user->login : $value;
     }
     function fillFilial($value=''){
         $user=$this->getUserFromCurrentGuard();
         $filial=$user ? $user->getUnidadeSelecionada() : $value;
        return $filial;
     }
     protected function fillModificadoEm($value=''){
          return Carbon::now();
     }
     protected function fillIdUserModificado($value=''){
        return $this->getUserFromCurrentGuard() ? $this->getUserFromCurrentGuard()->id : $value;
     }
     protected function fillModificadoPor($value=''){
         $user=$this->getUserFromCurrentGuard();
         return setUsuarioNomeTruncate($user? $user->nome : $value);
     }
     protected function fillCodEmpresa($value=''){
          $user=$this->getUserFromCurrentGuard();
          if(!$user){
              return $value;
          }
          $filial=$user->getUnidadeSelecionada();
          $dados_filial=$user->getDadosFilialBySigla($filial);
          return $dados_filial->cod_empresa;
     }
     protected function fillCodEstab($value=''){
          $user=$this->getUserFromCurrentGuard();
          if(!$user){
              return $value;
          }
          $filial=$user->getUnidadeSelecionada();
          $dados_filial=$user->getDadosFilialBySigla($filial);
        return $dados_filial->cod_estab;
     }
     function getUnidadeSelecionada(){
        $user = $this->getUserFromCurrentGuard();
        return empty($user)? '' : $user->getUnidadeSelecionada();
   } 
}
