<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon;
use DB;
use Session;
//use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
//use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;

class InstiUser extends Authenticatable{
    use Notifiable;
 //   use Authenticatable, CanResetPassword;
    
   protected $table="institb_usuario"; 
   protected $primaryKey = 'id';
   private $token_object;   
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome', 'email', 'senha','api_token'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'senha', 'api_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function __construct(array $attributes = []){
       
    }
    
    public function getRememberToken(){
	   return null; // not supported
    }

    public function setRememberToken($value){
	   // not supported
    }
    public function getRememberTokenName(){ return null;}
    
     public function getAuthPassword(){ return trim($this->senha); }
    
    public function getJWTIdentifier() {
        return $this->getKey();
    }
    public function getJWTCustomClaims() {
        return [];
    }
    
    public function setTokenObject(){
         
        $expire= Carbon::now()->addHours(24)->timestamp;
        $access_token= safeEncrypt(json_encode(["time"=>time(),
                                             "expire"=>$expire,
                                             "token"=>Str::random(255),
                                             "ip"=>get_client_ip()]));
        $user_fields=['id'=>$this->id,
                      'nome'=>$this->nome,
                      'email'=>$this->email,
                      'api_token'=>$access_token];
        $token = safeEncrypt(json_encode($user_fields));
                
        $this->api_token=$access_token;
        $this->save();
        
        $this->token_object=[
                "expires_in"=> $expire,
                "token"=>$user_fields
        ];
        return $this;
    }
    public function getTokenObject(){ return $this->token_object; }
    
    public function getPermissionByFilial($filial){
            
            $sql='';
            $result = DB::select($sql, ['tipo'=>'P', 'filial'=>$filial, 'login' => $this->login]);
            $array = array_pluck($result, 'rotina');
            $this->setUnidadeSelecionada($filial);
            $this->setUserTags($array);
            return $array;

    }
    public function getAllFiliais(){
	$params=[];
      if($this->isRoot()){
            $sql="SELECT * FROM institb_empresa WHERE grupo_empresarial_id=2";
      }else{
        $sql="SELECT * FROM institb_empresa";
//        $params=['grupo_empresarial_id'=>'2'];
      }
        $result = DB::select($sql, $params);
        $cod_filial = array_pluck($result, 'filial');
        $array = array_combine($cod_filial, $result);
         return $array;
      }
    public function getFilialByPermission($permission){
        
        $params=[];
        
        if(is_array($permission)==false){
              $permission=[$permission];
         }
         $permission=  array_map(function($item){
                  return "".$item."";
            }, $permission);
         $str_permission=(count($permission)>1)? implode(',',$permission) : $permission[0];
    
         if($this->isRoot()){
            $sql="";
        }
        else{
            $sql='';
         $params=['tipo'=>'P','login' => $this->login,'permissao'=>$str_permission];
        }
        $result = DB::select($sql, $params);
        $array = array_pluck($result, 'filial');
		return $array;
    }
    public function setUnidadeSelecionada($filial){
         $this->unidade_selecionada=$filial;
            Session::put('user_unidade_selecionada', $filial);
    }
    public function getUnidadeSelecionada(){
	$this->unidade_selecionada= empty($this->unidade_selecionada) ? Session::get('user_unidade_selecionada') : $this->unidade_selecionada;
        return $this->unidade_selecionada;
    }
    public function setUserTags($tags){
        $this->tags=is_array($tags)?$tags: [];
        Session::put('user_tags', $this->tags);
    }
    public function isRoot(){
        $grant=array('PROGRAMACAO', 'DIRETORIA', 'PRESIDENCIA');
          return in_array($this->departamento, $grant)? true : false;
    }
    public function getUserTags(){
        $this->tags=empty($this->tags) ? Session::get('user_tags'): $this->tags;
        return $this->tags;
    }
    public function getMinhasFiliais(){
	$minhas_filiais = empty($this->minhas_filiais)?Session::get('user_minhas_filiais'):$this->minhas_filiais;
	if(empty($this->minhas_filiais)){
            $this->minhas_filiais = $this->getAllFiliais();
            Session::put('user_minhas_filiais', $this->minhas_filiais);
	}
	return $this->minhas_filiais;
    }
    public function getDadosFilialBySigla($sigla){
        $filiais=$this->getMinhasFiliais();
        if(!isset($filiais[$sigla])){
            return false;
        }
        return (object) $filiais[$sigla];
    }
    
    
    
    
    
    
}
