<?php

namespace App\Modules\Natureza51\Entities;

class CentroCusto extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id'
      ,'cod_ccusto'
      ,'des_ccusto'
      ,'ativo'
      ,'dat_inic_valid'
      ,'dat_fim_valid'
    ];

    protected $attributes = [
        'empresa_id' => '1', 'cod_ccusto' => '', 'des_ccusto'=> '', 'ativo'=> '', 
        'dat_inic_valid'=> '', 'dat_fim_valid'=> '', 'origem'=> '1'
    ];

    protected $table = 'tbl_ccusto';

    public function getEmpresa()
    {
      return $this->BelongsTo('App\Modules\Natureza51\Entities\Empresa', 'id', 'id' );
    }

    public function getContaContabil()
    {
      return $this->hasMany('App\Modules\Natureza51\Entities\ContaContabil', 'centro_custo_id', 'id' );
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
