<?php

namespace App\Modules\Natureza51\Entities;

class Funcionario extends NaturezaEntity
{
    protected $fillable = [        
      'empresa_id', 'cdn_funcionario', 'nome_funcionario'
      ,'num_reg_func', 'tp_func', 'dat_nascimento'
      ,'dat_admis_func', 'endereco_id', 'cpf'
      ,'plano_lotac_id', 'ccusto_id', 'ccusto_id'
      ,'turma_id', 'lotacao_id', 'recebe_pericul'
      ,'recebe_insal', 'func_sindlz', 'cargo_id'
      , 'nivel_hier', 'salario'
      ,'tb_ams_vip', 'vip_dir_exec', 'dt_estabi_ini'
      ,'dt_estabi_fim', 'dat_demis_func', 'tp_estabi','pt_admissao','pt_inclusao', 'pt_alteracao','pt_total', 'origem','is_demitido'
    ];

    protected $attributes = [
      'empresa_id' => '1', 'cdn_funcionario' => '', 'nome_funcionario' => ''
      ,'num_reg_func' => '', 'tp_func' => '1', 'dat_nascimento' => ''
      ,'dat_admis_func' => '', 'endereco_id' => '1', 'cpf' => ''
      ,'plano_lotac_id' => '', 'ccusto_id' => '1', 'ccusto_id' => ''
      ,'turma_id' => '', 'lotacao_id' => '', 'recebe_pericul' => ''
      ,'recebe_insal' => '', 'func_sindlz' => '', 'cargo_id' => ''
      , 'nivel_hier' => '', 'salario' => ''
      ,'tb_ams_vip' => '', 'vip_dir_exec' => '', 'dt_estabi_ini' => ''
      ,'dt_estabi_fim' => '','dat_demis_func'=>'', 'tp_estabi' => '','pt_admissao'=>'', 'pt_inclusao' =>'' ,'pt_alteracao'=>'', 'pt_total'=>'', 'origem' => '1','is_demitido'=>''
   ];
 
   public function getCargo(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Cargo','cargo_id', 'id');
   }  
   public function getCcusto(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\CentroCusto','ccusto_id', 'id');
   } 
   public function getLotacao(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
   }
   public function getTurma(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\Turma','turma_id','id');
   }
   public function getTpFunc(){
     return $this->belongsTo('App\Modules\Natureza51\Entities\TpFuncionario','tp_func','id');
   }
  //  public function getTpFunc(){
  //    return $this->belongsTo('App\Modules\Natureza51\Entities\TpFuncionario','tp_func','id');
  //  }

   protected $table = 'tbl_funcionario';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
}