<?php

namespace App\Modules\Natureza51\Entities;

class GrupoTreeTableColuna extends NaturezaEntity
{
    protected $fillable = [
        'nome_coluna'
      ,'descricao_coluna'
      ,'tipo_dado'
      ,'grupo_treetable_id'
      ,'valor_padrao'
    ];

    protected $attributes = [
        'nome_coluna' => '', 'descricao_coluna' => '', 'tipo_dado'=> '', 'grupo_treetable_id'=> '', 'valor_padrao'=> ''
    ];

    protected $table = 'tbl_grupo_treetable_coluna';

    public function getEmpresa()
    {
      return $this->BelongsTo('App\Modules\Natureza51\Entities\Empresa', 'id', 'id' );
    }

    public function getContaContabil()
    {
      return $this->hasMany('App\Modules\Natureza51\Entities\ContaContabil', 'centro_custo_id', 'id' );
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
