<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;


class LotacaoCCusto extends NaturezaEntity
{
    protected $fillable = [
        'per_insalub', 'per_pericul','estrutura_plano_lotac_id'
    ];

    protected $attributes = [
        'per_insalub',
        'per_pericul',
        'estrutura_plano_lotac_id',
        'cod_ccusto',
        'unid_lotac',
        'empresa_id'
    ];

    protected $guarded = ['id'];

    // protected $primaryKey = array('empresa_id', 'unid_lotac', 'cod_ccusto');
    protected $table = 'tbl_lotacao_ccusto';

    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','unid_lotac', 'unid_lotac');
    }

    public function getEstruturaPlanoLotac(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\EstruturaPlanoLotac','estrutura_plano_lotac_id', 'id');
    }

    public function getCentroCusto(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\CentroCusto','cod_ccusto', 'cod_ccusto');
    }
   const UPDATED_AT = null;
   const CREATED_AT = null;
}
