<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcBeneficio extends NaturezaEntity
{
    protected $fillable = [
        'empresa_id', 'evento_id', 'orcamento_id', 'beneficio_id',
        'tipo_calc', 'vlr_movto', 'vlr_depend', 'formula'
    ];
      

    protected $attributes = [
        'empresa_id' => '1', 'evento_id' => '', 'orcamento_id' => '', 'beneficio_id' => '',
        'tipo_calc' => '', 'vlr_movto' => '', 'vlr_depend' => '', 'formula'=>''
    ];

    protected $table = 'tbl_orc_beneficio';

    public function getEvento(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_id', 'id');
    }

    public function getCalcOrcamento(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CalcOrcamento','origem_id', 'id')->where('tbl_origem', 'tbl_orc_beneficio');
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}

