<?php

namespace App\Modules\Natureza51\Entities;

class OrcBonus extends NaturezaEntity
{
    protected $fillable = ['orc_id', 'cargo_id', 'ccusto_id','num_sal','porcentagem','user_id'];

    protected $attributes=['orc_id'=>'', 'cargo_id'=>'', 'num_sal'=>'','porcentagem'=>'','ccusto_id'=>1];
    
    protected $table = 'tbl_orc_bonus';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orc_id');
   }
   public function getCargo(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Cargo', 'id', 'cargo_id');
   }
   
}