<?php

namespace App\Modules\Natureza51\Entities;

class OrcCargo extends NaturezaEntity
{
    protected $fillable = [        
        'orcamento_id'
        ,'cargo_id'
        ,'sal_base'
        ,'sal_max'
        ,'sal_med'
        ,'sal_min'
        ,'data_calc'
        ,'grupo_salarial'
        ,'quadro_atual'
        ,'created_at'
        ,'user_id'
        ,'updated_at'
        ,'empresa_id'
    ];
    
    protected $attributes = [
        'empresa_id' => '1', 'cargo_id' => '', 'orcamento_id' => '', 'sal_base' => '',
        'sal_max' => '', 'sal_med' => '', 'sal_min' => '', 'data_calc'=>'', 
        'grupo_salarial' => '', 'quadro_atual'=>'', 'user_id'=>''
    ];

    protected $table = 'tbl_orc_cargo';

    public function getCargo(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Cargo','cargo_id', 'id');
    }
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }  
   
}