<?php

namespace App\Modules\Natureza51\Entities;

class OrcCargosAreaSal extends NaturezaEntity
{
    protected $table = 'tbl_orc_cargos_area_sal';
    protected $fillable = [ 
       'orcamento_id', 'cargo_id', 'lotacao_id', 'parametros_formula', 'sal_base', 'sal_maior', 'sal_med',
        'sal_menor', 'empresa_id','ccusto_id' 
   ];
    protected $attributes=['orcamento_id'=>'', 'cargo_id'=>'', 'lotacao_id'=>'', 'sal_base'=>'', 'sal_maior'=>'', 'sal_med'=>'',
        'sal_menor'=>'', 'parametros_formula'=>'1','empresa_id'=>'1','ccusto_id'=>'3'];
    
   
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }
   public function getCargo(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Cargo', 'id', 'cargo_id');
   }
   public function getLotacao(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Lotacao', 'id','lotacao_id');
   }
   
}