<?php
namespace App\Modules\Natureza51\Entities;

class OrcDespesas extends NaturezaEntity{
    protected $fillable=[
        'empresa_id',
        'orc_id',
        'despesa_id',
        'lotacao_id',
        'centro_custo_id',
        'valor_referencia'
    ];
    protected $attributes=[
        'empresa_id'=>'2',
        'orc_id'=>'',
        'despesa_id'=>'',
        'lotacao_id'=>'',
        'centro_custo_id'=>'',
        'valor_referencia'=>''
    ];
    
    const UPDATE_AT=null;
    const CREATED_AT=null;

    public function getDespesas(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Despesas','despesa_id','id');
    }
    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
    }
    protected $table='tbl_orc_despesas';
}