<?php

namespace App\Modules\Natureza51\Entities;

class OrcFerias extends NaturezaEntity
{
    
    //tbl_orc_ferias foi retirado pois não existia no BD
    protected $fillable = [ 'orcamento_id','lotacao_id', 'cargo_id', 'lotacao_responsavel','orc_turma_id','func_id','type','ccusto_id'];
    protected $attributes=['orcamento_id'=>'','lotacao_id'=>'', 'cargo_id'=>'', 'lotacao_responsavel'=>'','orc_turma_id'=>'','type'=>'','ccusto_id'=>'']; 
    
    
    protected $table = 'tbl_orc_ferias';
      
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }
   public function getCargo(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Cargo', 'id', 'cargo_id');
   }
   public function getLotacao(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Lotacao', 'id','lotacao_id');
   }
    
}