<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcLotFuncionatioBeneficio extends NaturezaEntity
{
    protected $fillable = [
        'orcamento_id', 'orc_lotacao_id', 'funcionario_id', 'orc_beneficio_id',
        'ccusto_id', 'tipo_calc', 'vlr_movto', 'vlr_depend', 'formula'
    ];
      

    protected $attributes = [
        'orcamento_id' => '', 'orc_lotacao_id' => '', 'funcionario_id' => '', 'orc_beneficio_id' => '',
        'ccusto_id' => '', 'tipo_calc' => '', 'vlr_movto' => '', 'vlr_depend' => '', 'formula'=>''
    ];

    protected $table = 'tbl_orc_beneficio_funcionario';
    
    public function getOrcBeneficio(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\OrcBeneficio','orc_beneficio_id', 'id');
    }

    public function getFuncionario(){
        return $this->hasOne('App\Modules\Natureza51\Entities\Funcionario','id', 'funcionario_id');
    }

    public function getCalcOrcamento(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CalcOrcamento','origem_id', 'id')->where('tbl_origem', 'tbl_orc_beneficio_funcionario');
    }

    public function getCentroCusto(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CentroCusto','id', 'ccusto_id');
    }
    public function getOrcLotacao(){
        return $this->hasOne('App\Modules\Natureza51\Entities\OrcLotacao','id','orc_lotacao_id');
    }
   const UPDATED_AT = null;
   const CREATED_AT = null;
    
}

