<?php

namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcLotacao extends NaturezaEntity
{
    protected $fillable = [
        'orcamento_id', 'lotacao_id','responder_orc', 'cc_custo_id'
    ];  
    
    protected $attributes=['orcamento_id'=>'','lotacao_id'=>'', 'responder_orc'=>'', 
        'cc_custo_id'=>''];   
    

    protected $table = 'tbl_orc_lotacao';

    public function getLotacao(){
        return $this->hasOne('App\Modules\Natureza51\Entities\Lotacao','id', 'lotacao_id');
    }   

    public function getCentroCusto(){
        return $this->hasOne('App\Modules\Natureza51\Entities\CentroCusto','id', 'cc_custo_id');
    }

   const UPDATED_AT = null;
   const CREATED_AT = null;
}